/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus;

import java.lang.reflect.Method;

class Plug {
    private final Method method;
    private final String methodName;
    private final Object object;
    private final Class<?> objectClass;
    private boolean hasParameter = false;

    public Plug(Object object, String string) {
        this.object = object;
        this.objectClass = this.object.getClass();
        this.methodName = string;
        this.method = this.initPlug();
    }

    public Plug(Object object, String string, boolean bl) {
        this.object = object;
        this.objectClass = this.object.getClass();
        this.methodName = string;
        this.hasParameter = bl;
        this.method = this.initPlug();
    }

    boolean hasParamter() {
        return this.hasParameter;
    }

    private boolean checkParameter(Class<?>[] classArray) throws Exception {
        if (this.hasParameter) {
            if (classArray.length == 2 && this.hasParameter) {
                Class<?> clazz = classArray[0];
                Class<?> clazz2 = classArray[1];
                if (clazz.getName().equals("float") && clazz2.getName().equals("float")) {
                    return true;
                }
                throw new RuntimeException("Your plugged method is only allowed to receive float values. Change you method signature from " + this.methodName + "(" + clazz.getName() + "," + clazz2.getName() + ") to:" + this.methodName + "(float x, float y).");
            }
            throw new RuntimeException("To plug a cross button method your method needs to receive two float values. Change you method signature to " + this.methodName + "(float x, float y).");
        }
        if (classArray.length == 0) {
            return true;
        }
        throw new RuntimeException("To plug a button method your method is not allowed to receive parameters.Change you method signature to " + this.methodName + "( ).");
    }

    private Method initPlug() {
        if (this.methodName != null && this.methodName.length() > 0) {
            Method[] methodArray = this.objectClass.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                methodArray[i].setAccessible(true);
                if (!methodArray[i].getName().equals(this.methodName)) continue;
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                try {
                    this.checkParameter(classArray);
                    return this.objectClass.getDeclaredMethod(this.methodName, classArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break;
                }
            }
        }
        throw new RuntimeException("Error on plug: >" + this.methodName + "< procontrol found no method with that name in the given object.");
    }

    void call(float f, float f2) {
        try {
            this.method.invoke(this.object, new Float(f), new Float(f2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error on calling plug: " + this.methodName);
        }
    }

    void call() {
        try {
            this.method.invoke(this.object, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error on calling plug: " + this.methodName);
        }
    }
}

