/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.util.Collections;
import java.util.LinkedList;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAbstractControl;
import org.gamecontrolplus.gui.MConstants;
import org.gamecontrolplus.gui.MConstantsInternal;
import processing.core.PApplet;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class MWindowImpl
implements MConstants,
MConstantsInternal {
    public LinkedList<MAbstractControl> windowControls = new LinkedList();
    public LinkedList<MAbstractControl> toRemove = new LinkedList();
    public LinkedList<MAbstractControl> toAdd = new LinkedList();
    PApplet app;
    PMatrix orgMatrix = null;

    public MWindowImpl(PApplet pApplet) {
        this.app = pApplet;
        PMatrix pMatrix = pApplet.getMatrix();
        if (pMatrix instanceof PMatrix3D) {
            this.orgMatrix = pMatrix;
        }
        this.registerMethods();
    }

    protected void registerMethods() {
        this.app.registerMethod("pre", (Object)this);
        this.app.registerMethod("draw", (Object)this);
        this.app.registerMethod("post", (Object)this);
        this.app.registerMethod("mouseEvent", (Object)this);
        this.app.registerMethod("keyEvent", (Object)this);
    }

    protected void unregisterMethods() {
        this.app.unregisterMethod("pre", (Object)this);
        this.app.unregisterMethod("draw", (Object)this);
        this.app.unregisterMethod("post", (Object)this);
        this.app.unregisterMethod("mouseEvent", (Object)this);
        this.app.unregisterMethod("keyEvent", (Object)this);
    }

    protected void addToWindow(MAbstractControl mAbstractControl) {
        if (!this.toAdd.contains(mAbstractControl) && !this.windowControls.contains(mAbstractControl)) {
            this.toAdd.add(mAbstractControl);
        }
    }

    protected void removeFromWindow(MAbstractControl mAbstractControl) {
        this.toRemove.add(mAbstractControl);
    }

    void setColorScheme(int n) {
        for (MAbstractControl mAbstractControl : this.windowControls) {
            mAbstractControl.setLocalColorScheme(n);
        }
    }

    void setAlpha(int n) {
        for (MAbstractControl mAbstractControl : this.windowControls) {
            mAbstractControl.setAlpha(n);
        }
    }

    public void draw() {
        this.app.pushMatrix();
        if (this.orgMatrix != null) {
            this.app.setMatrix(this.orgMatrix);
        }
        for (MAbstractControl mAbstractControl : this.windowControls) {
            if ((mAbstractControl.registeredMethods & 1) != 1) continue;
            mAbstractControl.draw();
        }
        this.app.popMatrix();
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        for (MAbstractControl mAbstractControl : this.windowControls) {
            if ((mAbstractControl.registeredMethods & 2) != 2) continue;
            mAbstractControl.mouseEvent(mouseEvent);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        for (MAbstractControl mAbstractControl : this.windowControls) {
            if ((mAbstractControl.registeredMethods & 8) != 8) continue;
            mAbstractControl.keyEvent(keyEvent);
        }
    }

    public void pre() {
        if (MAbstractControl.controlToTakeFocus != null && MAbstractControl.controlToTakeFocus.getPApplet() == this.app) {
            MAbstractControl.controlToTakeFocus.setFocus(true);
            MAbstractControl.controlToTakeFocus = null;
        }
        for (MAbstractControl mAbstractControl : this.windowControls) {
            if ((mAbstractControl.registeredMethods & 4) != 4) continue;
            mAbstractControl.pre();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() {
        if (M4P.cursorChangeEnabled) {
            if (MAbstractControl.cursorIsOver != null && MAbstractControl.cursorIsOver.getPApplet() == this.app) {
                this.app.cursor(MAbstractControl.cursorIsOver.cursorOver);
            } else {
                this.app.cursor(M4P.mouseOff);
            }
        }
        for (MAbstractControl iterator : this.windowControls) {
            if ((iterator.registeredMethods & 0x10) != 16) continue;
            iterator.post();
        }
        MWindowImpl mWindowImpl = this;
        synchronized (mWindowImpl) {
            if (!this.toRemove.isEmpty()) {
                for (MAbstractControl mAbstractControl : this.toRemove) {
                    if (MAbstractControl.focusIsWith == mAbstractControl) {
                        mAbstractControl.loseFocus(null);
                    }
                    mAbstractControl.buffer = null;
                    if (mAbstractControl.parent != null) {
                        mAbstractControl.parent.children.remove(mAbstractControl);
                        mAbstractControl.parent = null;
                    }
                    if (mAbstractControl.children != null) {
                        mAbstractControl.children.clear();
                    }
                    mAbstractControl.palette = null;
                    mAbstractControl.jpalette = null;
                    mAbstractControl.eventHandlerObject = null;
                    mAbstractControl.eventHandlerMethod = null;
                    mAbstractControl.winApp = null;
                    this.windowControls.remove(mAbstractControl);
                    System.gc();
                }
                this.toRemove.clear();
            }
            if (!this.toAdd.isEmpty()) {
                for (MAbstractControl mAbstractControl : this.toAdd) {
                    this.windowControls.add(mAbstractControl);
                }
                this.toAdd.clear();
                Collections.sort(this.windowControls, M4P.zorder);
            }
        }
    }
}

