/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAbstractControl;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MHotSpot;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

class MScrollbar
extends MAbstractControl {
    private static final int OFF_FILL = 3;
    private static final int OFF_STROKE = 0;
    private static final int OVER_FILL = 1;
    private static final int OVER_STROKE = 3;
    private static final int TRACK = 5;
    protected RoundRectangle2D lowCap;
    protected RoundRectangle2D highCap;
    protected float value = 0.2f;
    protected float filler = 0.5f;
    protected boolean autoHide = true;
    protected boolean currOverThumb = false;
    protected boolean isValueChanging = false;
    protected float last_ox;
    protected float last_oy;

    public MScrollbar(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
        this.hotspots = new MHotSpot[]{new MHotSpot.HSrect(1, 0.0f, 0.0f, 16.0f, this.height), new MHotSpot.HSrect(2, this.width - 16.0f, 0.0f, 16.0f, this.height), new MHotSpot.HSrect(9, 17.0f, 0.0f, this.width - 17.0f, this.height)};
        this.lowCap = new RoundRectangle2D.Float(1.0f, 1.0f, 15.0f, this.height - 2.0f, 6.0f, 6.0f);
        this.highCap = new RoundRectangle2D.Float(this.width - 15.0f, 1.0f, 14.5f, this.height - 2.0f, 6.0f, 6.0f);
        this.opaque = false;
        this.z = 24;
        this.registeredMethods = 3;
        this.cursorOver = 12;
        M4P.registerControl(this);
    }

    public void setAutoHide(boolean bl) {
        if (this.autoHide != bl) {
            this.autoHide = bl;
            if (this.autoHide && this.filler > 0.99999f) {
                this.visible = false;
            }
            this.bufferInvalid = true;
        }
    }

    public void setValue(float f) {
        if (f + this.filler > 1.0f) {
            this.filler = 1.0f - f;
        }
        this.value = f;
        this.visible = !this.autoHide || !(this.filler > 0.99999f);
        this.bufferInvalid = true;
    }

    public void setValue(float f, float f2) {
        if (f + f2 > 1.0f) {
            f = 1.0f - f2;
        }
        this.value = f;
        this.filler = f2;
        this.visible = !this.autoHide || !(this.filler > 0.99999f);
        this.bufferInvalid = true;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        int n = this.whichHotSpot(this.ox, this.oy);
        if (n >= 9) {
            n = this.isOverThumb(this.ox, this.oy) ? 10 : -1;
        }
        if (n != this.currSpot) {
            this.currSpot = n;
            this.bufferInvalid = true;
        }
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot < 0 || this.z <= MScrollbar.focusObjectZ()) break;
                this.dragging = false;
                this.last_ox = this.ox;
                this.last_oy = this.oy;
                this.takeFocus();
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                switch (this.currSpot) {
                    case 1: {
                        this.value -= 0.1f;
                        if (this.value < 0.0f) {
                            this.value = 0.0f;
                        }
                        this.bufferInvalid = true;
                        this.fireEvent(new Object[]{this, MEvent.CHANGED});
                        break;
                    }
                    case 2: {
                        this.value += 0.1f;
                        if ((double)(this.value + this.filler) > 1.0) {
                            this.value = 1.0f - this.filler;
                        }
                        this.bufferInvalid = true;
                        this.fireEvent(new Object[]{this, MEvent.CHANGED});
                    }
                }
                this.dragging = false;
                this.loseFocus(this.parent);
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.dragging) break;
                this.loseFocus(this.parent);
                this.dragging = false;
                this.isValueChanging = false;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                float f = this.ox - this.last_ox;
                this.last_ox = this.ox;
                float f2 = f / (this.width - 32.0f);
                this.value += f2;
                this.value = PApplet.constrain((float)this.value, (float)0.0f, (float)(1.0f - this.filler));
                this.isValueChanging = true;
                this.bufferInvalid = true;
                this.dragging = true;
                this.fireEvent(new Object[]{this, MEvent.CHANGED});
            }
        }
    }

    protected boolean isOverThumb(float f, float f2) {
        float f3 = (f - 16.0f) / (this.width - 32.0f);
        boolean bl = f3 >= this.value && f3 < this.value + this.filler;
        return bl;
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.buffer.beginDraw();
            this.bufferInvalid = false;
            Graphics2D graphics2D = this.buffer.g2;
            if (this.opaque) {
                this.buffer.background(this.buffer.color(255, 0));
                this.buffer.fill(this.palette[6]);
                this.buffer.noStroke();
                this.buffer.rect(8.0f, 0.0f, this.width - 16.0f, this.height);
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.fill(this.palette[5]);
            this.buffer.noStroke();
            this.buffer.rect(8.0f, 3.0f, this.width - 8.0f, this.height - 5.0f);
            graphics2D.setStroke(pen_1_0);
            this.buffer.strokeWeight(1.2f);
            if (this.currSpot == 1) {
                graphics2D.setColor(this.jpalette[1]);
                graphics2D.fill(this.lowCap);
                graphics2D.setColor(this.jpalette[3]);
                graphics2D.draw(this.lowCap);
            } else {
                graphics2D.setColor(this.jpalette[3]);
                graphics2D.fill(this.lowCap);
                graphics2D.setColor(this.jpalette[0]);
                graphics2D.draw(this.lowCap);
            }
            if (this.currSpot == 2) {
                graphics2D.setColor(this.jpalette[1]);
                graphics2D.fill(this.highCap);
                graphics2D.setColor(this.jpalette[3]);
                graphics2D.draw(this.highCap);
            } else {
                graphics2D.setColor(this.jpalette[3]);
                graphics2D.fill(this.highCap);
                graphics2D.setColor(this.jpalette[0]);
                graphics2D.draw(this.highCap);
            }
            float f = (this.width - 32.0f) * this.filler;
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(1.0f, 1.0f, f - 1.0f, this.height - 2.0f, 6.0f, 6.0f);
            this.buffer.translate((this.width - 32.0f) * this.value + 16.0f, 0.0f);
            if (this.currSpot == 10 || this.isValueChanging) {
                graphics2D.setColor(this.jpalette[1]);
                graphics2D.fill(float_);
                graphics2D.setColor(this.jpalette[3]);
                graphics2D.draw(float_);
            } else {
                graphics2D.setColor(this.jpalette[3]);
                graphics2D.fill(float_);
                graphics2D.setColor(this.jpalette[0]);
                graphics2D.draw(float_);
            }
            this.buffer.endDraw();
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        if (this.bufferInvalid) {
            this.updateBuffer();
        }
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.imageMode(3);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }
}

