/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAbstractControl;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MScrollbar;
import org.gamecontrolplus.gui.MStyledString;
import org.gamecontrolplus.gui.MTabManager;
import org.gamecontrolplus.gui.MTextBase;
import org.gamecontrolplus.gui.MTimer;
import processing.core.PApplet;
import processing.event.KeyEvent;

public abstract class MEditableTextControl
extends MTextBase {
    protected static float HORZ_SCROLL_RATE = 4.0f;
    protected static float VERT_SCROLL_RATE = 8.0f;
    MTabManager tabManager = null;
    protected MStyledString promptText = null;
    protected int wrapWidth = Integer.MAX_VALUE;
    protected float tx;
    protected float ty;
    protected float th;
    protected float tw;
    protected float ptx;
    protected float pty;
    protected float caretX;
    protected float caretY;
    protected boolean keepCursorInView = false;
    protected GeneralPath gpTextDisplayArea;
    protected MStyledString.TextLayoutHitInfo startTLHI = new MStyledString.TextLayoutHitInfo();
    protected MStyledString.TextLayoutHitInfo endTLHI = new MStyledString.TextLayoutHitInfo();
    protected final int scrollbarPolicy;
    protected boolean autoHide = false;
    protected MScrollbar hsb;
    protected MScrollbar vsb;
    protected MTimer caretFlasher;
    protected boolean showCaret = false;
    protected int endChar = -1;
    protected int startChar = -1;
    protected int pos = this.endChar;
    protected int nbr = 0;
    protected int adjust = 0;
    protected boolean textChanged = false;
    protected boolean selectionChanged = false;
    boolean textEditEnabled = true;

    public MEditableTextControl(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        super(pApplet, f, f2, f3, f4);
        this.scrollbarPolicy = n;
        this.autoHide = (n & 0x1000) == 4096;
        this.caretFlasher = new MTimer(pApplet, this, "flashCaret", 400);
        this.caretFlasher.start();
        this.opaque = true;
        this.cursorOver = 2;
    }

    @Override
    protected void loseFocus(MAbstractControl mAbstractControl) {
        int n;
        if (focusIsWith == this) {
            this.fireEvent(new Object[]{this, MEvent.LOST_FOCUS});
        }
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = mAbstractControl;
        if (this.stext.length() > 0 && (n = this.stext.getPlainText().trim().length()) == 0) {
            this.stext = new MStyledString("", this.wrapWidth);
        }
        this.keepCursorInView = true;
        this.bufferInvalid = true;
    }

    @Override
    protected void takeFocus() {
        if (focusIsWith != this) {
            if (focusIsWith != null) {
                focusIsWith.loseFocus(this);
            }
            this.fireEvent(new Object[]{this, MEvent.GETS_FOCUS});
        }
        focusIsWith = this;
    }

    @Override
    public void setFocus(boolean bl) {
        if (!bl) {
            this.loseFocus(null);
            return;
        }
        if (focusIsWith != this) {
            this.dragging = false;
            if (this.stext == null || this.stext.length() == 0) {
                this.stext = new MStyledString(" ", this.wrapWidth);
            }
            LinkedList<MStyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
            this.startTLHI = new MStyledString.TextLayoutHitInfo(linkedList.getFirst(), null);
            this.startTLHI.thi = this.startTLHI.tli.layout.getNextLeftHit(1);
            this.endTLHI = new MStyledString.TextLayoutHitInfo(linkedList.getLast(), null);
            int n = this.endTLHI.tli.layout.getCharacterCount();
            this.endTLHI.thi = this.startTLHI.tli.layout.getNextRightHit(n - 1);
            this.calculateCaretPos(this.endTLHI);
            this.bufferInvalid = true;
        }
        this.keepCursorInView = true;
        this.takeFocus();
    }

    public void setPromptText(String string) {
        if (string == null || string.length() == 0) {
            this.promptText = null;
        } else {
            this.promptText = new MStyledString(string, this.wrapWidth);
            this.promptText.addAttribute(M4P.POSTURE, M4P.POSTURE_OBLIQUE);
        }
        this.bufferInvalid = true;
    }

    public int getWrapWidth() {
        return this.wrapWidth;
    }

    public void setWrapWidth(int n) {
        this.wrapWidth = n;
    }

    public String getPromptText() {
        return this.promptText.getPlainText();
    }

    @Override
    public String getText() {
        return this.stext.getPlainText();
    }

    @Override
    public MStyledString getStyledText() {
        return this.stext;
    }

    public void addStyle(TextAttribute textAttribute, Object object, int n, int n2) {
        if (this.stext != null) {
            this.stext.addAttribute(textAttribute, object, n, n2);
            this.bufferInvalid = true;
        }
    }

    public void addStyle(TextAttribute textAttribute, Object object) {
        if (this.stext != null) {
            this.stext.addAttribute(textAttribute, object);
            this.bufferInvalid = true;
        }
    }

    public void clearStyles(int n, int n2) {
        if (this.stext != null) {
            this.stext.clearAttributes(n, n2);
            this.bufferInvalid = true;
        }
    }

    public void clearStyles() {
        if (this.stext != null) {
            this.stext.clearAttributes();
            this.bufferInvalid = true;
        }
    }

    @Override
    public void setFont(Font font) {
        if (font != null && font != this.localFont && this.buffer != null) {
            this.localFont = font;
            this.buffer.g2.setFont(this.localFont);
            this.stext.getLines(this.buffer.g2);
            this.pty = 0.0f;
            this.ptx = 0.0f;
            this.setScrollbarValues(this.ptx, this.pty);
            this.bufferInvalid = true;
        }
    }

    public String getSelectedText() {
        MStyledString.TextLayoutHitInfo textLayoutHitInfo;
        MStyledString.TextLayoutHitInfo textLayoutHitInfo2;
        if (!this.hasSelection()) {
            return "";
        }
        if (this.endTLHI.compareTo(this.startTLHI) == -1) {
            textLayoutHitInfo2 = this.endTLHI;
            textLayoutHitInfo = this.startTLHI;
        } else {
            textLayoutHitInfo2 = this.startTLHI;
            textLayoutHitInfo = this.endTLHI;
        }
        int n = textLayoutHitInfo2.tli.startCharIndex + textLayoutHitInfo2.thi.getInsertionIndex();
        int n2 = textLayoutHitInfo.tli.startCharIndex + textLayoutHitInfo.thi.getInsertionIndex();
        String string = this.stext.getPlainText().substring(n, n2);
        return string;
    }

    public void setSelectedTextStyle(TextAttribute textAttribute, Object object) {
        MStyledString.TextLayoutHitInfo textLayoutHitInfo;
        MStyledString.TextLayoutHitInfo textLayoutHitInfo2;
        if (!this.hasSelection()) {
            return;
        }
        if (this.endTLHI.compareTo(this.startTLHI) == -1) {
            textLayoutHitInfo2 = this.endTLHI;
            textLayoutHitInfo = this.startTLHI;
        } else {
            textLayoutHitInfo2 = this.startTLHI;
            textLayoutHitInfo = this.endTLHI;
        }
        int n = textLayoutHitInfo2.tli.startCharIndex + textLayoutHitInfo2.thi.getInsertionIndex();
        int n2 = textLayoutHitInfo.tli.startCharIndex + textLayoutHitInfo.thi.getInsertionIndex();
        this.stext.addAttribute(textAttribute, object, n, n2);
        this.stext.getLines(this.buffer.g2);
        textLayoutHitInfo.tli = this.stext.getTLIforCharNo(n2);
        int n3 = n2 - textLayoutHitInfo.tli.startCharIndex;
        textLayoutHitInfo.thi = n3 == 0 ? textLayoutHitInfo.tli.layout.getNextLeftHit(1) : textLayoutHitInfo.tli.layout.getNextRightHit(n3 - 1);
        this.bufferInvalid = true;
    }

    public void clearSelectionStyle() {
        MStyledString.TextLayoutHitInfo textLayoutHitInfo;
        MStyledString.TextLayoutHitInfo textLayoutHitInfo2;
        if (!this.hasSelection()) {
            return;
        }
        if (this.endTLHI.compareTo(this.startTLHI) == -1) {
            textLayoutHitInfo2 = this.endTLHI;
            textLayoutHitInfo = this.startTLHI;
        } else {
            textLayoutHitInfo2 = this.startTLHI;
            textLayoutHitInfo = this.endTLHI;
        }
        int n = textLayoutHitInfo2.tli.startCharIndex + textLayoutHitInfo2.thi.getInsertionIndex();
        int n2 = textLayoutHitInfo.tli.startCharIndex + textLayoutHitInfo.thi.getInsertionIndex();
        this.stext.clearAttributes(n, n2);
        this.stext.getLines(this.buffer.g2);
        textLayoutHitInfo.tli = this.stext.getTLIforCharNo(n2);
        int n3 = n2 - textLayoutHitInfo.tli.startCharIndex;
        textLayoutHitInfo.thi = n3 == 0 ? textLayoutHitInfo.tli.layout.getNextLeftHit(1) : textLayoutHitInfo.tli.layout.getNextRightHit(n3 - 1);
        this.bufferInvalid = true;
    }

    void setScrollbarValues(float f, float f2) {
        float f3;
        if (this.vsb != null) {
            f3 = this.stext.getTextAreaHeight();
            if (f3 < this.th) {
                this.vsb.setValue(0.0f, 1.0f);
            } else {
                this.vsb.setValue(f2 / f3, this.th / f3);
            }
        }
        if (this.hsb != null) {
            f3 = this.stext.getMaxLineLength();
            if (this.stext.getMaxLineLength() < this.tw) {
                this.hsb.setValue(0.0f, 1.0f);
            } else {
                this.hsb.setValue(f / f3, this.tw / f3);
            }
        }
    }

    protected boolean moveCaretStartOfLine(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    protected boolean moveCaretEndOfLine(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretLeft(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextLeftHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            return false;
        }
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    protected boolean moveCaretRight(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            return false;
        }
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    public void setJustify(boolean bl) {
        this.stext.setJustify(bl);
        this.bufferInvalid = true;
    }

    @Override
    public void setLocalColorScheme(int n) {
        super.setLocalColorScheme(n);
        if (this.hsb != null) {
            this.hsb.setLocalColorScheme(this.localColorScheme);
        }
        if (this.vsb != null) {
            this.vsb.setLocalColorScheme(this.localColorScheme);
        }
    }

    public boolean hasSelection() {
        return this.startTLHI.tli != null && this.endTLHI.tli != null && this.startTLHI.compareTo(this.endTLHI) != 0;
    }

    protected void calculateCaretPos(MStyledString.TextLayoutHitInfo textLayoutHitInfo) {
        float[] fArray = textLayoutHitInfo.tli.layout.getCaretInfo(textLayoutHitInfo.thi);
        this.caretX = fArray[0];
        this.caretY = textLayoutHitInfo.tli.yPosInPara;
    }

    public void setTextEditEnabled(boolean bl) {
        if (!bl && focusIsWith == this) {
            this.loseFocus(null);
        }
        this.enabled = bl;
        this.textEditEnabled = bl;
    }

    public boolean isTextEditEnabled() {
        return this.textEditEnabled;
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        if (!(this.visible && this.enabled && this.textEditEnabled && this.available)) {
            return;
        }
        if (focusIsWith == this && this.endTLHI != null) {
            char c = keyEvent.getKey();
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getAction();
            boolean bl = keyEvent.isShiftDown();
            boolean bl2 = keyEvent.isControlDown();
            this.textChanged = false;
            this.keepCursorInView = true;
            int n3 = this.pos;
            int n4 = this.nbr;
            this.endChar = this.endTLHI.tli.startCharIndex + this.endTLHI.thi.getInsertionIndex();
            this.startChar = this.startTLHI != null ? this.startTLHI.tli.startCharIndex + this.startTLHI.thi.getInsertionIndex() : this.endChar;
            this.pos = this.endChar;
            this.nbr = 0;
            this.adjust = 0;
            if (this.endChar != this.startChar) {
                if (this.startChar < this.endChar) {
                    this.pos = this.startChar;
                    this.nbr = this.endChar - this.pos;
                } else if (this.startChar > this.endChar) {
                    this.pos = this.endChar;
                    this.nbr = this.startChar - this.pos;
                }
            }
            if (n3 >= 0 && (n3 != this.pos || n4 != this.nbr)) {
                this.fireEvent(new Object[]{this, MEvent.SELECTION_CHANGED});
            }
            if (n2 == 1) {
                this.keyPressedProcess(n, c, bl, bl2);
                this.setScrollbarValues(this.ptx, this.pty);
            } else if (n2 == 3) {
                this.keyTypedProcess(n, c, bl, bl2);
                this.setScrollbarValues(this.ptx, this.pty);
            }
            if (this.textChanged) {
                this.changeText();
                this.fireEvent(new Object[]{this, MEvent.CHANGED});
            }
        }
    }

    protected void keyPressedProcess(int n, char c, boolean bl, boolean bl2) {
    }

    protected void keyTypedProcess(int n, char c, boolean bl, boolean bl2) {
    }

    protected boolean changeText() {
        TextHitInfo textHitInfo = null;
        TextHitInfo textHitInfo2 = null;
        this.pos += this.adjust;
        this.stext.getLines(this.buffer.g2);
        MStyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforCharNo(this.pos);
        if (textLayoutInfo == null) {
            this.endTLHI = null;
            this.startTLHI = null;
            this.pty = 0.0f;
            this.ptx = 0.0f;
            this.caretY = 0.0f;
            this.caretX = 0.0f;
            return false;
        }
        int n = this.pos - textLayoutInfo.startCharIndex;
        try {
            textHitInfo2 = textLayoutInfo.layout.getNextRightHit(n);
        }
        catch (Exception exception) {
            textHitInfo2 = null;
        }
        textHitInfo = n <= 0 ? textLayoutInfo.layout.getNextLeftHit(textHitInfo2) : (n >= textLayoutInfo.nbrChars ? textLayoutInfo.layout.getNextRightHit(textLayoutInfo.nbrChars - 1) : textLayoutInfo.layout.getNextLeftHit(textHitInfo2));
        this.endTLHI.setInfo(textLayoutInfo, textHitInfo);
        this.calculateCaretPos(this.endTLHI);
        this.bufferInvalid = true;
        return true;
    }

    public void flashCaret(MTimer mTimer) {
        this.showCaret = !this.showCaret;
    }

    public void hsbEventHandler(MScrollbar mScrollbar, MEvent mEvent) {
        this.keepCursorInView = false;
        this.ptx = this.hsb.getValue() * (this.stext.getMaxLineLength() + 4.0f);
        this.bufferInvalid = true;
    }

    public void vsbEventHandler(MScrollbar mScrollbar, MEvent mEvent) {
        this.keepCursorInView = false;
        this.pty = this.vsb.getValue() * (this.stext.getTextAreaHeight() + 1.5f * this.stext.getMaxLineHeight());
        this.bufferInvalid = true;
    }

    @Override
    public void markForDisposal() {
        if (this.tabManager != null) {
            this.tabManager.removeControl(this);
        }
        super.markForDisposal();
    }

    @Override
    public boolean saveText(String string) {
        if (this.stext == null) {
            return false;
        }
        if (this.hasSelection()) {
            this.stext.startIdx = this.startTLHI.tli.startCharIndex + this.startTLHI.thi.getInsertionIndex();
            this.stext.endIdx = this.endTLHI.tli.startCharIndex + this.endTLHI.thi.getInsertionIndex();
        } else {
            this.stext.endIdx = -1;
            this.stext.startIdx = -1;
        }
        MStyledString.save(this.winApp, this.stext, string);
        return true;
    }

    @Override
    public boolean loadText(String string) {
        MStyledString mStyledString = MStyledString.load(this.winApp, string);
        if (mStyledString == null) {
            return false;
        }
        this.setStyledText(mStyledString);
        if (this.stext.startIdx >= 0) {
            this.startTLHI = new MStyledString.TextLayoutHitInfo();
            this.startTLHI.tli = this.stext.getTLIforCharNo(this.stext.startIdx);
            int n = this.stext.startIdx - this.startTLHI.tli.startCharIndex;
            this.startTLHI.thi = n == 0 ? this.startTLHI.tli.layout.getNextLeftHit(1) : this.startTLHI.tli.layout.getNextRightHit(n - 1);
            this.endTLHI = new MStyledString.TextLayoutHitInfo();
            this.endTLHI.tli = this.stext.getTLIforCharNo(this.stext.endIdx);
            n = this.stext.endIdx - this.endTLHI.tli.startCharIndex;
            this.endTLHI.thi = n == 0 ? this.endTLHI.tli.layout.getNextLeftHit(1) : this.endTLHI.tli.layout.getNextRightHit(n - 1);
            this.calculateCaretPos(this.endTLHI);
        }
        this.bufferInvalid = true;
        return true;
    }
}

