/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.util.LinkedList;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MHotSpot;
import org.gamecontrolplus.gui.MStyledString;
import org.gamecontrolplus.gui.MTextIconAlignBase;
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class MButton
extends MTextIconAlignBase {
    protected int status = 0;
    protected boolean reportAllButtonEvents = false;

    public MButton(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, "");
    }

    public MButton(PApplet pApplet, float f, float f2, float f3, float f4, String string) {
        super(pApplet, f, f2, f3, f4);
        this.hotspots = new MHotSpot[]{new MHotSpot.HSrect(1, 0.0f, 0.0f, this.width, this.height)};
        this.setText(string);
        this.z = 24;
        this.createEventHandler(M4P.sketchWindow, "handleButtonEvents", new Class[]{MButton.class, MEvent.class}, new String[]{"button", "event"});
        this.registeredMethods = 3;
        this.cursorOver = 12;
        M4P.registerControl(this);
    }

    public void fireAllEvents(boolean bl) {
        this.reportAllButtonEvents = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.status = 0;
        }
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot >= 0 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (focusIsWith == this || this.currSpot < 0 || this.z <= MButton.focusObjectZ()) break;
                this.dragging = false;
                this.status = 2;
                this.takeFocus();
                if (this.reportAllButtonEvents) {
                    this.fireEvent(new Object[]{this, MEvent.PRESSED});
                }
                this.bufferInvalid = true;
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.bufferInvalid = true;
                this.loseFocus(null);
                this.dragging = false;
                this.fireEvent(new Object[]{this, MEvent.CLICKED});
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.dragging) break;
                if (this.reportAllButtonEvents) {
                    this.fireEvent(new Object[]{this, MEvent.RELEASED});
                }
                this.dragging = false;
                this.loseFocus(null);
                this.status = 0;
                this.bufferInvalid = true;
                break;
            }
            case 5: {
                int n = this.status;
                this.status = this.currSpot >= 0 ? 1 : 0;
                if (n == this.status) break;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                this.dragging = focusIsWith == this;
            }
        }
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            LinkedList<MStyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            this.bufferInvalid = false;
            switch (this.status) {
                case 1: {
                    this.buffer.background(this.palette[6]);
                    break;
                }
                case 2: {
                    this.buffer.background(this.palette[14]);
                    break;
                }
                default: {
                    this.buffer.background(this.palette[4]);
                }
            }
            graphics2D.setColor(this.jpalette[3]);
            graphics2D.setStroke(pen_1_0);
            graphics2D.drawRect(0, 0, (int)this.width - 1, (int)this.height - 1);
            this.calcAlignment();
            if (this.iconW != 0) {
                this.buffer.image(this.bicon[this.status], (float)this.siX, (float)this.siY);
            }
            float f = this.stext.getWrapWidth();
            float f2 = 0.0f;
            float f3 = 0.0f;
            this.buffer.translate(this.stX, this.stY);
            for (MStyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                switch (this.textAlignH) {
                    case CENTER: {
                        f3 = textLayout.getVisibleAdvance();
                        f3 = f3 > f ? f3 - f : f3;
                        f2 = (f - f3) / 2.0f;
                        break;
                    }
                    case RIGHT: {
                        f3 = textLayout.getVisibleAdvance();
                        f3 = f3 > f ? f3 - f : f3;
                        f2 = f - f3;
                        break;
                    }
                    default: {
                        f2 = 0.0f;
                    }
                }
                graphics2D.setColor(this.jpalette[2]);
                textLayoutInfo.layout.draw(graphics2D, f2, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            this.buffer.endDraw();
        }
    }
}

