/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus;

import java.util.List;
import net.java.games.input.Component;
import org.gamecontrolplus.ControlButton;
import org.gamecontrolplus.Plug;
import processing.core.PApplet;

public class ControlHat
extends ControlButton {
    private static final int OFF = 0;
    private static final int UP_LEFT = 1;
    private static final int UP = 2;
    private static final int UP_RIGHT = 3;
    private static final int RIGHT = 4;
    private static final int DOWN_RIGHT = 5;
    private static final int DOWN = 6;
    private static final int DOWN_LEFT = 7;
    private static final int LEFT = 8;
    private float x = 0.0f;
    private float y = 0.0f;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private static float DIAGONAL_FACTOR = (float)Math.sin(0.7853981852531433);
    private float change = 1.0f;
    private float diagonalChange = DIAGONAL_FACTOR;

    ControlHat(Component component, PApplet pApplet) {
        super(component, pApplet);
        this.inputType = 2;
    }

    @Override
    void update() {
        super.update();
        this.right = false;
        this.left = false;
        this.down = false;
        this.up = false;
        switch ((int)this.actualValue) {
            case 6: {
                this.down = true;
                this.y = this.change;
                break;
            }
            case 7: {
                this.down = true;
                this.left = true;
                this.x = -this.diagonalChange;
                this.y = this.diagonalChange;
                break;
            }
            case 8: {
                this.left = true;
                this.x = -this.change;
                break;
            }
            case 1: {
                this.up = true;
                this.left = true;
                this.x = -this.diagonalChange;
                this.y = -this.diagonalChange;
                break;
            }
            case 2: {
                this.up = true;
                this.y = -this.change;
                break;
            }
            case 3: {
                this.up = true;
                this.right = true;
                this.x = this.diagonalChange;
                this.y = -this.diagonalChange;
                break;
            }
            case 4: {
                this.right = true;
                this.x = this.change;
                break;
            }
            case 5: {
                this.down = true;
                this.right = true;
                this.x = this.diagonalChange;
                this.y = this.diagonalChange;
                break;
            }
            case 0: {
                this.x = 0.0f;
                this.y = 0.0f;
            }
        }
    }

    @Override
    public String getName() {
        return "cooliehat: " + super.getName();
    }

    public boolean up() {
        return this.up;
    }

    public boolean down() {
        return this.down;
    }

    public boolean left() {
        return this.left;
    }

    public boolean right() {
        return this.right;
    }

    public int getPos() {
        return Math.round(this.actualValue);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    @Override
    public String toText(String string) {
        String string2 = this.actualName.length() > 20 ? this.actualName.substring(0, 17) + "..." : (this.actualName + "                    ").substring(0, 20);
        String string3 = (String.valueOf(this.multiplier) + "            ").substring(0, 15);
        return string + "hat       " + string2 + string3;
    }

    @Override
    public void plug(Object object, String string, int n) {
        List list;
        Plug plug = new Plug(object, string, true);
        switch (n) {
            case 0: {
                list = this.onPressPlugs;
                break;
            }
            case 1: {
                list = this.onReleasePlugs;
                break;
            }
            case 2: {
                list = this.whilePressPlugs;
                break;
            }
            default: {
                throw new RuntimeException("Error on plug " + string + " check the given event type");
            }
        }
        list.add(plug);
    }

    @Override
    protected void callPlugs(List<Plug> list) {
        for (int i = 0; i < list.size(); ++i) {
            Plug plug = list.get(i);
            plug.call(this.x, this.y);
        }
    }
}

