/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import ddf.minim.ugens.Instrument;
import ddf.minim.ugens.Line;
import ddf.minim.ugens.Oscil;
import ddf.minim.ugens.Waveform;
import ddf.minim.ugens.Waves;
import java.util.ArrayList;
import org.gamecontrolplus.ControlDevice;
import org.gamecontrolplus.ControlIO;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class stardrive
extends PApplet {
    Minim minim;
    AudioOutput[] audioOut = null;
    AudioOutput audioOutCentre = null;
    float fSoundDuration = 0.1f;
    String[] sSoundBoost = new String[]{"C3", "E3"};
    String sSoundShotFired = "C5";
    String sSoundShotHit = "E4";
    String sSoundLanded = "F3";
    String sSoundCollision = "A3";
    String sSoundShipDestroyed = "D4";
    String sSoundTileDestroyed = "B2";
    String sSoundGameMenu = "B5";
    String sSoundGameGetReady = "G3";
    String sSoundGameStart = "G3";
    String sSoundGameOver = "F5";
    String sSoundGameResults = "G4";
    String sSoundBalloonLaunch = "B3";
    String sSoundBeep = "A4";
    int iResLowX = 320;
    int iResLowY = 200;
    float fFactor = 1.0f;
    int iOffsetX = 0;
    int iOffsetY = 0;
    PGraphics pBackground;
    int iTicksLast = 0;
    ControlIO control;
    ControlDevice joystick0;
    ControlDevice joystick1;
    boolean[] bJoystick0Controls = new boolean[4];
    boolean[] bJoystick1Controls = new boolean[4];
    int buttonNumber = 12;
    int[] joypadButtons;
    boolean gamepad;
    boolean but;
    int iTileSize;
    int iTileSizeHalf;
    int iTileMaxX;
    int iTileMaxY;
    Level level;
    int iPlayers;
    Ship[] ships;
    int iShotsMax;
    Shot[] shots;
    int iParticlesMax;
    Particle[] particles;
    int iPeopleMax;
    Person[] people;
    int iTreesMax;
    Tree[] trees;
    float fGravity;
    float fSpeedMax;
    int iScreen;
    int cGreen;
    int cGreenMediumBright;
    int cGreenMedium;
    int cGreenDark;
    int cDark;
    int iLoser;
    PImage pLogo;
    PImage pTilesheet;
    int iTextSize;
    PFont fontBitmapped;
    PFont fontBitmapped45;
    int iTicksGetReadyElapsed;
    int iTicksGetReady;
    int iTicksButtonPressedLast;
    int iTicksTimeOut;
    int iCountdownOld;

    public stardrive() {
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        this.joypadButtons = nArray;
        this.gamepad = false;
        this.but = false;
        this.iTileSize = 16;
        this.iTileSizeHalf = PApplet.parseInt((float)((float)this.iTileSize * 0.5f));
        this.iTileMaxX = 80;
        this.iTileMaxY = 80;
        this.level = null;
        this.iPlayers = 2;
        this.ships = null;
        this.iShotsMax = 100;
        this.shots = null;
        this.iParticlesMax = 100;
        this.particles = null;
        this.iPeopleMax = 20;
        this.people = null;
        this.iTreesMax = 12;
        this.trees = null;
        this.fGravity = 0.8f;
        this.fSpeedMax = 70.0f;
        this.iScreen = 0;
        this.cGreen = this.color(20, 220, 0);
        this.cGreenMediumBright = this.color(20, 160, 0);
        this.cGreenMedium = this.color(8, 110, 0);
        this.cGreenDark = this.color(4, 40, 0, 220);
        this.cDark = this.color(0, 0, 0, 120);
        this.iLoser = -1;
        this.pLogo = null;
        this.pTilesheet = null;
        this.iTextSize = 13;
        this.fontBitmapped = null;
        this.fontBitmapped45 = null;
        this.iTicksGetReadyElapsed = 0;
        this.iTicksGetReady = 3000;
        this.iTicksButtonPressedLast = 0;
        this.iTicksTimeOut = 25000;
        this.iCountdownOld = 0;
    }

    public void setup() {
        this.noCursor();
        this.pBackground = this.createGraphics(this.iResLowX, this.iResLowY);
        stardrive.println((String)("w " + this.width + " h " + this.height));
        stardrive.println((String)("we want resolution " + this.iResLowX + "x" + this.iResLowY));
        float fFactorX = 1.0f;
        float fFactorY = 1.0f;
        fFactorX = (float)this.width / (float)this.iResLowX;
        fFactorY = (float)this.height / (float)this.iResLowY;
        stardrive.println((String)("factor x " + fFactorX + " y " + fFactorY));
        if (fFactorX <= fFactorY) {
            fFactorY = fFactorX;
            this.iOffsetX = 0;
            this.iOffsetY = (int)(((float)this.height - (float)this.iResLowY * fFactorY) * 0.5f);
        } else {
            fFactorX = fFactorY;
            this.iOffsetX = (int)(((float)this.width - (float)this.iResLowX * fFactorX) * 0.5f);
            this.iOffsetY = 0;
        }
        this.fFactor = fFactorX;
        this.background(0);
        this.minim = new Minim((Object)this);
        this.audioOut = new AudioOutput[this.iPlayers];
        int i = 0;
        while (i < this.audioOut.length) {
            this.audioOut[i] = this.minim.getLineOut();
            ++i;
        }
        this.audioOutCentre = this.minim.getLineOut();
        i = 0;
        while (i < this.audioOut.length) {
            this.audioOut[i].setVolume(1.0f);
            ++i;
        }
        this.audioOutCentre.setVolume(0.5f);
        this.audioOut[0].setBalance(-1.0f);
        this.audioOut[1].setBalance(1.0f);
        this.control = ControlIO.getInstance((PApplet)this);
        stardrive.println((Object)this.control.getDevices());
        ArrayList jo = new ArrayList();
        jo = (ArrayList)this.control.getDevices();
        int loc = 0;
        int[] devicesPlayers = new int[]{-1, -1};
        int i2 = 0;
        while (i2 < jo.size()) {
            String name = ((ControlDevice)jo.get(i2)).toString();
            loc = name.indexOf("Xin-Mo");
            stardrive.println((int)loc);
            if (loc != -1) {
                if (devicesPlayers[0] == -1) {
                    devicesPlayers[0] = i2;
                } else {
                    devicesPlayers[1] = i2;
                    break;
                }
            }
            ++i2;
        }
        if (devicesPlayers[1] == -1) {
            stardrive.println((String)"No joysticks connected (or not enough)");
            this.gamepad = false;
        } else {
            stardrive.println((String)("Joysticks connected on position " + devicesPlayers[0] + " and " + devicesPlayers[1]));
            this.gamepad = true;
            this.joystick0 = this.control.getDevice(devicesPlayers[0]);
            this.joystick1 = this.control.getDevice(devicesPlayers[1]);
        }
        this.pBackground.beginDraw();
        this.pBackground.noFill();
        this.fontBitmapped = this.loadFont("AcknowledgeTT-BRK--13.vlw");
        this.pBackground.textFont(this.fontBitmapped);
        this.fontBitmapped45 = this.loadFont("AcknowledgeTT-BRK--45.vlw");
        this.pBackground.textSize((float)this.iTextSize);
        this.pBackground.endDraw();
        this.pLogo = this.loadImage("logo7_hell-20_20_farbbal-50_50_-50.png");
        this.pTilesheet = this.loadImage("tilesheet.png");
        this.level = new Level();
        this.ships = new Ship[this.iPlayers];
        i2 = 0;
        while (i2 < this.ships.length) {
            this.ships[i2] = new Ship(i2);
            ++i2;
        }
        this.shots = new Shot[this.iShotsMax];
        i2 = 0;
        while (i2 < this.shots.length) {
            this.shots[i2] = new Shot(i2);
            ++i2;
        }
        this.particles = new Particle[this.iParticlesMax];
        i2 = 0;
        while (i2 < this.particles.length) {
            this.particles[i2] = new Particle(i2);
            ++i2;
        }
        this.people = new Person[this.iPeopleMax];
        i2 = 0;
        while (i2 < this.people.length) {
            this.people[i2] = new Person(i2);
            ++i2;
        }
        this.trees = new Tree[this.iTreesMax];
        i2 = 0;
        while (i2 < this.trees.length) {
            this.trees[i2] = new Tree(i2);
            ++i2;
        }
        this.vNewGame();
    }

    public boolean bCheckDistance(float f1X, float f1Y, float f2X, float f2Y, int sx, int sy) {
        return stardrive.abs((float)(f1X - f2X)) < (float)sx && stardrive.abs((float)(f1Y - f2Y)) < (float)sy;
    }

    public boolean bTestLineIntersection(float p0_x, float p0_y, float p1_x, float p1_y, float p2_x, float p2_y, float p3_x, float p3_y) {
        float s1_x = p1_x - p0_x;
        float s1_y = p1_y - p0_y;
        float s2_x = p3_x - p2_x;
        float s2_y = p3_y - p2_y;
        float s = (-s1_y * (p0_x - p2_x) + s1_x * (p0_y - p2_y)) / (-s2_x * s1_y + s1_x * s2_y);
        float t = (s2_x * (p0_y - p2_y) - s2_y * (p0_x - p2_x)) / (-s2_x * s1_y + s1_x * s2_y);
        return s >= 0.0f && s <= 1.0f && t >= 0.0f && t <= 1.0f;
    }

    public float fRotateByAngleX(float x, float y, float a) {
        a = stardrive.radians((float)a);
        return x * stardrive.cos((float)a) - y * stardrive.sin((float)a);
    }

    public float fRotateByAngleY(float x, float y, float a) {
        a = stardrive.radians((float)a);
        return x * stardrive.sin((float)a) + y * stardrive.cos((float)a);
    }

    public int iFindEmptyParticle() {
        int i = 0;
        while (i < this.particles.length) {
            if (!this.particles[i].bIsOn()) {
                return i;
            }
            ++i;
        }
        return PApplet.parseInt((float)this.random(this.particles.length));
    }

    public int iFindEmptyShot() {
        int i = 0;
        while (i < this.shots.length) {
            if (!this.shots[i].bIsOn()) {
                return i;
            }
            ++i;
        }
        return PApplet.parseInt((float)this.random(this.shots.length));
    }

    public void vAddParticle(float x, float y, float a, float s, int sz, boolean br, boolean ba) {
        this.particles[this.iFindEmptyParticle()].vAdd(x, y, a, s, sz, br, ba);
    }

    public void vDrawBubbleSpeech(PGraphics surface, int x, int y, int sx, int sy, String s) {
        surface.stroke(this.cGreen);
        surface.line((float)x, (float)y, (float)(x + sx), (float)y);
        surface.line((float)(x + sx), (float)y, (float)(x + sx), (float)(y + sy));
        surface.line((float)x, (float)y, (float)x, (float)(y + sy + 12));
        surface.line((float)x, (float)(y + sy + 12), (float)(x + 4), (float)(y + sy));
        surface.line((float)(x + 4), (float)(y + sy), (float)(x + sx), (float)(y + sy));
        surface.image(this.pTilesheet.get(4 * this.iTileSize, PApplet.parseInt((float)this.random(2.0f)) * this.iTileSize, this.iTileSize, this.iTileSize), (float)x - (float)this.iTileSize * 0.5f, (float)(y + sy + 12 + 3));
        surface.textAlign(3, 3);
        surface.fill(this.cGreen);
        surface.text(s, (float)x + (float)sx * 0.5f, (float)y + (float)sy * 0.5f);
        surface.textAlign(37);
    }

    public void vNewGame() {
        this.level.vInit();
        this.iLoser = -1;
        this.ships[0].vInit(0, 0, 160, 200, 8, 86, '1', 's', 'a', 'd', 'q', 'w');
        this.ships[0].vUpdate();
        if (this.iPlayers > 1) {
            this.ships[1].vInit(160, 0, 160, 200, 1024, 86, 'b', 'k', 'j', 'l', 'n', 'i');
            this.ships[1].vUpdate();
        }
    }

    public void keyPressed() {
        if (this.key == '5') {
            this.audioOutCentre.playNote(0.0f, this.fSoundDuration, this.sSoundBeep);
            this.audioOutCentre.mute();
            int i = 0;
            while (i < this.audioOut.length) {
                this.audioOut[i].mute();
                ++i;
            }
        } else if (this.key == '6') {
            this.audioOutCentre.unmute();
            int i = 0;
            while (i < this.audioOut.length) {
                this.audioOut[i].unmute();
                ++i;
            }
            this.audioOutCentre.playNote(0.0f, this.fSoundDuration, this.sSoundBeep);
        } else if (this.key != '7' && this.key != '8' && this.key != '9' && this.key != '0') {
            this.vButtonPressed(this.key);
        }
    }

    public void vButtonPressed(int k) {
        block13: {
            block14: {
                this.iTicksButtonPressedLast = this.millis();
                if (this.iScreen != 0) break block14;
                int i = 0;
                while (i < this.ships.length) {
                    if (this.ships[i].cGetKeyBoost() == k && !this.ships[i].bGetPlayerReady()) {
                        this.audioOut[i].playNote(0.0f, this.fSoundDuration, this.sSoundBeep);
                        this.ships[i].vSetPlayerReady(true);
                    }
                    ++i;
                }
                if (!this.ships[0].bGetPlayerReady() || !this.ships[1].bGetPlayerReady()) break block13;
                this.iTicksGetReadyElapsed = this.millis();
                ++this.iScreen;
                break block13;
            }
            if (this.iScreen == 1) {
                int i = 0;
                while (i < this.ships.length) {
                    if (this.ships[i].cGetKeyBoost() != k || !this.ships[i].bButtonPressed(k)) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (this.iScreen == 2) {
                int i = 0;
                while (i < this.ships.length) {
                    if (!this.ships[i].bButtonPressed(k)) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (this.iScreen == 3) {
                int i = 0;
                while (i < this.ships.length) {
                    if (!this.ships[i].bButtonPressed(k)) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public void keyReleased() {
        this.vButtonReleased(this.key);
    }

    public void vButtonReleased(int k) {
        block6: {
            block8: {
                block7: {
                    if (this.iScreen == 0) break block6;
                    if (this.iScreen != 1) break block7;
                    int i = 0;
                    while (i < this.ships.length) {
                        if (this.ships[i].cGetKeyBoost() != k || !this.ships[i].bButtonReleased(k)) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    break block6;
                }
                if (this.iScreen != 2) break block8;
                int i = 0;
                while (i < this.ships.length) {
                    if (!this.ships[i].bButtonReleased(k)) {
                        ++i;
                        continue;
                    }
                    break block6;
                }
                break block6;
            }
            if (this.iScreen != 3) break block6;
            int i = 0;
            while (i < this.ships.length) {
                if (!this.ships[i].bButtonReleased(k)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    public void vMenu() {
        int i = 0;
        while (i < this.ships.length) {
            this.ships[i].vDisplay();
            ++i;
        }
        int iY = stardrive.round((float)stardrive.sin((float)((float)this.millis() * 0.01f)));
        this.pBackground.beginDraw();
        this.pBackground.image(this.pLogo, (float)(this.pBackground.width - this.pLogo.width) * 0.5f, 28.0f);
        this.pBackground.textAlign(3);
        if (!this.ships[0].bGetPlayerReady()) {
            this.pBackground.fill(this.color(stardrive.sin((float)((float)this.millis() * 0.01f)) * 20.0f, 220.0f - stardrive.sin((float)((float)this.millis() * 0.01f)) * 20.0f, stardrive.sin((float)((float)this.millis() * 0.01f)) * 10.0f));
            this.pBackground.text("PRESS FIRE TO PLAY", (float)this.pBackground.width * 0.25f, (float)(128 + iY));
        } else {
            this.pBackground.fill(this.cGreen);
            this.pBackground.text("PILOT ONE READY", (float)this.pBackground.width * 0.25f, 128.0f);
        }
        if (!this.ships[1].bGetPlayerReady()) {
            this.pBackground.fill(this.color(stardrive.cos((float)((float)this.millis() * 0.01f)) * 20.0f, 220.0f - stardrive.cos((float)((float)this.millis() * 0.01f)) * 20.0f, stardrive.cos((float)((float)this.millis() * 0.01f)) * 10.0f));
            this.pBackground.text("PRESS FIRE TO PLAY", (float)this.pBackground.width * 0.75f, (float)(128 + iY));
        } else {
            this.pBackground.fill(this.cGreen);
            this.pBackground.text("PILOT TWO READY", (float)this.pBackground.width * 0.75f, 128.0f);
        }
        this.pBackground.fill(this.cGreenMedium);
        if (this.gamepad) {
            this.pBackground.text("CONTROLS", (float)this.pBackground.width * 0.5f, 150.0f);
            this.pBackground.text("BOOST BUTTON 1, FIRE JOY UP,\nLEFT/RIGHT JOY L/JOY R", (float)this.pBackground.width * 0.5f, 160.0f);
        } else {
            this.pBackground.text("CONTROLS", (float)this.pBackground.width * 0.25f, 150.0f);
            this.pBackground.text("BOOST " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[0].cGetKeyBoost()) - 32)) + ", FIRE " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[0].cGetKeyShoot()) - 32)) + ",\nLEFT/RIGHT " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[0].cGetKeyLeft()) - 32)) + "/" + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[0].cGetKeyRight()) - 32)), (float)this.pBackground.width * 0.25f, 160.0f);
            this.pBackground.text("CONTROLS", (float)this.pBackground.width * 0.75f, 150.0f);
            this.pBackground.text("BOOST " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[1].cGetKeyBoost()) - 32)) + ", FIRE " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[1].cGetKeyShoot()) - 32)) + ",\nLEFT/RIGHT " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[1].cGetKeyLeft()) - 32)) + "/" + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[1].cGetKeyRight()) - 32)), (float)this.pBackground.width * 0.75f, 160.0f);
        }
        this.pBackground.textAlign(37);
        this.pBackground.fill(this.cGreenDark);
        this.pBackground.text("DACE.DE 2020", 10.0f, (float)(this.pBackground.height - 10));
        this.pBackground.endDraw();
    }

    public void vGetReady() {
        int iDelta = this.millis() - this.iTicksGetReadyElapsed;
        int i = 0;
        while (i < this.ships.length) {
            this.ships[i].vDisplay();
            ++i;
        }
        int iY = stardrive.round((float)stardrive.sin((float)((float)this.millis() * 0.01f)));
        this.pBackground.beginDraw();
        this.pBackground.image(this.pLogo, (float)(this.pBackground.width - this.pLogo.width) * 0.5f, 28.0f - (float)iDelta * 0.05f);
        this.pBackground.fill(this.cGreenMedium);
        this.pBackground.textAlign(3);
        this.pBackground.textFont(this.fontBitmapped45);
        this.pBackground.textSize((float)(this.iTextSize + 32));
        int iCountdownNew = PApplet.parseInt((float)((float)this.iTicksGetReady * 0.001f - (float)iDelta * 0.001f)) + 1;
        if (this.iCountdownOld != iCountdownNew && iCountdownNew != 3) {
            this.audioOutCentre.playNote(0.0f, this.fSoundDuration, this.sSoundGameGetReady);
            this.iCountdownOld = iCountdownNew;
        }
        this.pBackground.text(iCountdownNew, (float)this.pBackground.width * 0.5f, (float)this.pBackground.height * 0.5f);
        this.pBackground.textSize((float)this.iTextSize);
        this.pBackground.textFont(this.fontBitmapped);
        if (!this.ships[0].bGetPlayerReady()) {
            this.pBackground.fill(this.color(stardrive.sin((float)((float)this.millis() * 0.01f)) * 20.0f, 220.0f - stardrive.sin((float)((float)this.millis() * 0.01f)) * 20.0f, stardrive.sin((float)((float)this.millis() * 0.01f)) * 10.0f));
            this.pBackground.text("PRESS FIRE TO PLAY", (float)this.pBackground.width * 0.25f, (float)(128 + iY));
        } else {
            this.pBackground.fill(this.cGreen);
            this.pBackground.text("PILOT ONE READY", (float)this.pBackground.width * 0.25f, 128.0f);
        }
        if (!this.ships[1].bGetPlayerReady()) {
            this.pBackground.fill(this.color(stardrive.cos((float)((float)this.millis() * 0.01f)) * 20.0f, 220.0f - stardrive.cos((float)((float)this.millis() * 0.01f)) * 20.0f, stardrive.cos((float)((float)this.millis() * 0.01f)) * 10.0f));
            this.pBackground.text("PRESS FIRE TO PLAY", (float)this.pBackground.width * 0.75f, (float)(128 + iY));
        } else {
            this.pBackground.fill(this.cGreen);
            this.pBackground.text("PILOT TWO READY", (float)this.pBackground.width * 0.75f, 128.0f);
        }
        this.pBackground.fill(this.cGreenMedium);
        if (this.gamepad) {
            this.pBackground.text("CONTROLS", (float)this.pBackground.width * 0.5f, 150.0f + (float)iDelta * 0.05f);
            this.pBackground.text("BOOST BUTTON 1, FIRE JOY UP,\nLEFT/RIGHT JOY L/JOY R", (float)this.pBackground.width * 0.5f, 160.0f + (float)iDelta * 0.05f);
        } else {
            this.pBackground.text("CONTROLS", (float)this.pBackground.width * 0.25f, 150.0f + (float)iDelta * 0.05f);
            this.pBackground.text("BOOST " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[0].cGetKeyBoost()) - 32)) + ", LEFT/RIGHT " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[0].cGetKeyLeft()) - 32)) + "/" + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[0].cGetKeyRight()) - 32)) + ", FIRE " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[0].cGetKeyShoot()) - 32)), (float)this.pBackground.width * 0.25f, 160.0f + (float)iDelta * 0.05f);
            this.pBackground.text("CONTROLS", (float)this.pBackground.width * 0.75f, 150.0f + (float)iDelta * 0.05f);
            this.pBackground.text("BOOST " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[1].cGetKeyBoost()) - 32)) + ", LEFT/RIGHT " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[1].cGetKeyLeft()) - 32)) + "/" + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[1].cGetKeyRight()) - 32)) + ", FIRE " + PApplet.parseChar((int)(PApplet.parseInt((char)this.ships[1].cGetKeyShoot()) - 32)), (float)this.pBackground.width * 0.75f, 160.0f + (float)iDelta * 0.05f);
        }
        this.pBackground.textAlign(37);
        this.pBackground.endDraw();
        if (iDelta > this.iTicksGetReady - 75) {
            this.audioOutCentre.playNote(0.0f, this.fSoundDuration, this.sSoundGameStart);
            ++this.iScreen;
            int i2 = 0;
            while (i2 < this.ships.length) {
                this.ships[i2].vTicksStart();
                ++i2;
            }
        }
    }

    public void vGame() {
        int i = 0;
        while (i < this.ships.length) {
            this.ships[i].vUpdate();
            this.ships[i].vDisplay();
            ++i;
        }
        i = 0;
        while (i < this.particles.length) {
            this.particles[i].vUpdate();
            ++i;
        }
        i = 0;
        while (i < this.shots.length) {
            this.shots[i].vUpdate();
            ++i;
        }
        this.pBackground.beginDraw();
        this.pBackground.stroke(this.cGreenDark);
        this.pBackground.line((float)this.pBackground.width * 0.5f - 1.0f, 0.0f, (float)this.pBackground.width * 0.5f - 1.0f, (float)this.pBackground.height);
        this.pBackground.line((float)this.pBackground.width * 0.5f, 0.0f, (float)this.pBackground.width * 0.5f, (float)this.pBackground.height);
        this.pBackground.endDraw();
        if (this.millis() - this.iTicksButtonPressedLast > this.iTicksTimeOut) {
            this.iScreen = 0;
            this.vNewGame();
        }
    }

    public void vGetOver() {
        int iDelta = this.millis() - this.iTicksGetReadyElapsed;
        int i = 0;
        while (i < this.ships.length) {
            this.ships[i].vUpdate();
            this.ships[i].vDisplay();
            ++i;
        }
        i = 0;
        while (i < this.particles.length) {
            this.particles[i].vUpdate();
            ++i;
        }
        i = 0;
        while (i < this.shots.length) {
            this.shots[i].vUpdate();
            ++i;
        }
        this.pBackground.beginDraw();
        this.pBackground.stroke(this.cGreenDark);
        this.pBackground.line((float)this.pBackground.width * 0.5f - 1.0f, 0.0f, (float)this.pBackground.width * 0.5f - 1.0f, (float)this.pBackground.height);
        this.pBackground.line((float)this.pBackground.width * 0.5f, 0.0f, (float)this.pBackground.width * 0.5f, (float)this.pBackground.height);
        this.pBackground.noStroke();
        this.pBackground.fill(0, (float)iDelta * 0.05f);
        this.pBackground.rect(0.0f, 0.0f, (float)this.pBackground.width, (float)this.pBackground.height);
        this.pBackground.endDraw();
        if (iDelta > this.iTicksGetReady * 2) {
            int iWinner = this.iLoser == this.ships[0].iGetId() ? this.ships[1].iGetId() : this.ships[0].iGetId();
            this.ships[this.iLoser].vSetAngle(210.0f);
            this.ships[iWinner].vSetAngle(0.0f);
            int i2 = 0;
            while (i2 < this.people.length) {
                this.people[i2].vAdd((float)this.pBackground.width * 0.5f + this.random(-50.0f, 50.0f), 140.0f);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.trees.length) {
                this.trees[i2].vAdd(this.random(this.pBackground.width), 140.0f);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.ships.length) {
                this.ships[i2].vSetPlayerReady(false);
                ++i2;
            }
            ++this.iScreen;
            this.iTicksGetReadyElapsed = this.millis();
        }
    }

    public void vResults() {
        int iDelta = this.millis() - this.iTicksGetReadyElapsed;
        int iWinner = this.iLoser == this.ships[0].iGetId() ? this.ships[1].iGetId() : this.ships[0].iGetId();
        int iY = stardrive.round((float)stardrive.sin((float)((float)this.millis() * 0.01f)));
        this.pBackground.beginDraw();
        this.pBackground.background(0);
        if ((float)iDelta > (float)this.iTicksGetReady * 1.2f && (float)iDelta < (float)this.iTicksGetReady * 2.5f) {
            if (this.random(100.0f) > 70.0f) {
                this.audioOutCentre.playNote(0.0f, this.fSoundDuration * 0.5f, this.random(40000.0f, 60000.0f));
            }
            this.vDrawBubbleSpeech(this.pBackground, 78, 46 + iY, 164, 28, "THE WINNER, PILOT " + (iWinner + 1) + ",\nIS PRESENTED WITH\nTHE ZOKAL TROPHY");
        }
        this.pBackground.endDraw();
        int i = 0;
        while (i < this.trees.length) {
            this.trees[i].vDisplay(this.pBackground);
            ++i;
        }
        i = 0;
        while (i < this.shots.length) {
            this.shots[i].vUpdate();
            ++i;
        }
        this.ships[this.iLoser].vUpdate();
        this.ships[iWinner].vUpdate();
        this.ships[this.iLoser].vSetAngle(210.0f);
        this.ships[iWinner].vSetAngle(0.0f);
        float fWinnerShipY = -10.0f;
        fWinnerShipY += (float)iDelta * 0.05f;
        this.ships[iWinner].vSetLanded(false);
        if (fWinnerShipY > 150.0f) {
            fWinnerShipY = 150.0f;
            this.ships[iWinner].vSetLanded(true);
        }
        this.ships[this.iLoser].vDisplayShip(this.pBackground, (float)this.pBackground.width * 0.25f + (float)(this.iLoser * this.pBackground.width) * 0.5f, 156.0f);
        this.ships[iWinner].vDisplayShip(this.pBackground, (float)this.pBackground.width * 0.25f + (float)(iWinner * this.pBackground.width) * 0.5f, fWinnerShipY);
        this.level.vDisplay(this.pBackground, -260.0f, -1060.0f);
        int i2 = 0;
        while (i2 < this.particles.length) {
            this.particles[i2].vUpdate();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.shots.length) {
            this.shots[i2].vUpdate();
            ++i2;
        }
        if ((float)iDelta > (float)this.iTicksGetReady * 2.9f && iDelta < this.iTicksGetReady * 5 && this.random(100.0f) > 50.0f) {
            this.vAddParticle(260.0f + (float)this.pBackground.width * 0.5f + 5.0f + this.random(6.0f) - (float)this.iTileSize * 0.5f, 1060 + iY + 126, this.random(-40.0f, 40.0f) % 360.0f, 0.5f + this.random(0.5f), 4, true, true);
        }
        this.pBackground.beginDraw();
        this.pBackground.image(this.pTilesheet.get(8 * this.iTileSize, 0 * this.iTileSize, this.iTileSize * 3, this.iTileSize), (float)this.pBackground.width * 0.5f - (float)this.iTileSize * 0.5f - (float)(this.iTileSize * 1), (float)(156 - this.iTileSize));
        this.pBackground.image(this.pTilesheet.get(7 * this.iTileSize, 0 * this.iTileSize, this.iTileSize, this.iTileSize), (float)this.pBackground.width * 0.5f - (float)this.iTileSize * 0.5f, (float)(156 - this.iTileSize * 2));
        this.pBackground.image(this.pTilesheet.get(6 * this.iTileSize, 0 * this.iTileSize, this.iTileSize, this.iTileSize), (float)this.pBackground.width * 0.5f - (float)this.iTileSize * 0.5f - (float)this.iTileSize + 4.0f, (float)(156 - this.iTileSize * 2));
        this.pBackground.endDraw();
        if (this.random(100.0f) > 90.0f) {
            this.vAddParticle(260.0f + (float)this.pBackground.width * 0.25f + (float)(this.iLoser * this.pBackground.width) * 0.5f + 3.0f, 1210.0f, (390.0f + this.random(-5.0f, 5.0f)) % 360.0f, 1.0f + this.random(1.6f), 1, false, false);
        }
        i2 = 0;
        while (i2 < this.people.length) {
            this.people[i2].vUpdate();
            this.people[i2].vDisplay(this.pBackground);
            ++i2;
        }
        if (iDelta > this.iTicksGetReady * 6) {
            this.iScreen = 0;
            this.vNewGame();
        }
    }

    public void draw() {
        if (this.iScreen == 0) {
            this.vMenu();
        } else if (this.iScreen == 1) {
            this.vGetReady();
        } else if (this.iScreen == 2) {
            this.vGame();
        } else if (this.iScreen == 3) {
            this.vGetOver();
        } else if (this.iScreen == 4) {
            this.vResults();
        } else {
            stardrive.println((String)("Error: Unknown screen " + this.iScreen));
        }
        if (this.gamepad) {
            if (this.joystick0.getButton(0).pressed() && !this.bJoystick0Controls[0]) {
                this.bJoystick0Controls[0] = true;
                this.vButtonPressed(this.ships[0].cGetKeyBoost());
            }
            if (this.joystick0.getSlider(1).getValue() == -1.0f && !this.bJoystick0Controls[1]) {
                this.bJoystick0Controls[1] = true;
                this.vButtonPressed(this.ships[0].cGetKeyShoot());
            }
            if (this.joystick0.getSlider(0).getValue() == -1.0f && !this.bJoystick0Controls[2]) {
                this.bJoystick0Controls[2] = true;
                this.vButtonPressed(this.ships[0].cGetKeyLeft());
            } else if (this.joystick0.getSlider(0).getValue() == 1.0f && !this.bJoystick0Controls[3]) {
                this.bJoystick0Controls[3] = true;
                this.vButtonPressed(this.ships[0].cGetKeyRight());
            }
            if (this.joystick1.getButton(0).pressed() && !this.bJoystick1Controls[0]) {
                this.bJoystick1Controls[0] = true;
                this.vButtonPressed(this.ships[1].cGetKeyBoost());
            }
            if (this.joystick1.getSlider(1).getValue() == -1.0f && !this.bJoystick1Controls[1]) {
                this.bJoystick1Controls[1] = true;
                this.vButtonPressed(this.ships[1].cGetKeyShoot());
            }
            if (this.joystick1.getSlider(0).getValue() == -1.0f && !this.bJoystick1Controls[2]) {
                this.bJoystick1Controls[2] = true;
                this.vButtonPressed(this.ships[1].cGetKeyLeft());
            } else if (this.joystick1.getSlider(0).getValue() == 1.0f && !this.bJoystick1Controls[3]) {
                this.bJoystick1Controls[3] = true;
                this.vButtonPressed(this.ships[1].cGetKeyRight());
            }
            if (!this.joystick0.getButton(0).pressed() && this.bJoystick0Controls[0]) {
                this.bJoystick0Controls[0] = false;
                this.vButtonReleased(this.ships[0].cGetKeyBoost());
            }
            if (this.joystick0.getSlider(1).getValue() != -1.0f && this.bJoystick0Controls[1]) {
                this.bJoystick0Controls[1] = false;
                this.vButtonReleased(this.ships[0].cGetKeyShoot());
            }
            if (this.joystick0.getSlider(0).getValue() != -1.0f && this.bJoystick0Controls[2]) {
                this.bJoystick0Controls[2] = false;
                this.vButtonReleased(this.ships[0].cGetKeyLeft());
            } else if (this.joystick0.getSlider(0).getValue() != 1.0f && this.bJoystick0Controls[3]) {
                this.bJoystick0Controls[3] = false;
                this.vButtonReleased(this.ships[0].cGetKeyRight());
            }
            if (!this.joystick1.getButton(0).pressed() && this.bJoystick1Controls[0]) {
                this.bJoystick1Controls[0] = false;
                this.vButtonReleased(this.ships[1].cGetKeyBoost());
            }
            if (this.joystick1.getSlider(1).getValue() != -1.0f && this.bJoystick1Controls[1]) {
                this.bJoystick1Controls[1] = false;
                this.vButtonReleased(this.ships[1].cGetKeyShoot());
            }
            if (this.joystick1.getSlider(0).getValue() != -1.0f && this.bJoystick1Controls[2]) {
                this.bJoystick1Controls[2] = false;
                this.vButtonReleased(this.ships[1].cGetKeyLeft());
            } else if (this.joystick1.getSlider(0).getValue() != 1.0f && this.bJoystick1Controls[3]) {
                this.bJoystick1Controls[3] = false;
                this.vButtonReleased(this.ships[1].cGetKeyRight());
            }
        }
        this.image((PImage)this.pBackground, this.iOffsetX, this.iOffsetY, (float)this.iResLowX * this.fFactor, (float)this.iResLowY * this.fFactor);
    }

    public void settings() {
        this.fullScreen();
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"stardrive"};
        if (passedArgs != null) {
            PApplet.main((String[])stardrive.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Level {
        Tile[] tiles;

        Level() {
            this.tiles = new Tile[stardrive.this.iTileMaxX * stardrive.this.iTileMaxY];
        }

        public boolean bIsTile(int t) {
            return this.tiles[t].bIsOn();
        }

        public int iCollisionCheck(float fPosX, float fPosY, int iObjectSize, float fTopLeftX, float fTopLeftY, float fTopRightX, float fTopRightY, float fBottomLeftX, float fBottomLeftY, float fBottomRightX, float fBottomRightY) {
            int i = 0;
            while (i < this.tiles.length) {
                if (this.tiles[i].bCollisionCheck(fPosX, fPosY, iObjectSize, fTopLeftX, fTopLeftY, fTopRightX, fTopRightY, fBottomLeftX, fBottomLeftY, fBottomRightX, fBottomRightY)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int iCollisionCheck(float fPosX, float fPosY) {
            int i = 0;
            while (i < this.tiles.length) {
                if (this.tiles[i].bCollisionCheck(fPosX, fPosY)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int iCollisionCheck(float fPosX, float fPosY, int iSizeX, int iSizeY) {
            int i = 0;
            while (i < this.tiles.length) {
                if (this.tiles[i].bCollisionCheck(fPosX, fPosY, iSizeX, iSizeY)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void vInit() {
            int i = 0;
            while (i < this.tiles.length) {
                this.tiles[i] = new Tile();
                ++i;
            }
            int tileNumber = 0;
            String[] lines = stardrive.this.loadStrings("track.txt");
            stardrive.this.iTileMaxX = lines.length;
            int j = 0;
            while (j < lines.length) {
                int i2 = 0;
                while (i2 < lines[j].length()) {
                    this.tiles[tileNumber].vInit(tileNumber, i2 * stardrive.this.iTileSize, j * stardrive.this.iTileSize, PApplet.parseInt((char)lines[j].charAt(i2)));
                    ++tileNumber;
                    ++i2;
                }
                stardrive.this.iTileMaxY = j++;
            }
        }

        public void vDisplay(PGraphics surface, float offsetX, float offsetY) {
            int i = 0;
            while (i < this.tiles.length) {
                this.tiles[i].vDisplay(surface, offsetX, offsetY);
                ++i;
            }
            i = 0;
            while (i < stardrive.this.particles.length) {
                stardrive.this.particles[i].vDisplay(surface, offsetX, offsetY);
                ++i;
            }
            i = 0;
            while (i < stardrive.this.shots.length) {
                stardrive.this.shots[i].vDisplay(surface, offsetX, offsetY);
                ++i;
            }
        }

        public int iGetTilePosX(int t) {
            return this.tiles[t].iGetPosX();
        }

        public int iGetTilePosY(int t) {
            return this.tiles[t].iGetPosY();
        }

        public void vSwitchOffTile(int t, int p) {
            this.tiles[t].vSwitchOff(p);
        }
    }

    class Particle {
        int iId = -1;
        boolean bOn = false;
        float fPosX = 0.0f;
        float fPosY = 0.0f;
        int iSizeX = 2;
        int iSizeY = 2;
        float fAngle = 0.0f;
        float fSpeedX = 0.0f;
        float fSpeedY = 0.0f;
        int iTicksFall = 0;
        float fVelocity = 5.0f;
        int iTicksInit = 0;
        int iTicksDuration = 1000;
        boolean bBright = false;
        boolean bBalloons = false;

        Particle(int id) {
            this.iId = id;
        }

        public boolean bIsOn() {
            return this.bOn;
        }

        public void vAdd(float x, float y, float a, float s, int sz, boolean br, boolean ba) {
            this.fPosX = x;
            this.fPosY = y;
            this.fAngle = a;
            this.fSpeedX = stardrive.this.fRotateByAngleX(0.0f, -s, a);
            this.fSpeedY = stardrive.this.fRotateByAngleY(0.0f, -s, a);
            this.iSizeX = this.iSizeY = sz;
            this.bBright = br;
            this.bBalloons = ba;
            this.bOn = true;
            this.iTicksFall = this.iTicksInit = stardrive.this.millis();
        }

        public void vDisplay(PGraphics surface, float offsetX, float offsetY) {
            if (this.bOn) {
                surface.beginDraw();
                if (this.bBright) {
                    surface.stroke(10.0f, 220.0f - (float)(stardrive.this.millis() - this.iTicksInit) * 0.22f, 0.0f);
                } else {
                    surface.stroke(6.0f, 70.0f - (float)(stardrive.this.millis() - this.iTicksInit) * 0.07f, 0.0f);
                }
                if (this.iSizeX < 3 && this.iSizeY < 3) {
                    surface.point((float)stardrive.round((float)(this.fPosX + offsetX)), (float)stardrive.round((float)(this.fPosY + offsetY)));
                    if (this.iSizeX > 1) {
                        surface.point((float)stardrive.round((float)(this.fPosX + offsetX + 1.0f)), (float)stardrive.round((float)(this.fPosY + offsetY)));
                    }
                    if (this.iSizeY > 1) {
                        surface.point((float)stardrive.round((float)(this.fPosX + offsetX)), (float)stardrive.round((float)(this.fPosY + offsetY + 1.0f)));
                    }
                    if (this.iSizeX > 1 && this.iSizeY > 1) {
                        surface.point((float)stardrive.round((float)(this.fPosX + offsetX + 1.0f)), (float)stardrive.round((float)(this.fPosY + offsetY + 1.0f)));
                    }
                } else if (this.iSizeX == 3 && this.iSizeY == 3) {
                    surface.noStroke();
                    surface.fill(10.0f, 160.0f - (float)(stardrive.this.millis() - this.iTicksInit) * 0.16f, 0.0f);
                    surface.rect((float)stardrive.round((float)(this.fPosX + offsetX)), (float)stardrive.round((float)(this.fPosY + offsetY)), (float)this.iSizeX, (float)this.iSizeY);
                } else {
                    surface.stroke(10.0f, 220.0f - (float)(stardrive.this.millis() - this.iTicksInit) * 0.022f, 0.0f);
                    surface.noFill();
                    surface.ellipse((float)stardrive.round((float)(this.fPosX + offsetX)), (float)stardrive.round((float)(this.fPosY + offsetY)), (float)this.iSizeX, (float)this.iSizeY);
                }
                surface.endDraw();
            }
        }

        public void vUpdate() {
            int iExtraTicksForBalloons = 1;
            if (this.bBalloons) {
                iExtraTicksForBalloons = 10;
            }
            if (stardrive.this.millis() - this.iTicksInit >= this.iTicksDuration * iExtraTicksForBalloons) {
                this.bOn = false;
            }
            if (this.bOn) {
                if (this.bBalloons && stardrive.this.random(100.0f) > 99.0f && this.fPosY > 0.0f) {
                    stardrive.this.audioOutCentre.playNote(0.0f, stardrive.this.fSoundDuration, stardrive.this.sSoundBalloonLaunch);
                    this.bOn = false;
                }
                int iDeltaFall = stardrive.this.millis() - this.iTicksFall;
                this.fSpeedY = this.bBalloons ? (this.fSpeedY -= stardrive.this.fGravity * (float)iDeltaFall * 0.001f) : (this.fSpeedY += 4.0f * stardrive.this.fGravity * (float)iDeltaFall * 0.001f);
                this.iTicksFall += iDeltaFall;
                this.fPosX += this.fSpeedX;
                this.fPosY += this.fSpeedY;
            }
        }
    }

    class Person {
        int iId = -1;
        boolean bOn = false;
        float fPosX = 0.0f;
        float fPosY = 0.0f;
        int iTicksMove = 0;

        Person(int id) {
            this.iId = id;
        }

        public boolean bIsOn() {
            return this.bOn;
        }

        public void vAdd(float x, float y) {
            this.fPosX = x;
            this.fPosY = y;
            this.bOn = true;
            this.iTicksMove = PApplet.parseInt((float)((float)stardrive.this.millis() + stardrive.this.random(1000.0f)));
        }

        public void vDisplay(PGraphics surface) {
            if (this.bOn) {
                surface.beginDraw();
                surface.image(stardrive.this.pTilesheet.get(5 * stardrive.this.iTileSize, 0 * stardrive.this.iTileSize, stardrive.this.iTileSize, stardrive.this.iTileSize), this.fPosX, this.fPosY);
                surface.endDraw();
            }
        }

        public void vUpdate() {
            int iDelta;
            if (this.bOn && (iDelta = stardrive.this.millis() - this.iTicksMove) > 1000) {
                this.fPosX += stardrive.this.random(-1.0f, 1.0f);
                this.iTicksMove += iDelta;
            }
        }
    }

    class Pilot {
        int iId = -1;
        boolean bOn = false;
        int iSizeX = 16;
        int iSizeY = 16;
        boolean bIsLanded = true;
        int iTicksFall = 0;
        int durationOneFrame = 175;
        int frame = 0;
        int framesLast = 0;
        int ticksLast;
        PImage spriteSheet;
        boolean bFacesLeft;
        boolean bFacesRight;

        Pilot(int id) {
            this.ticksLast = stardrive.this.millis();
            this.bFacesLeft = false;
            this.bFacesRight = false;
            this.iId = id;
            this.spriteSheet = stardrive.this.loadImage("pilot.png");
        }

        public void vDisplay(PGraphics surface, float offsetX, float offsetY) {
            surface.beginDraw();
            int row = 0;
            if (stardrive.this.ships[this.iId].bGetPlayerReady()) {
                if (this.bIsLanded) {
                    if (!stardrive.this.ships[this.iId].bWalking()) {
                        row = 16;
                    } else if (this.bFacesLeft) {
                        row = 80;
                    } else if (this.bFacesRight) {
                        row = 96;
                    }
                } else if (!this.bFacesLeft && !this.bFacesRight) {
                    row = 32;
                } else if (this.bFacesRight) {
                    row = 48;
                } else if (this.bFacesLeft) {
                    row = 64;
                }
            } else if (this.bIsLanded) {
                if (!stardrive.this.ships[this.iId].bWalking()) {
                    row = 0;
                } else if (this.bFacesLeft) {
                    row = 80;
                } else if (this.bFacesRight) {
                    row = 96;
                }
            } else if (!this.bFacesLeft && !this.bFacesRight) {
                row = 32;
            } else if (this.bFacesRight) {
                row = 48;
            } else if (this.bFacesLeft) {
                row = 64;
            }
            this.framesLast = stardrive.this.ships[this.iId].bWalking() && this.bIsLanded ? 3 : 0;
            PImage f = this.spriteSheet.get(0 + this.frame * this.iSizeX, row, this.iSizeX, this.iSizeY);
            surface.image(f, offsetX - (float)this.iSizeX * 0.5f + 10.0f, offsetY - (float)this.iSizeY * 0.5f - 2.0f);
            int delta = stardrive.this.millis() - this.ticksLast;
            if (delta >= this.durationOneFrame) {
                ++this.frame;
                if (this.frame > this.framesLast) {
                    this.frame = 0;
                }
                this.ticksLast += delta;
            }
            surface.endDraw();
        }

        public void vInit() {
        }

        public void vUpdate() {
            if (stardrive.this.ships[this.iId].bGetKeyPressedLeft() && !stardrive.this.ships[this.iId].bGetKeyPressedRight()) {
                this.bFacesLeft = true;
                this.bFacesRight = false;
            } else if (stardrive.this.ships[this.iId].bGetKeyPressedRight() && !stardrive.this.ships[this.iId].bGetKeyPressedLeft()) {
                this.bFacesRight = true;
                this.bFacesLeft = false;
            } else if (stardrive.this.ships[this.iId].bGetKeyPressedLeft() && stardrive.this.ships[this.iId].bGetKeyPressedRight()) {
                this.bFacesLeft = false;
                this.bFacesRight = false;
            }
        }
    }

    class Ship {
        int iScreenTopLeftX = 0;
        int iScreenTopLeftY = 0;
        int iTicksLast = 0;
        PGraphics pViewSurface = null;
        int iSurfaceWidthHalf = 0;
        int iSurfaceHeightHalf = 0;
        int iId = -1;
        boolean bOn = false;
        float fPosX = 0.0f;
        float fPosY = 0.0f;
        float fTopLeftX = 0.0f;
        float fTopLeftY = 0.0f;
        float fTopRightX = 0.0f;
        float fTopRightY = 0.0f;
        float fBottomLeftX = 0.0f;
        float fBottomLeftY = 0.0f;
        float fBottomRightX = 0.0f;
        float fBottomRightY = 0.0f;
        int iSizeX = 6;
        int iSizeY = 10;
        float fAngle = 0.0f;
        float fSpeedX = 0.0f;
        float fSpeedY = 0.0f;
        boolean bIsLanded = false;
        float fEnergy = 0.0f;
        float fSpeedMaxShip = 40.0f;
        float fBoostPower = 3.6f;
        float fTurnSpeed = 200.0f;
        float fEffectDamageMax = 0.3f;
        float fSpeedMaxToLandY = 10.0f;
        char cKeyUp = (char)32;
        char cKeyDown = (char)32;
        char cKeyLeft = (char)32;
        char cKeyRight = (char)32;
        char cKeyShoot = (char)32;
        char cKeyBoost = (char)32;
        boolean bKeyUp = false;
        boolean bKeyDown = false;
        boolean bKeyLeft = false;
        boolean bKeyRight = false;
        boolean bKeyBoost = false;
        boolean bKeyShoot = false;
        int iTicksKeyLeft = 0;
        int iTicksKeyRight = 0;
        int iTicksKeyBoost = 0;
        int iTicksKeyShoot = 0;
        int iTicksFrquencyShoot = 100;
        int iTicksFall = 0;
        int iTicksStartRound = 0;
        boolean bPlayerReady = false;
        float fRecoil = 0.08f;
        Pilot pilot = null;

        Ship(int id) {
            this.iId = id;
            this.pilot = new Pilot(this.iId);
        }

        public boolean bButtonPressed(int k) {
            if (k == this.cKeyUp && !this.bKeyUp) {
                this.bKeyUp = true;
                return true;
            }
            if (k == this.cKeyDown && !this.bKeyDown) {
                this.bKeyDown = true;
                return true;
            }
            if (k == this.cKeyLeft && !this.bKeyLeft) {
                this.iTicksKeyLeft = stardrive.this.millis();
                this.bKeyLeft = true;
                return true;
            }
            if (k == this.cKeyRight && !this.bKeyRight) {
                this.iTicksKeyRight = stardrive.this.millis();
                this.bKeyRight = true;
                return true;
            }
            if (k == this.cKeyBoost && !this.bKeyBoost) {
                this.iTicksKeyBoost = stardrive.this.millis();
                this.bKeyBoost = true;
                return true;
            }
            if (k == this.cKeyShoot && !this.bKeyShoot) {
                this.vShoot();
                this.bKeyShoot = true;
                return true;
            }
            return false;
        }

        public boolean bButtonReleased(int k) {
            if (k == this.cKeyUp) {
                this.bKeyUp = false;
                return true;
            }
            if (k == this.cKeyDown) {
                this.bKeyDown = false;
                return true;
            }
            if (k == this.cKeyLeft) {
                this.bKeyLeft = false;
                return true;
            }
            if (k == this.cKeyRight) {
                this.bKeyRight = false;
                return true;
            }
            if (k == this.cKeyBoost) {
                this.bKeyBoost = false;
                return true;
            }
            if (k == this.cKeyShoot) {
                this.bKeyShoot = false;
                return true;
            }
            return false;
        }

        public boolean bCollisionCheck(float newX, float newY, float oldX, float oldY, int sx, int sy) {
            if (stardrive.this.bTestLineIntersection(oldX, oldY, newX, newY, this.fPosX + this.fTopLeftX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fTopLeftY + (float)this.iSurfaceHeightHalf, this.fPosX + this.fBottomLeftX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fBottomLeftY + (float)this.iSurfaceHeightHalf) || stardrive.this.bTestLineIntersection(oldX, oldY, newX, newY, this.fPosX + this.fTopRightX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fTopRightY + (float)this.iSurfaceHeightHalf, this.fPosX + this.fBottomRightX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fBottomRightY + (float)this.iSurfaceHeightHalf) || stardrive.this.bTestLineIntersection(oldX, oldY, newX, newY, this.fPosX + this.fBottomLeftX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fBottomLeftY + (float)this.iSurfaceHeightHalf, this.fPosX + this.fBottomRightX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fBottomRightY + (float)this.iSurfaceHeightHalf) || stardrive.this.bTestLineIntersection(oldX + 1.0f, oldY + 1.0f, newX + 1.0f, newY + 1.0f, this.fPosX + this.fTopLeftX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fTopLeftY + (float)this.iSurfaceHeightHalf, this.fPosX + this.fBottomLeftX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fBottomLeftY + (float)this.iSurfaceHeightHalf) || stardrive.this.bTestLineIntersection(oldX + 1.0f, oldY + 1.0f, newX + 1.0f, newY + 1.0f, this.fPosX + this.fTopRightX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fTopRightY + (float)this.iSurfaceHeightHalf, this.fPosX + this.fBottomRightX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fBottomRightY + (float)this.iSurfaceHeightHalf) || stardrive.this.bTestLineIntersection(oldX + 1.0f, oldY + 1.0f, newX + 1.0f, newY + 1.0f, this.fPosX + this.fBottomLeftX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fBottomLeftY + (float)this.iSurfaceHeightHalf, this.fPosX + this.fBottomRightX + (float)this.iSurfaceWidthHalf, this.fPosY + this.fBottomRightY + (float)this.iSurfaceHeightHalf)) {
                if (stardrive.this.iScreen == 2) {
                    this.fEnergy -= 4.0f;
                    if (!this.bIsLanded) {
                        this.fAngle += stardrive.this.random(-2.5f, 2.5f);
                    }
                }
                return true;
            }
            return false;
        }

        public boolean bGetKeyPressedUp() {
            return this.bKeyUp;
        }

        public boolean bGetKeyPressedDown() {
            return this.bKeyDown;
        }

        public boolean bGetKeyPressedLeft() {
            return this.bKeyLeft;
        }

        public boolean bGetKeyPressedRight() {
            return this.bKeyRight;
        }

        public boolean bGetOn() {
            return this.bOn;
        }

        public boolean bGetPlayerReady() {
            return this.bPlayerReady;
        }

        public boolean bWalking() {
            return this.bKeyLeft || this.bKeyRight;
        }

        public char cGetKeyUp() {
            return this.cKeyUp;
        }

        public char cGetKeyDown() {
            return this.cKeyDown;
        }

        public char cGetKeyLeft() {
            return this.cKeyLeft;
        }

        public char cGetKeyRight() {
            return this.cKeyRight;
        }

        public char cGetKeyBoost() {
            return this.cKeyBoost;
        }

        public char cGetKeyShoot() {
            return this.cKeyShoot;
        }

        public float fGetPosX() {
            return this.fPosX;
        }

        public float fGetPosY() {
            return this.fPosY;
        }

        public int iGetId() {
            return this.iId;
        }

        public void vDisplay() {
            this.pViewSurface.beginDraw();
            this.pViewSurface.background(0);
            this.pViewSurface.endDraw();
            stardrive.this.level.vDisplay(this.pViewSurface, -this.fPosX, -this.fPosY);
            if (this.bOn) {
                float fOffsetX = (float)this.pViewSurface.width * 0.5f;
                float fOffsetY = (float)this.pViewSurface.height * 0.5f;
                int iOther = 0;
                if (this.iId == 0) {
                    iOther = 1;
                }
                if (stardrive.this.ships[iOther].bGetOn()) {
                    stardrive.this.ships[iOther].vDisplayShip(this.pViewSurface, -this.fPosX + fOffsetX + stardrive.this.ships[iOther].fGetPosX(), -this.fPosY + fOffsetY + stardrive.this.ships[iOther].fGetPosY());
                }
                this.pViewSurface.beginDraw();
                if (this.bKeyBoost) {
                    float fBottomMiddleLeftX = stardrive.this.fRotateByAngleX(-1.0f, (float)this.iSizeY * 0.5f + 1.0f, this.fAngle);
                    float fBottomMiddleLeftY = stardrive.this.fRotateByAngleY(-1.0f, (float)this.iSizeY * 0.5f + 1.0f, this.fAngle);
                    float fBottomMiddleRightX = stardrive.this.fRotateByAngleX(1.0f, (float)this.iSizeY * 0.5f + 1.0f, this.fAngle);
                    float fBottomMiddleRightY = stardrive.this.fRotateByAngleY(1.0f, (float)this.iSizeY * 0.5f + 1.0f, this.fAngle);
                    float fBoostTipX = stardrive.this.fRotateByAngleX(stardrive.this.random(-1.0f, 1.0f), (float)this.iSizeY * 0.5f + 3.0f + stardrive.this.random(5.0f), this.fAngle);
                    float fBoostTipY = stardrive.this.fRotateByAngleY(stardrive.this.random(-1.0f, 1.0f), (float)this.iSizeY * 0.5f + 3.0f + stardrive.this.random(5.0f), this.fAngle);
                    float fBoostControlPointLeftX = stardrive.this.fRotateByAngleX(-3.0f, 2.0f, this.fAngle);
                    float fBoostControlPointLeftY = stardrive.this.fRotateByAngleY(-3.0f, 2.0f, this.fAngle);
                    float fBoostControlPointRightX = stardrive.this.fRotateByAngleX(3.0f, 2.0f, this.fAngle);
                    float fBoostControlPointRightY = stardrive.this.fRotateByAngleY(3.0f, 2.0f, this.fAngle);
                    float fBoostControlPointTipLeftX = stardrive.this.fRotateByAngleX(-2.0f, -2.0f, this.fAngle);
                    float fBoostControlPointTipLeftY = stardrive.this.fRotateByAngleY(-2.0f, -2.0f, this.fAngle);
                    float fBoostControlPointTipRightX = stardrive.this.fRotateByAngleX(2.0f, -2.0f, this.fAngle);
                    float fBoostControlPointTipRightY = stardrive.this.fRotateByAngleY(2.0f, -2.0f, this.fAngle);
                    this.pViewSurface.stroke(stardrive.this.cGreenDark);
                    this.pViewSurface.bezier((float)stardrive.round((float)(fBottomMiddleLeftX + fOffsetX)), (float)stardrive.round((float)(fBottomMiddleLeftY + fOffsetY)), (float)stardrive.round((float)(fBottomMiddleLeftX + fBoostControlPointLeftX + fOffsetX)), (float)stardrive.round((float)(fBottomMiddleLeftY + fBoostControlPointLeftY + fOffsetY)), (float)stardrive.round((float)(fBoostTipX + fBoostControlPointTipLeftX + fOffsetX)), (float)stardrive.round((float)(fBoostTipY + fBoostControlPointTipLeftY + fOffsetY)), (float)stardrive.round((float)(fBoostTipX + fOffsetX)), (float)stardrive.round((float)(fBoostTipY + fOffsetY)));
                    this.pViewSurface.bezier((float)stardrive.round((float)(fBottomMiddleRightX + fOffsetX)), (float)stardrive.round((float)(fBottomMiddleRightY + fOffsetY)), (float)stardrive.round((float)(fBottomMiddleRightX + fBoostControlPointRightX + fOffsetX)), (float)stardrive.round((float)(fBottomMiddleRightY + fBoostControlPointRightY + fOffsetY)), (float)stardrive.round((float)(fBoostTipX + fBoostControlPointTipRightX + fOffsetX)), (float)stardrive.round((float)(fBoostTipY + fBoostControlPointTipRightY + fOffsetY)), (float)stardrive.round((float)(fBoostTipX + fOffsetX)), (float)stardrive.round((float)(fBoostTipY + fOffsetY)));
                }
                this.pViewSurface.endDraw();
                this.vDisplayShip(this.pViewSurface, fOffsetX, fOffsetY);
                if (stardrive.this.iScreen == 0 || stardrive.this.iScreen == 1 || stardrive.this.iScreen == 4) {
                    this.vDisplayPilot(this.pViewSurface, fOffsetX, fOffsetY);
                }
                if (stardrive.this.iScreen == 2) {
                    this.pViewSurface.beginDraw();
                    this.pViewSurface.stroke(stardrive.this.cGreenDark);
                    int iStartX = 4;
                    int iStartY = 3;
                    int i = 1;
                    while (i < 98) {
                        this.pViewSurface.line((float)(iStartX + i), (float)iStartY, (float)(iStartX + i), (float)(iStartY + 4));
                        i += 2;
                    }
                    this.pViewSurface.stroke(stardrive.this.cGreenMedium);
                    float fEffect = this.fEnergy - (float)(stardrive.this.millis() - this.iTicksStartRound) * 0.05f;
                    if (fEffect < 0.0f) {
                        fEffect = 0.0f;
                    }
                    int i2 = 0;
                    while ((float)i2 < this.fEnergy - fEffect) {
                        this.pViewSurface.line((float)(iStartX + i2), (float)iStartY, (float)(iStartX + i2), (float)(iStartY + 3));
                        i2 += 2;
                    }
                    this.pViewSurface.endDraw();
                }
                if (stardrive.this.iScreen == 2) {
                    this.pViewSurface.beginDraw();
                    this.pViewSurface.stroke(stardrive.this.cGreenMedium);
                    int iMapX = 116;
                    int iMapY = 3;
                    int i = 0;
                    while (i < stardrive.this.iTileMaxX * stardrive.this.iTileMaxY) {
                        if (stardrive.this.level.bIsTile(i)) {
                            this.pViewSurface.point((float)iMapX + (float)(i % stardrive.this.iTileMaxX) * 0.5f, (float)iMapY + (float)(i / stardrive.this.iTileMaxX) * 0.5f);
                        }
                        ++i;
                    }
                    this.pViewSurface.stroke(stardrive.this.cGreen);
                    this.pViewSurface.point((float)iMapX + this.fPosX / (float)(stardrive.this.iTileMaxX * stardrive.this.iTileSize) * (float)stardrive.this.iTileMaxX * 0.5f + 2.0f, (float)iMapY + this.fPosY / (float)(stardrive.this.iTileMaxY * stardrive.this.iTileSize) * (float)stardrive.this.iTileMaxY * 0.5f + 2.0f);
                    this.pViewSurface.endDraw();
                }
            }
            stardrive.this.pBackground.beginDraw();
            stardrive.this.pBackground.image((PImage)this.pViewSurface, (float)this.iScreenTopLeftX, (float)this.iScreenTopLeftY);
            stardrive.this.pBackground.endDraw();
        }

        public void vDisplayShip(PGraphics s, float fOffsetX, float fOffsetY) {
            s.beginDraw();
            if (this.bKeyBoost) {
                float fBottomMiddleLeftX = stardrive.this.fRotateByAngleX(-1.0f, (float)this.iSizeY * 0.5f + 1.0f, this.fAngle);
                float fBottomMiddleLeftY = stardrive.this.fRotateByAngleY(-1.0f, (float)this.iSizeY * 0.5f + 1.0f, this.fAngle);
                float fBottomMiddleRightX = stardrive.this.fRotateByAngleX(1.0f, (float)this.iSizeY * 0.5f + 1.0f, this.fAngle);
                float fBottomMiddleRightY = stardrive.this.fRotateByAngleY(1.0f, (float)this.iSizeY * 0.5f + 1.0f, this.fAngle);
                float fBoostTipX = stardrive.this.fRotateByAngleX(stardrive.this.random(-1.0f, 1.0f), (float)this.iSizeY * 0.5f + 3.0f + stardrive.this.random(5.0f), this.fAngle);
                float fBoostTipY = stardrive.this.fRotateByAngleY(stardrive.this.random(-1.0f, 1.0f), (float)this.iSizeY * 0.5f + 3.0f + stardrive.this.random(5.0f), this.fAngle);
                float fBoostControlPointLeftX = stardrive.this.fRotateByAngleX(-3.0f, 2.0f, this.fAngle);
                float fBoostControlPointLeftY = stardrive.this.fRotateByAngleY(-3.0f, 2.0f, this.fAngle);
                float fBoostControlPointRightX = stardrive.this.fRotateByAngleX(3.0f, 2.0f, this.fAngle);
                float fBoostControlPointRightY = stardrive.this.fRotateByAngleY(3.0f, 2.0f, this.fAngle);
                float fBoostControlPointTipLeftX = stardrive.this.fRotateByAngleX(-2.0f, -2.0f, this.fAngle);
                float fBoostControlPointTipLeftY = stardrive.this.fRotateByAngleY(-2.0f, -2.0f, this.fAngle);
                float fBoostControlPointTipRightX = stardrive.this.fRotateByAngleX(2.0f, -2.0f, this.fAngle);
                float fBoostControlPointTipRightY = stardrive.this.fRotateByAngleY(2.0f, -2.0f, this.fAngle);
                s.stroke(stardrive.this.cGreenDark);
                s.noFill();
                s.bezier((float)stardrive.round((float)(fBottomMiddleLeftX + fOffsetX)), (float)stardrive.round((float)(fBottomMiddleLeftY + fOffsetY)), (float)stardrive.round((float)(fBottomMiddleLeftX + fBoostControlPointLeftX + fOffsetX)), (float)stardrive.round((float)(fBottomMiddleLeftY + fBoostControlPointLeftY + fOffsetY)), (float)stardrive.round((float)(fBoostTipX + fBoostControlPointTipLeftX + fOffsetX)), (float)stardrive.round((float)(fBoostTipY + fBoostControlPointTipLeftY + fOffsetY)), (float)stardrive.round((float)(fBoostTipX + fOffsetX)), (float)stardrive.round((float)(fBoostTipY + fOffsetY)));
                s.bezier((float)stardrive.round((float)(fBottomMiddleRightX + fOffsetX)), (float)stardrive.round((float)(fBottomMiddleRightY + fOffsetY)), (float)stardrive.round((float)(fBottomMiddleRightX + fBoostControlPointRightX + fOffsetX)), (float)stardrive.round((float)(fBottomMiddleRightY + fBoostControlPointRightY + fOffsetY)), (float)stardrive.round((float)(fBoostTipX + fBoostControlPointTipRightX + fOffsetX)), (float)stardrive.round((float)(fBoostTipY + fBoostControlPointTipRightY + fOffsetY)), (float)stardrive.round((float)(fBoostTipX + fOffsetX)), (float)stardrive.round((float)(fBoostTipY + fOffsetY)));
            }
            s.stroke(stardrive.this.cGreen);
            s.noFill();
            s.line((float)stardrive.round((float)(this.fTopLeftX + fOffsetX)), (float)stardrive.round((float)(this.fTopLeftY + fOffsetY)), (float)stardrive.round((float)(this.fTopRightX + fOffsetX)), (float)stardrive.round((float)(this.fTopRightY + fOffsetY)));
            s.line((float)stardrive.round((float)(this.fTopRightX + fOffsetX)), (float)stardrive.round((float)(this.fTopRightY + fOffsetY)), (float)stardrive.round((float)(this.fBottomRightX + fOffsetX)), (float)stardrive.round((float)(this.fBottomRightY + fOffsetY)));
            s.line((float)stardrive.round((float)(this.fBottomRightX + fOffsetX)), (float)stardrive.round((float)(this.fBottomRightY + fOffsetY)), (float)stardrive.round((float)(this.fBottomLeftX + fOffsetX)), (float)stardrive.round((float)(this.fBottomLeftY + fOffsetY)));
            s.line((float)stardrive.round((float)(this.fBottomLeftX + fOffsetX)), (float)stardrive.round((float)(this.fBottomLeftY + fOffsetY)), (float)stardrive.round((float)(this.fTopLeftX + fOffsetX)), (float)stardrive.round((float)(this.fTopLeftY + fOffsetY)));
            if (this.bIsLanded && stardrive.this.iScreen == 4) {
                this.vDisplayPilot(s, fOffsetX, fOffsetY);
            }
            s.endDraw();
        }

        public void vDisplayPilot(PGraphics s, float fOffsetX, float fOffsetY) {
            this.pilot.vDisplay(s, fOffsetX, fOffsetY);
        }

        public void vInit(int screenX, int screenY, int sizeX, int sizeY, int x, int y, char u, char d, char l, char r, char b, char s) {
            this.iScreenTopLeftX = screenX;
            this.iScreenTopLeftY = screenY;
            this.pViewSurface = stardrive.this.createGraphics(sizeX, sizeY);
            this.iSurfaceWidthHalf = PApplet.parseInt((float)((float)sizeX * 0.5f));
            this.iSurfaceHeightHalf = PApplet.parseInt((float)((float)sizeY * 0.5f));
            this.pilot.vInit();
            this.fPosX = x;
            this.fPosY = y;
            this.fAngle = 0.0f;
            this.cKeyUp = u;
            this.cKeyDown = d;
            this.cKeyLeft = l;
            this.cKeyRight = r;
            this.cKeyBoost = b;
            this.cKeyShoot = s;
            this.fEnergy = 100.0f;
            this.bOn = true;
            this.bIsLanded = true;
        }

        public void vSetAngle(float a) {
            if (this.fAngle != a) {
                this.fAngle = a;
                this.fTopLeftX = stardrive.this.fRotateByAngleX(-1.0f, -((float)this.iSizeY * 0.5f), this.fAngle);
                this.fTopLeftY = stardrive.this.fRotateByAngleY(-1.0f, -((float)this.iSizeY * 0.5f), this.fAngle);
                this.fTopRightX = stardrive.this.fRotateByAngleX(1.0f, -((float)this.iSizeY * 0.5f), this.fAngle);
                this.fTopRightY = stardrive.this.fRotateByAngleY(1.0f, -((float)this.iSizeY * 0.5f), this.fAngle);
                this.fBottomLeftX = stardrive.this.fRotateByAngleX(-((float)this.iSizeX * 0.5f), (float)this.iSizeY * 0.5f, this.fAngle);
                this.fBottomLeftY = stardrive.this.fRotateByAngleY(-((float)this.iSizeX * 0.5f), (float)this.iSizeY * 0.5f, this.fAngle);
                this.fBottomRightX = stardrive.this.fRotateByAngleX((float)this.iSizeX * 0.5f, (float)this.iSizeY * 0.5f, this.fAngle);
                this.fBottomRightY = stardrive.this.fRotateByAngleY((float)this.iSizeX * 0.5f, (float)this.iSizeY * 0.5f, this.fAngle);
            }
        }

        public void vSetLanded(boolean b) {
            this.bIsLanded = b;
        }

        public void vSetPlayerReady(boolean r) {
            this.bPlayerReady = r;
        }

        public void vShoot() {
            if (!this.bOn) {
                return;
            }
            int iDeltaTicks = stardrive.this.millis() - this.iTicksKeyShoot;
            if (iDeltaTicks > this.iTicksFrquencyShoot) {
                stardrive.this.audioOut[this.iId].playNote(0.0f, stardrive.this.fSoundDuration, stardrive.this.sSoundShotFired);
                float fShipTopCentreX = stardrive.this.fRotateByAngleX(0.0f, -((float)this.iSizeY * 0.8f), this.fAngle);
                float fShipTopCentreY = stardrive.this.fRotateByAngleY(0.0f, -((float)this.iSizeY * 0.8f), this.fAngle);
                stardrive.this.shots[stardrive.this.iFindEmptyShot()].vAdd((float)this.iSurfaceWidthHalf + this.fPosX + fShipTopCentreX, (float)this.iSurfaceHeightHalf + this.fPosY + fShipTopCentreY, this.fAngle, this.fSpeedX, this.fSpeedY);
                float fBoostDirectionX = stardrive.this.fRotateByAngleX(0.0f, this.fRecoil, this.fAngle);
                float fBoostDirectionY = stardrive.this.fRotateByAngleY(0.0f, this.fRecoil, this.fAngle);
                this.fSpeedX += fBoostDirectionX;
                this.fSpeedY += fBoostDirectionY;
                this.iTicksKeyShoot += iDeltaTicks;
            }
        }

        public void vTicksStart() {
            this.iTicksStartRound = stardrive.this.millis();
        }

        public void vUpdate() {
            if (!this.bOn) {
                return;
            }
            float fOffsetX = (float)this.pViewSurface.width * 0.5f;
            float fOffsetY = (float)this.pViewSurface.height * 0.5f;
            if (this.fEnergy <= 0.0f) {
                stardrive.this.audioOut[this.iId].playNote(0.0f, stardrive.this.fSoundDuration, stardrive.this.sSoundShipDestroyed);
                int i = 0;
                while (i < 24) {
                    stardrive.this.vAddParticle(this.fPosX + fOffsetX + stardrive.this.random(-3.0f, 3.0f), this.fPosY + fOffsetY + stardrive.this.random(-3.0f, 3.0f), this.fAngle + stardrive.this.random(-90.0f, 90.0f), stardrive.this.random(2.0f, 6.0f), 3, true, false);
                    ++i;
                }
                stardrive.this.iLoser = this.iId;
                this.bIsLanded = false;
                this.bOn = false;
                this.bPlayerReady = false;
                ++stardrive.this.iScreen;
                stardrive.this.iTicksGetReadyElapsed = stardrive.this.millis();
                return;
            }
            this.fTopLeftX = stardrive.this.fRotateByAngleX(-1.0f, -((float)this.iSizeY * 0.5f), this.fAngle);
            this.fTopLeftY = stardrive.this.fRotateByAngleY(-1.0f, -((float)this.iSizeY * 0.5f), this.fAngle);
            this.fTopRightX = stardrive.this.fRotateByAngleX(1.0f, -((float)this.iSizeY * 0.5f), this.fAngle);
            this.fTopRightY = stardrive.this.fRotateByAngleY(1.0f, -((float)this.iSizeY * 0.5f), this.fAngle);
            this.fBottomLeftX = stardrive.this.fRotateByAngleX(-((float)this.iSizeX * 0.5f), (float)this.iSizeY * 0.5f, this.fAngle);
            this.fBottomLeftY = stardrive.this.fRotateByAngleY(-((float)this.iSizeX * 0.5f), (float)this.iSizeY * 0.5f, this.fAngle);
            this.fBottomRightX = stardrive.this.fRotateByAngleX((float)this.iSizeX * 0.5f, (float)this.iSizeY * 0.5f, this.fAngle);
            this.fBottomRightY = stardrive.this.fRotateByAngleY((float)this.iSizeX * 0.5f, (float)this.iSizeY * 0.5f, this.fAngle);
            if (!this.bIsLanded) {
                if (this.bKeyLeft && !this.bKeyRight) {
                    int iDeltaLeft = stardrive.this.millis() - this.iTicksKeyLeft;
                    this.fAngle -= this.fTurnSpeed * (float)iDeltaLeft * 0.001f;
                    if (this.fAngle < 0.0f) {
                        this.fAngle += 360.0f;
                    }
                    this.iTicksKeyLeft += iDeltaLeft;
                }
                if (this.bKeyRight && !this.bKeyLeft) {
                    int iDeltaRight = stardrive.this.millis() - this.iTicksKeyRight;
                    this.fAngle += this.fTurnSpeed * (float)iDeltaRight * 0.001f;
                    if (this.fAngle >= 360.0f) {
                        this.fAngle -= 360.0f;
                    }
                    this.iTicksKeyRight += iDeltaRight;
                }
                if (this.bKeyBoost) {
                    float fBoostDirectionY;
                    int iDeltaBoost;
                    float fBoostDirectionX;
                    if (stardrive.this.iScreen == 1 || stardrive.this.iScreen == 2 || stardrive.this.iScreen == 3) {
                        stardrive.this.audioOut[this.iId].playNote(0.0f, stardrive.this.fSoundDuration * 0.1f, stardrive.this.sSoundBoost[this.iId]);
                    }
                    if (stardrive.sqrt((float)((this.fSpeedX + (fBoostDirectionX = stardrive.this.fRotateByAngleX(0.0f, -((this.fBoostPower * (1.0f - this.fEffectDamageMax) + this.fBoostPower * this.fEffectDamageMax * (this.fEnergy * 0.01f)) * (float)(iDeltaBoost = stardrive.this.millis() - this.iTicksKeyBoost) * 0.001f), this.fAngle))) * (this.fSpeedX + fBoostDirectionX) + (this.fSpeedY + (fBoostDirectionY = stardrive.this.fRotateByAngleY(0.0f, -((this.fBoostPower * (1.0f - this.fEffectDamageMax) + this.fBoostPower * this.fEffectDamageMax * (this.fEnergy * 0.01f)) * (float)iDeltaBoost * 0.001f), this.fAngle))) * (this.fSpeedY + fBoostDirectionY))) < (stardrive.this.fSpeedMax * (1.0f - this.fEffectDamageMax) + stardrive.this.fSpeedMax * this.fEffectDamageMax * (this.fEnergy * 0.01f)) * this.fSpeedMaxShip) {
                        this.fSpeedX += fBoostDirectionX;
                        this.fSpeedY += fBoostDirectionY;
                    } else {
                        this.fSpeedX += fBoostDirectionX;
                        this.fSpeedY += fBoostDirectionY;
                        float fVectorLength = stardrive.sqrt((float)(this.fSpeedX * this.fSpeedX + this.fSpeedY * this.fSpeedY));
                        this.fSpeedX /= fVectorLength;
                        this.fSpeedY /= fVectorLength;
                        this.fSpeedX *= (stardrive.this.fSpeedMax * (1.0f - this.fEffectDamageMax) + stardrive.this.fSpeedMax * this.fEffectDamageMax * (this.fEnergy * 0.01f)) * this.fSpeedMaxShip;
                        this.fSpeedY *= (stardrive.this.fSpeedMax * (1.0f - this.fEffectDamageMax) + stardrive.this.fSpeedMax * this.fEffectDamageMax * (this.fEnergy * 0.01f)) * this.fSpeedMaxShip;
                    }
                    this.iTicksKeyBoost += iDeltaBoost;
                }
                int iDeltaFall = stardrive.this.millis() - this.iTicksFall;
                this.fSpeedY += stardrive.this.fGravity * (float)iDeltaFall * 0.001f;
                this.iTicksFall += iDeltaFall;
                float fVectorLengthOrig = stardrive.sqrt((float)(this.fSpeedX * this.fSpeedX + this.fSpeedY * this.fSpeedY));
                if (fVectorLengthOrig > stardrive.this.fSpeedMax * this.fSpeedMaxShip) {
                    this.fSpeedX /= fVectorLengthOrig;
                    this.fSpeedY /= fVectorLengthOrig;
                    this.fSpeedX *= stardrive.this.fSpeedMax * this.fSpeedMaxShip;
                    this.fSpeedY *= stardrive.this.fSpeedMax * this.fSpeedMaxShip;
                }
                this.fPosX += this.fSpeedX;
                this.fPosY += this.fSpeedY;
                int iCollisionWithTile = stardrive.this.level.iCollisionCheck(this.fPosX + (float)this.iSurfaceWidthHalf, this.fPosY + (float)this.iSurfaceHeightHalf, this.iSizeY, this.fPosX + (float)this.iSurfaceWidthHalf + this.fTopLeftX, this.fPosY + (float)this.iSurfaceHeightHalf + this.fTopLeftY, this.fPosX + (float)this.iSurfaceWidthHalf + this.fTopRightX, this.fPosY + (float)this.iSurfaceHeightHalf + this.fTopRightY, this.fPosX + (float)this.iSurfaceWidthHalf + this.fBottomLeftX, this.fPosY + (float)this.iSurfaceHeightHalf + this.fBottomLeftY, this.fPosX + (float)this.iSurfaceWidthHalf + this.fBottomRightX, this.fPosY + (float)this.iSurfaceHeightHalf + this.fBottomRightY);
                if (iCollisionWithTile != -1) {
                    int iDistanceX = PApplet.parseInt((float)stardrive.abs((float)((float)this.iSurfaceWidthHalf + this.fPosX - (float)(stardrive.this.level.iGetTilePosX(iCollisionWithTile) + stardrive.this.iTileSizeHalf))));
                    int iDistanceY = PApplet.parseInt((float)((float)stardrive.this.level.iGetTilePosY(iCollisionWithTile) - ((float)this.iSurfaceHeightHalf + this.fPosY)));
                    if ((this.fAngle > 354.0f || this.fAngle < 6.0f) && this.fSpeedY < this.fSpeedMaxToLandY && iDistanceX <= stardrive.this.iTileSize && iDistanceY > 0) {
                        if (stardrive.this.iScreen == 2 || stardrive.this.iScreen == 3) {
                            stardrive.this.audioOut[this.iId].playNote(0.0f, stardrive.this.fSoundDuration, stardrive.this.sSoundLanded);
                        }
                        this.bIsLanded = true;
                        this.fPosY = (float)stardrive.this.level.iGetTilePosY(iCollisionWithTile) - (float)this.iSizeY * 0.5f - (float)this.iSurfaceHeightHalf - 1.0f;
                    } else {
                        stardrive.this.level.vSwitchOffTile(iCollisionWithTile, this.iId);
                        if (stardrive.this.iScreen == 2) {
                            this.fEnergy -= 5.0f + this.fEnergy * 0.1f + (stardrive.abs((float)this.fSpeedX) + stardrive.abs((float)this.fSpeedX)) * 10.0f;
                        }
                        if (stardrive.this.iScreen == 2 || stardrive.this.iScreen == 3) {
                            this.fAngle = this.fAngle < 180.0f ? (this.fAngle -= 7.5f) : (this.fAngle += 7.5f);
                        }
                        this.fSpeedX *= 0.5f;
                        this.fSpeedY *= 0.5f;
                    }
                } else {
                    this.bIsLanded = false;
                }
            } else {
                this.fAngle = 0.0f;
                this.fSpeedY = 0.0f;
                this.fSpeedX = 0.0f;
                if (this.bKeyBoost) {
                    this.bIsLanded = false;
                    this.iTicksKeyBoost = this.iTicksFall = stardrive.this.millis();
                }
                int iCollisionWithTileBottomLeft = stardrive.this.level.iCollisionCheck(this.fPosX + (float)this.iSurfaceWidthHalf - 3.0f, this.fPosY + (float)this.iSurfaceHeightHalf + (float)stardrive.this.iTileSize);
                int iCollisionWithTileBottomRight = stardrive.this.level.iCollisionCheck(this.fPosX + (float)this.iSurfaceWidthHalf + 3.0f, this.fPosY + (float)this.iSurfaceHeightHalf + (float)stardrive.this.iTileSize);
                if (iCollisionWithTileBottomLeft == -1 && iCollisionWithTileBottomRight == -1) {
                    this.bIsLanded = false;
                    this.iTicksFall = stardrive.this.millis();
                }
            }
            int iOther = 0;
            if (this.iId == 0) {
                iOther = 1;
            }
            if (stardrive.this.bCheckDistance(this.fPosX, this.fPosY, stardrive.this.ships[iOther].fGetPosX(), stardrive.this.ships[iOther].fGetPosY(), this.iSizeX, this.iSizeY) && stardrive.this.iScreen == 2) {
                this.fEnergy -= 25.0f;
                this.fAngle += stardrive.this.random(-2.5f, 2.5f);
                int i = 0;
                while (i < 10) {
                    stardrive.this.vAddParticle(this.fPosX + fOffsetX + stardrive.this.random(-3.0f, 3.0f), this.fPosY + fOffsetY + stardrive.this.random(-3.0f, 3.0f), stardrive.this.random(360.0f), stardrive.this.random(1.0f, 3.0f), 3, true, false);
                    ++i;
                }
            }
            this.pilot.vUpdate();
        }
    }

    class Shot {
        int iId = -1;
        boolean bOn = false;
        float fPosX = 0.0f;
        float fPosY = 0.0f;
        float fPosOldX = 0.0f;
        float fPosOldY = 0.0f;
        int iSizeX = 2;
        int iSizeY = 2;
        float fAngle = 0.0f;
        float fSpeedX = 0.0f;
        float fSpeedY = 0.0f;
        int iTicksFall = 0;
        float fVelocity = 5.0f;

        Shot(int id) {
            this.iId = id;
        }

        public boolean bIsOn() {
            return this.bOn;
        }

        public void vAdd(float x, float y, float a, float sx, float sy) {
            float fShotVectorX = stardrive.this.fRotateByAngleX(0.0f, -this.fVelocity, a);
            float fShotVectorY = stardrive.this.fRotateByAngleY(0.0f, -this.fVelocity, a);
            this.fPosX = x;
            this.fPosY = y;
            this.fAngle = a;
            this.fSpeedX = sx + fShotVectorX;
            this.fSpeedY = sy + fShotVectorY;
            this.bOn = true;
            this.iTicksFall = stardrive.this.millis();
        }

        public void vDisplay(PGraphics surface, float offsetX, float offsetY) {
            if (this.bOn) {
                surface.beginDraw();
                surface.stroke(stardrive.this.cGreen);
                if (this.iSizeX < 3 && this.iSizeY < 3) {
                    surface.point((float)stardrive.round((float)(this.fPosX + offsetX)), (float)stardrive.round((float)(this.fPosY + offsetY)));
                    if (this.iSizeX > 1) {
                        surface.point((float)stardrive.round((float)(this.fPosX + offsetX + 1.0f)), (float)stardrive.round((float)(this.fPosY + offsetY)));
                    }
                    if (this.iSizeY > 1) {
                        surface.point((float)stardrive.round((float)(this.fPosX + offsetX)), (float)stardrive.round((float)(this.fPosY + offsetY + 1.0f)));
                    }
                    if (this.iSizeX > 1 && this.iSizeY > 1) {
                        surface.point((float)stardrive.round((float)(this.fPosX + offsetX + 1.0f)), (float)stardrive.round((float)(this.fPosY + offsetY + 1.0f)));
                    }
                } else {
                    surface.ellipse((float)stardrive.round((float)(this.fPosX + offsetX)), (float)stardrive.round((float)(this.fPosY + offsetY)), (float)this.iSizeX, (float)this.iSizeY);
                }
                surface.endDraw();
            }
        }

        public void vUpdate() {
            if (this.bOn) {
                int i;
                if (this.fPosX < -((float)stardrive.this.iResLowX * 0.25f) - (float)this.iSizeX || this.fPosX >= (float)(stardrive.this.iTileMaxX * stardrive.this.iTileSize) + (float)stardrive.this.iResLowX * 0.25f + (float)this.iSizeX || this.fPosY < -((float)stardrive.this.iResLowY * 0.5f) - (float)this.iSizeY || this.fPosY >= (float)(stardrive.this.iTileMaxY * stardrive.this.iTileSize) + (float)stardrive.this.iResLowY * 0.5f + (float)this.iSizeY) {
                    this.bOn = false;
                    return;
                }
                int iDeltaFall = stardrive.this.millis() - this.iTicksFall;
                this.fSpeedY += stardrive.this.fGravity * (float)iDeltaFall * 0.001f;
                this.iTicksFall += iDeltaFall;
                this.fPosOldX = this.fPosX;
                this.fPosOldY = this.fPosY;
                this.fPosX += this.fSpeedX;
                this.fPosY += this.fSpeedY;
                int iCollisionWithTile = stardrive.this.level.iCollisionCheck(this.fPosX, this.fPosY, this.iSizeX, this.iSizeY);
                if (iCollisionWithTile > -1) {
                    stardrive.this.audioOutCentre.playNote(0.0f, stardrive.this.fSoundDuration, stardrive.this.sSoundShotHit);
                    this.bOn = false;
                    i = 0;
                    while (i < 3) {
                        stardrive.this.vAddParticle(this.fPosX, this.fPosY, stardrive.this.random(360.0f), stardrive.this.random(0.1f, 1.0f), 1, true, false);
                        ++i;
                    }
                }
                i = 0;
                while (i < stardrive.this.iPlayers) {
                    if (stardrive.this.ships[i].bCollisionCheck(this.fPosX, this.fPosY, this.fPosOldX, this.fPosOldY, this.iSizeX, this.iSizeY)) {
                        stardrive.this.audioOut[i].playNote(0.0f, stardrive.this.fSoundDuration, stardrive.this.sSoundShotHit);
                        this.bOn = false;
                        int j = 0;
                        while (j < 5) {
                            stardrive.this.vAddParticle(this.fPosX, this.fPosY, stardrive.this.random(360.0f), stardrive.this.random(0.1f, 1.0f), 1, true, false);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    class SineInstrument
    implements Instrument {
        Oscil wave;
        Line ampEnv;

        SineInstrument(float frequency) {
            this.wave = new Oscil(frequency, 0.0f, (Waveform)Waves.SQUARE);
            this.ampEnv = new Line();
            this.ampEnv.patch(this.wave.amplitude);
        }

        public void noteOn(float duration) {
            this.ampEnv.activate(duration, 0.5f, 0.0f);
            this.wave.patch(stardrive.this.audioOutCentre);
        }

        public void noteOff() {
            this.wave.unpatch(stardrive.this.audioOutCentre);
        }
    }

    class Tile {
        int iId = -1;
        boolean bOn = false;
        float fPosX = 0.0f;
        float fPosY = 0.0f;
        int iType = 0;
        PImage pPic;
        float fEnergy = 100.0f;

        Tile() {
        }

        public boolean bCollisionCheck(float fObjectX, float fObjectY, int iObjectSize, float fTopLeftX, float fTopLeftY, float fTopRightX, float fTopRightY, float fBottomLeftX, float fBottomLeftY, float fBottomRightX, float fBottomRightY) {
            if (!this.bOn) {
                return false;
            }
            return stardrive.abs((float)(fObjectX - (this.fPosX + (float)stardrive.this.iTileSizeHalf))) < (float)stardrive.this.iTileSizeHalf + (float)iObjectSize * 0.5f && stardrive.abs((float)(fObjectY - (this.fPosY + (float)stardrive.this.iTileSizeHalf))) < (float)stardrive.this.iTileSizeHalf + (float)iObjectSize * 0.5f && (fTopLeftX >= this.fPosX && fTopLeftX < this.fPosX + (float)stardrive.this.iTileSize && fTopLeftY >= this.fPosY && fTopLeftY < this.fPosY + (float)stardrive.this.iTileSize || fTopRightX >= this.fPosX && fTopRightX < this.fPosX + (float)stardrive.this.iTileSize && fTopRightY >= this.fPosY && fTopRightY < this.fPosY + (float)stardrive.this.iTileSize || fBottomLeftX >= this.fPosX && fBottomLeftX < this.fPosX + (float)stardrive.this.iTileSize && fBottomLeftY >= this.fPosY && fBottomLeftY < this.fPosY + (float)stardrive.this.iTileSize || fBottomRightX >= this.fPosX && fBottomRightX < this.fPosX + (float)stardrive.this.iTileSize && fBottomRightY >= this.fPosY && fBottomRightY < this.fPosY + (float)stardrive.this.iTileSize);
        }

        public boolean bCollisionCheck(float fObjectX, float fObjectY) {
            if (!this.bOn) {
                return false;
            }
            return fObjectX >= this.fPosX && fObjectX < this.fPosX + (float)stardrive.this.iTileSize && fObjectY >= this.fPosY && fObjectY < this.fPosY + (float)stardrive.this.iTileSize;
        }

        public boolean bCollisionCheck(float fObjectX, float fObjectY, int iSizeX, int iSizeY) {
            if (!this.bOn) {
                return false;
            }
            if (stardrive.abs((float)(fObjectX - (this.fPosX + (float)stardrive.this.iTileSizeHalf))) < (float)stardrive.this.iTileSizeHalf + (float)iSizeX * 0.5f && stardrive.abs((float)(fObjectY - (this.fPosY + (float)stardrive.this.iTileSizeHalf))) < (float)stardrive.this.iTileSizeHalf + (float)iSizeY * 0.5f && fObjectX >= this.fPosX && fObjectX < this.fPosX + (float)stardrive.this.iTileSize && fObjectY >= this.fPosY && fObjectY < this.fPosY + (float)stardrive.this.iTileSize) {
                this.fEnergy -= 10.0f;
                if (this.fEnergy <= 0.0f) {
                    stardrive.this.audioOutCentre.playNote(0.0f, stardrive.this.fSoundDuration, stardrive.this.sSoundTileDestroyed);
                    this.bOn = false;
                    int i = 0;
                    while (i < 12) {
                        int k = 0;
                        while (k < stardrive.this.iTileSize) {
                            int j = 0;
                            while (j < stardrive.this.iTileSize) {
                                stardrive.this.vAddParticle(this.fPosX + (float)k + stardrive.this.random(2.0f), this.fPosY + (float)j + stardrive.this.random(2.0f), 180.0f, stardrive.this.random(0.1f, 1.0f), 3, false, false);
                                j += 4;
                            }
                            k += 4;
                        }
                        ++i;
                    }
                }
                return true;
            }
            return false;
        }

        public boolean bIsOn() {
            return this.bOn;
        }

        public int iGetPosX() {
            return PApplet.parseInt((float)this.fPosX);
        }

        public int iGetPosY() {
            return PApplet.parseInt((float)this.fPosY);
        }

        public void vInit(int id, int x, int y, int type) {
            this.iId = id;
            this.fPosX = x;
            this.fPosY = y;
            this.iType = type - 48;
            if (this.iType != 0) {
                PImage tileSheet = null;
                while (tileSheet == null) {
                    tileSheet = stardrive.this.loadImage("tilesheet.png");
                    if (tileSheet != null) continue;
                    stardrive.println((String)"Reloading tile for some curious error");
                }
                this.pPic = tileSheet.get(this.iType * stardrive.this.iTileSize, 0, stardrive.this.iTileSize, stardrive.this.iTileSize);
                this.bOn = true;
            } else {
                this.bOn = false;
            }
        }

        public void vDisplay(PGraphics surface, float offsetX, float offsetY) {
            if (this.bOn) {
                surface.beginDraw();
                if (this.iType != 1) {
                    surface.image(this.pPic, this.fPosX + offsetX, this.fPosY + offsetY);
                } else {
                    surface.noStroke();
                    surface.fill(stardrive.this.cGreenMediumBright);
                    surface.rect(this.fPosX + offsetX, this.fPosY + offsetY, (float)stardrive.this.iTileSize, (float)stardrive.this.iTileSize);
                }
                surface.endDraw();
            }
        }

        public void vSwitchOff(int p) {
            if (stardrive.this.iScreen == 2 || stardrive.this.iScreen == 3) {
                stardrive.this.audioOut[p].playNote(0.0f, stardrive.this.fSoundDuration, stardrive.this.sSoundTileDestroyed);
            }
            this.bOn = false;
            int i = 0;
            while (i < 12) {
                int k = 0;
                while (k < stardrive.this.iTileSize) {
                    int j = 0;
                    while (j < stardrive.this.iTileSize) {
                        stardrive.this.vAddParticle(this.fPosX + (float)k + stardrive.this.random(2.0f), this.fPosY + (float)j + stardrive.this.random(2.0f), 180.0f, stardrive.this.random(0.1f, 1.0f), 3, false, false);
                        j += 4;
                    }
                    k += 4;
                }
                ++i;
            }
        }
    }

    class Tree {
        int iId = -1;
        boolean bOn = false;
        float fPosX = 0.0f;
        float fPosY = 0.0f;
        int iType = 11;

        Tree(int id) {
            this.iId = id;
        }

        public boolean bIsOn() {
            return this.bOn;
        }

        public void vAdd(float x, float y) {
            this.fPosX = x;
            this.fPosY = y;
            this.iType = PApplet.parseInt((float)stardrive.this.random(11.0f, 15.0f));
            this.bOn = true;
        }

        public void vDisplay(PGraphics surface) {
            if (this.bOn) {
                surface.beginDraw();
                surface.stroke(stardrive.this.cGreenDark);
                surface.image(stardrive.this.pTilesheet.get(this.iType * stardrive.this.iTileSize, 0 * stardrive.this.iTileSize, stardrive.this.iTileSize, stardrive.this.iTileSize), this.fPosX, this.fPosY);
                surface.endDraw();
            }
        }
    }
}

