/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gamecontrolplus.Configuration;
import org.gamecontrolplus.ControlButton;
import org.gamecontrolplus.ControlDevice;
import org.gamecontrolplus.ControlHat;
import org.gamecontrolplus.ControlIO;
import org.gamecontrolplus.ControlInput;
import org.gamecontrolplus.ControlSlider;
import org.gamecontrolplus.gui.KBase;
import org.gamecontrolplus.gui.KBaseInput;
import org.gamecontrolplus.gui.KConnector;
import org.gamecontrolplus.gui.KConstants;
import org.gamecontrolplus.gui.KDescriptor;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAlign;
import org.gamecontrolplus.gui.MButton;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MLabel;
import org.gamecontrolplus.gui.MTextArea;
import org.gamecontrolplus.gui.MWinData;
import org.gamecontrolplus.gui.MWindow;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.event.MouseEvent;

public class KConfigDeviceUI
implements PConstants,
KConstants {
    private final PApplet app;
    private final ControlIO controlIO;
    private MWindow window;
    private MTextArea txaStatus;
    private int status = 0;
    private final ControlDevice device;
    private Configuration config;
    private KConnector start = null;
    private KConnector end = null;
    private KConnector current = null;
    float scale;
    float input_UI_height;
    float desc_UI_height;
    float element_UI_gap;
    float input_UI_length;
    float desc_UI_length;
    float textfield_gap;
    float indicator_d;
    float connector_size_r;
    float connector_size_d;
    float fontSize;
    Font font;
    float spaceNeeded;
    float spaceForDescs;
    float spaceForInputs;
    private int winHeight;
    private boolean dragging = false;
    private List<KBase> uiElements = new ArrayList<KBase>();
    private List<KConnector> uiConnections = new ArrayList<KConnector>();
    private Map<String, KBaseInput> devInpKeys = new HashMap<String, KBaseInput>();
    private Map<String, KDescriptor> descriptors = new HashMap<String, KDescriptor>();
    private StringBuffer report;
    private int errCount = 0;

    public KConfigDeviceUI(PApplet pApplet, Configuration configuration, ControlDevice controlDevice) {
        this.app = pApplet;
        this.controlIO = ControlIO.getInstance(pApplet);
        this.device = controlDevice;
        controlDevice.open();
        this.config = configuration;
        this.createMetrics();
        this.createGUI(pApplet);
    }

    private void createGUI(PApplet pApplet) {
        M4P.messagesEnabled(false);
        String string = "'" + this.device.getName() + "'  [" + this.device.getTypeName() + " on " + this.device.getPortTypeName() + "]";
        this.window = MWindow.getWindow(pApplet, string, 80, 100, 1020, this.winHeight, "processing.awt.PGraphicsJava2D");
        M4P.setCursor(1);
        float f = this.window.width - 320 + 10;
        float f2 = 300.0f;
        float f3 = 10.0f;
        MLabel mLabel = new MLabel(this.window, f, f3, f2, 20.0f, "Config. for: " + this.config.getUsage());
        mLabel.setTextAlign(MAlign.LEFT, null);
        mLabel.setLocalColorScheme(1);
        mLabel.setTextBold();
        mLabel.setOpaque(true);
        float f4 = (f2 - 20.0f) / 3.0f;
        MButton mButton = new MButton(this.window, f, f3 += 26.0f, f4, 20.0f);
        mButton.setLocalColorScheme(1);
        mButton.setText("Clear Status");
        mButton.addEventHandler(this, "clear_click");
        MButton mButton2 = new MButton(this.window, f + (f2 - f4) / 2.0f, f3, f4, 20.0f);
        mButton2.setLocalColorScheme(1);
        mButton2.setText("Verify");
        mButton2.addEventHandler(this, "verify_click");
        MButton mButton3 = new MButton(this.window, f + f2 - f4, f3, f4, 20.0f);
        mButton3.setLocalColorScheme(1);
        mButton3.setText("USE");
        mButton3.addEventHandler(this, "use_device_click");
        MLabel mLabel2 = new MLabel(this.window, f, f3 += 26.0f, f2, 20.0f, "VERIFY / SAVE STATUS REPORT");
        mLabel2.setLocalColorScheme(1);
        mLabel2.setTextBold();
        mLabel2.setOpaque(true);
        this.txaStatus = new MTextArea(this.window, f, f3 += 22.0f, f2, 140.0f, 1);
        this.txaStatus.setLocalColorScheme(1);
        this.txaStatus.setPromptText("Verify / save status report");
        MButton mButton4 = new MButton(this.window, f, f3 += this.txaStatus.getHeight() + 4.0f, f2, 20.0f);
        mButton4.setLocalColorScheme(0);
        mButton4.setText("CANCEL CONFIGURATION AND EXIT");
        mButton4.addEventHandler(this, "quit_click");
        this.window.textSize(this.fontSize);
        this.addConfigToGUI(this.spaceNeeded, this.spaceForDescs, this.spaceForInputs);
        this.makeExistingConnections();
        this.window.addDrawHandler(this, "draw");
        this.window.addMouseHandler(this, "mouse");
        this.window.addPreHandler(this, "pre");
        this.window.loop();
    }

    private void createMetrics() {
        this.spaceForInputs = 4.0f;
        for (ControlInput controlInput : this.device.getInputs()) {
            if (controlInput instanceof ControlHat) {
                this.spaceForInputs += 126.0f;
                continue;
            }
            if (controlInput instanceof ControlButton) {
                this.spaceForInputs += 30.0f;
                continue;
            }
            if (controlInput instanceof ControlSlider) {
                this.spaceForInputs += 102.0f;
                continue;
            }
            System.out.println("Unknown input " + controlInput);
        }
        this.spaceForDescs = (float)this.config.nbrInputs() * 36.0f;
        this.spaceNeeded = Math.max(this.spaceForInputs, this.spaceForDescs);
        this.spaceNeeded = Math.max(this.spaceNeeded, 280.0f);
        this.scale = (float)this.app.displayHeight < this.spaceNeeded + 40.0f ? (float)this.app.displayHeight / (this.spaceNeeded + 40.0f) : 1.0f;
        this.winHeight = Math.round(this.spaceNeeded * this.scale);
        this.input_UI_height = 24.0f * this.scale;
        this.desc_UI_height = 30.0f * this.scale;
        this.element_UI_gap = 4.0f * this.scale;
        this.input_UI_length = 220.0f;
        this.desc_UI_length = 300.0f;
        this.textfield_gap = 4.0f * this.scale;
        this.indicator_d = 12.0f * this.scale;
        this.connector_size_r = 10.0f * this.scale;
        this.connector_size_d = 2.0f * this.connector_size_r;
        this.fontSize = 12.0f * this.scale;
        this.font = new Font("Dialog", 0, (int)this.fontSize);
    }

    private void addConfigToGUI(float f, float f2, float f3) {
        float f4 = (float)(this.window.width - 10) - 220.0f - 320.0f;
        float f5 = 4.0f + (f - f3) / 2.0f;
        for (ControlInput controlInput : this.device.getInputs()) {
            KBaseInput kBaseInput = KBaseInput.makeInputUI(this, controlInput, f4, f5);
            if (kBaseInput == null) continue;
            this.uiElements.add(kBaseInput);
            f5 += kBaseInput.UI_HEIGHT + 4.0f;
            this.devInpKeys.put(kBaseInput.name, kBaseInput);
        }
        f4 = 10.0f;
        f5 = 4.0f + (f - f2) / 2.0f;
        for (Configuration.InputConfig inputConfig : this.config.getGameInputs()) {
            KDescriptor kDescriptor = new KDescriptor(this, f4, f5, inputConfig);
            this.uiElements.add(kDescriptor);
            this.descriptors.put(kDescriptor.name, kDescriptor);
            f5 += kDescriptor.UI_HEIGHT + 4.0f;
        }
        for (KBase kBase : this.uiElements) {
            for (KConnector kConnector : kBase.connectors) {
                this.uiConnections.add(kConnector);
            }
        }
    }

    private void makeExistingConnections() {
        for (Configuration.InputConfig inputConfig : this.config.getGameInputs()) {
            KBaseInput kBaseInput = this.devInpKeys.get(inputConfig.deviceInputName);
            if (kBaseInput == null || inputConfig.type != kBaseInput.uiType || inputConfig.inputConNo >= kBaseInput.getNbrOfConnectors()) continue;
            KDescriptor kDescriptor = this.descriptors.get(inputConfig.key);
            kDescriptor.connectors[0].conTo = kBaseInput.connectors[inputConfig.inputConNo];
            kBaseInput.connectors[inputConfig.inputConNo].conTo = kDescriptor.connectors[0];
            kBaseInput.setMultiplier(inputConfig.multiplier);
            kBaseInput.setTolerance(inputConfig.tolerance);
        }
    }

    private void addToReport(String string, boolean bl) {
        this.report.append(string);
        if (bl) {
            ++this.errCount;
        }
    }

    private boolean verifyConfig(boolean bl) {
        this.report = new StringBuffer();
        for (Configuration.InputConfig inputConfig : this.config.getGameInputs()) {
            KDescriptor kDescriptor = this.descriptors.get(inputConfig.key);
            KConnector kConnector = kDescriptor.connectors[0].conTo;
            if (kConnector != null) {
                inputConfig.deviceInputName = kConnector.owner.name;
                inputConfig.inputConNo = kConnector.conNo;
                inputConfig.multiplier = ((KBaseInput)kConnector.owner).getMultiplier();
                inputConfig.tolerance = ((KBaseInput)kConnector.owner).getTolerance();
                continue;
            }
            this.addToReport("No input assigned to: " + kDescriptor.name + "\n", true);
        }
        if (this.errCount > 0) {
            this.addToReport("VERIFY - " + this.errCount + " errors found\n", false);
        } else {
            this.addToReport("VERIFY - successful\n", false);
        }
        if (!bl) {
            this.txaStatus.setText(this.report.toString());
        }
        return this.errCount == 0;
    }

    private boolean saveConfig() {
        if (!this.verifyConfig(true)) {
            this.addToReport("SAVE - abandoned\n", false);
            this.txaStatus.setText(this.report.toString());
            return false;
        }
        Configuration.saveConfiguration(this.app, this.config);
        return true;
    }

    public void verify_click(MButton mButton, MEvent mEvent) {
        this.verifyConfig(false);
    }

    public void use_device_click(MButton mButton, MEvent mEvent) {
        if (this.saveConfig()) {
            this.device.matches(this.config);
            this.controlIO.finishedConfig(this.device);
            this.status = 2;
        }
    }

    public void quit_click(MButton mButton, MEvent mEvent) {
        this.controlIO.finishedConfig(null);
        this.status = 1;
    }

    public void clear_click(MButton mButton, MEvent mEvent) {
        this.txaStatus.setText("");
    }

    public synchronized void pre(PApplet pApplet, MWinData mWinData) {
        this.current = null;
        for (KBase kBase : this.uiElements) {
            kBase.update();
            kBase.overWhat(pApplet.mouseX, pApplet.mouseY);
        }
        if (!this.dragging && this.current != null && this.current.conTo != null) {
            this.current.conTo.isOver = true;
        }
    }

    public synchronized void mouse(PApplet pApplet, MWinData mWinData, MouseEvent mouseEvent) {
        switch (mouseEvent.getAction()) {
            case 1: {
                if (this.current == null) break;
                this.start = this.current;
                this.dragging = true;
                break;
            }
            case 2: {
                if (this.current != null && this.start != null && this.current.type != this.start.type) {
                    KConnector kConnector = this.current.type == 2 ? this.current : this.start;
                    KDescriptor kDescriptor = (KDescriptor)kConnector.owner;
                    KConnector kConnector2 = this.start.type == 1 ? this.start : this.current;
                    KBaseInput kBaseInput = (KBaseInput)kConnector2.owner;
                    int n = ((KDescriptor)kConnector.owner).iconfig.type;
                    int n2 = kConnector2.owner.uiType;
                    if (n == n2) {
                        this.end = this.current;
                        this.current = null;
                        if (this.start.conTo != null) {
                            this.start.conTo.conTo = null;
                        }
                        if (this.end.conTo != null) {
                            this.end.conTo.conTo = null;
                        }
                        this.start.conTo = this.end;
                        this.end.conTo = this.start;
                        kDescriptor.iconfig.deviceInputName = kBaseInput.name;
                        kBaseInput.setMultiplier(kDescriptor.iconfig.multiplier);
                        kBaseInput.setTolerance(kDescriptor.iconfig.tolerance);
                    }
                }
                this.start = null;
                this.current = null;
                this.dragging = false;
                break;
            }
        }
    }

    void current(KConnector kConnector) {
        this.current = kConnector;
    }

    public synchronized void draw(PApplet pApplet, MWinData mWinData) {
        pApplet.background(-983056);
        pApplet.noStroke();
        pApplet.fill(-14647264);
        pApplet.rect((float)(pApplet.width - 320), 0.0f, 320.0f, (float)pApplet.height);
        pApplet.strokeWeight(3.5f);
        for (KConnector kConstants : this.uiConnections) {
            if (kConstants.conTo == null || kConstants.type != 2) continue;
            pApplet.stroke(kConstants.isOver ? -48897 : -8355680);
            pApplet.line(kConstants.px, kConstants.py, kConstants.conTo.px, kConstants.conTo.py);
        }
        if (this.dragging && this.start != null) {
            pApplet.stroke(-8355680);
            pApplet.line(this.start.px, this.start.py, (float)pApplet.mouseX, (float)pApplet.mouseY);
        }
        for (KBase kBase : this.uiElements) {
            kBase.draw();
        }
    }

    public MWindow getWindow() {
        return this.window;
    }

    public int status() {
        return this.status;
    }

    public void finishedWith() {
        this.window.noLoop();
        this.window.forceClose();
    }
}

