/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import org.gamecontrolplus.ControlButton;
import org.gamecontrolplus.ControlHat;
import org.gamecontrolplus.ControlInput;
import org.gamecontrolplus.ControlSlider;
import org.gamecontrolplus.gui.KBase;
import org.gamecontrolplus.gui.KButton;
import org.gamecontrolplus.gui.KConfigDeviceUI;
import org.gamecontrolplus.gui.KConnector;
import org.gamecontrolplus.gui.KCoolieHat;
import org.gamecontrolplus.gui.KSlider;

public abstract class KBaseInput
extends KBase {
    int namePos;
    String inputTypeName = "";

    public static KBaseInput makeInputUI(KConfigDeviceUI kConfigDeviceUI, ControlInput controlInput, float f, float f2) {
        KBaseInput kBaseInput = null;
        if (controlInput instanceof ControlHat) {
            kBaseInput = new KCoolieHat(kConfigDeviceUI, (ControlHat)controlInput, f, f2);
        } else if (controlInput instanceof ControlButton) {
            kBaseInput = new KButton(kConfigDeviceUI, (ControlButton)controlInput, f, f2);
        } else if (controlInput instanceof ControlSlider) {
            kBaseInput = new KSlider(kConfigDeviceUI, (ControlSlider)controlInput, f, f2);
        }
        return kBaseInput;
    }

    public float getValue() {
        return 0.0f;
    }

    public float getMultiplier() {
        return 0.0f;
    }

    public void setTolerance(float f) {
    }

    public void setMultiplier(float f) {
    }

    public float getTolerance() {
        return 0.0f;
    }

    public KBaseInput(KConfigDeviceUI kConfigDeviceUI, float f, float f2, int n, int n2) {
        super(kConfigDeviceUI, f, f2, n);
        for (int i = 0; i < this.connectors.length; ++i) {
            this.connectors[i] = new KConnector(this.app, this, i, this.px - kConfigDeviceUI.connector_size_r, this.py + ((float)i + 0.0f) * kConfigDeviceUI.input_UI_height + kConfigDeviceUI.connector_size_r, kConfigDeviceUI.connector_size_d);
        }
        this.UI_HEIGHT = (float)n2 * kConfigDeviceUI.input_UI_height;
        this.fontBaseLine = (kConfigDeviceUI.input_UI_height + kConfigDeviceUI.fontSize) / 2.0f;
    }

    protected void drawBackground() {
        this.app.noStroke();
        this.app.fill(this.backCol);
        this.app.rect(0.0f, 0.0f, this.ccw.input_UI_length, this.UI_HEIGHT);
        this.app.fill(-16777088);
        this.app.text(this.name, (float)this.namePos, this.fontBaseLine);
    }

    @Override
    protected void drawConnectors() {
        for (int i = 0; i < this.connectors.length; ++i) {
            this.connectors[i].draw((float)i * this.ccw.input_UI_height);
        }
    }

    protected void drawControlHighlight() {
        this.app.stroke(this.isOver ? -48897 : -12566368);
        this.app.strokeWeight(this.isOver ? 4.0f : 1.0f);
        this.app.noFill();
        this.app.rect(0.0f, 0.0f, this.ccw.input_UI_length, this.UI_HEIGHT);
    }
}

