/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.GenericDesktopUsage;
import net.java.games.input.Keyboard;
import net.java.games.input.Mouse;
import net.java.games.input.OSXAbstractController;
import net.java.games.input.OSXComponent;
import net.java.games.input.OSXHIDDevice;
import net.java.games.input.OSXHIDDeviceIterator;
import net.java.games.input.OSXHIDElement;
import net.java.games.input.OSXHIDQueue;
import net.java.games.input.OSXKeyboard;
import net.java.games.input.OSXMouse;
import net.java.games.input.Rumbler;
import net.java.games.input.UsagePage;
import net.java.games.input.UsagePair;

public final class OSXEnvironmentPlugin
extends ControllerEnvironment {
    private final Controller[] controllers = OSXEnvironmentPlugin.enumerateControllers();

    private static final boolean isMacOSXEqualsOrBetterThan(int n, int n2) {
        int n3;
        int n4;
        String string = System.getProperty("os.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            n4 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            ControllerEnvironment.logln("Exception occurred while trying to determine OS version: " + exception);
            return false;
        }
        return n4 > n || n4 == n && n3 >= n2;
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    private static final void addElements(OSXHIDQueue oSXHIDQueue, List list, List list2, boolean bl) throws IOException {
        for (OSXHIDElement oSXHIDElement : list) {
            Component.Identifier identifier = oSXHIDElement.getIdentifier();
            if (identifier == null) continue;
            if (bl) {
                if (identifier == Component.Identifier.Button._0) {
                    identifier = Component.Identifier.Button.LEFT;
                } else if (identifier == Component.Identifier.Button._1) {
                    identifier = Component.Identifier.Button.RIGHT;
                } else if (identifier == Component.Identifier.Button._2) {
                    identifier = Component.Identifier.Button.MIDDLE;
                }
            }
            OSXComponent oSXComponent = new OSXComponent(identifier, oSXHIDElement);
            list2.add(oSXComponent);
            oSXHIDQueue.addElement(oSXHIDElement, oSXComponent);
        }
    }

    private static final Keyboard createKeyboardFromDevice(OSXHIDDevice oSXHIDDevice, List list) throws IOException {
        ArrayList arrayList = new ArrayList();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list, arrayList, false);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        OSXKeyboard oSXKeyboard = new OSXKeyboard(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0]);
        return oSXKeyboard;
    }

    private static final Mouse createMouseFromDevice(OSXHIDDevice oSXHIDDevice, List list) throws IOException {
        ArrayList arrayList = new ArrayList();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list, arrayList, true);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        OSXMouse oSXMouse = new OSXMouse(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0]);
        if (oSXMouse.getLeft() != null && oSXMouse.getX() != null && oSXMouse.getY() != null) {
            return oSXMouse;
        }
        oSXHIDQueue.release();
        return null;
    }

    private static final AbstractController createControllerFromDevice(OSXHIDDevice oSXHIDDevice, List list, Controller.Type type) throws IOException {
        ArrayList arrayList = new ArrayList();
        OSXHIDQueue oSXHIDQueue = oSXHIDDevice.createQueue(32);
        try {
            OSXEnvironmentPlugin.addElements(oSXHIDQueue, list, arrayList, false);
        }
        catch (IOException iOException) {
            oSXHIDQueue.release();
            throw iOException;
        }
        Component[] componentArray = new Component[arrayList.size()];
        arrayList.toArray(componentArray);
        OSXAbstractController oSXAbstractController = new OSXAbstractController(oSXHIDDevice, oSXHIDQueue, componentArray, new Controller[0], new Rumbler[0], type);
        return oSXAbstractController;
    }

    private static final void createControllersFromDevice(OSXHIDDevice oSXHIDDevice, List list) throws IOException {
        AbstractController abstractController;
        UsagePair usagePair = oSXHIDDevice.getUsagePair();
        if (usagePair == null) {
            return;
        }
        List list2 = oSXHIDDevice.getElements();
        if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && (usagePair.getUsage() == GenericDesktopUsage.MOUSE || usagePair.getUsage() == GenericDesktopUsage.POINTER)) {
            Mouse mouse = OSXEnvironmentPlugin.createMouseFromDevice(oSXHIDDevice, list2);
            if (mouse != null) {
                list.add(mouse);
            }
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && (usagePair.getUsage() == GenericDesktopUsage.KEYBOARD || usagePair.getUsage() == GenericDesktopUsage.KEYPAD)) {
            Keyboard keyboard = OSXEnvironmentPlugin.createKeyboardFromDevice(oSXHIDDevice, list2);
            if (keyboard != null) {
                list.add(keyboard);
            }
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && usagePair.getUsage() == GenericDesktopUsage.JOYSTICK) {
            AbstractController abstractController2 = OSXEnvironmentPlugin.createControllerFromDevice(oSXHIDDevice, list2, Controller.Type.STICK);
            if (abstractController2 != null) {
                list.add(abstractController2);
            }
        } else if (usagePair.getUsagePage() == UsagePage.GENERIC_DESKTOP && usagePair.getUsage() == GenericDesktopUsage.GAME_PAD && (abstractController = OSXEnvironmentPlugin.createControllerFromDevice(oSXHIDDevice, list2, Controller.Type.GAMEPAD)) != null) {
            list.add(abstractController);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Controller[] enumerateControllers() {
        Controller[] controllerArray;
        ArrayList arrayList = new ArrayList();
        try {
            controllerArray = new OSXHIDDeviceIterator();
            try {
                OSXHIDDevice oSXHIDDevice;
                while ((oSXHIDDevice = controllerArray.next()) != null) {
                    boolean bl = false;
                    try {
                        int n = arrayList.size();
                        OSXEnvironmentPlugin.createControllersFromDevice(oSXHIDDevice, arrayList);
                        bl = n != arrayList.size();
                    }
                    catch (IOException iOException) {
                        ControllerEnvironment.logln("Failed to create controllers from device: " + oSXHIDDevice.getProductName());
                    }
                    if (bl) continue;
                    oSXHIDDevice.release();
                }
            }
            finally {
                controllerArray.close();
            }
        }
        catch (IOException iOException) {
            ControllerEnvironment.log("Failed to enumerate device: " + iOException.getMessage());
            return new Controller[0];
        }
        controllerArray = new Controller[arrayList.size()];
        arrayList.toArray(controllerArray);
        return controllerArray;
    }

    static {
        System.loadLibrary("jinput-osx");
    }
}

