
/*
 Nurtle Turtle Implementation
 mail@dace.de 2014
 Works with Processing 2.0.3

 This is my nerdy Turtle Graphics implementation in Processing.
 It is intended to be used to experiment with (graphical) 
 recursion. Feel free to modify.

use:
 Nurtle()
 void reset()
 void reset(float fToX, float fToY)
 void start()
 void end()
 void forward(float fDist)
 void backward(float fDist)
 void left(float fDegrees)
 void right(float fDegrees)
 void orientation(float fNewOrientationDegrees)
 void up()
 void down()
*/

Nurtle nurtle;
int iMyStep=0;

void setup ()
{
  smooth();
  noFill();
  size(600, 400);
  //noLoop();  //if you just want to see the finished graphics, uncomment this

  nurtle=new Nurtle();
}

void vSpiral(float f)
{
  if (f<10) { 
    return;
  }
  nurtle.forward(f*0.5);
  nurtle.left(35);
  vSpiral(f*0.8);
  nurtle.forward(f*0.5);
  nurtle.right(35);
}

//source: interactivepython.org/runestone/static/pythonds/Recursion/graphical.html
void vBlockySpiral(int lineLen)
{
  if (lineLen>0)
  {
    nurtle.forward(lineLen);
    nurtle.right(90);
    vBlockySpiral(lineLen-5);
  }
}

//modified from interactivepython.org/runestone/static/pythonds/Recursion/graphical.html
void vBlockySpiralLeft(int lineLen)
{
  if (lineLen>0)
  {
    nurtle.forward(lineLen);
    nurtle.left(90);
    vBlockySpiralLeft(lineLen-5);
  }
}

//slightly modified from http://interactivepython.org/runestone/static/pythonds/Recursion/graphical.html
void vTree(int branchLen)
{
  branchLen+=random(-2, 4);
  if (branchLen > 5)
  {
    nurtle.forward(branchLen);
    nurtle.right(20);
    vTree(branchLen-15);
    nurtle.left(40);
    vTree(branchLen-15);
    nurtle.right(20);
    nurtle.backward(branchLen);
  }
}

void vBox(int branchLen)
{
  if (branchLen > 5)
  {
    nurtle.forward(branchLen);
    nurtle.left(90);
    nurtle.forward(branchLen);
    nurtle.left(90);
    nurtle.forward(branchLen);
    nurtle.left(90);
    nurtle.forward(branchLen);
    nurtle.left(90);
    nurtle.up();
    nurtle.left(45);
    nurtle.forward(branchLen*0.1);
    nurtle.right(40);
    nurtle.down();
    vBox(branchLen-15);
  }
}

void vBoxes(int branchLen)
{
  if (branchLen > 5)
  {
    nurtle.forward(branchLen);
    nurtle.left(90);
    nurtle.forward(branchLen*0.5);
    vBoxes(branchLen-15);
    nurtle.left(90);
    nurtle.forward(branchLen);
    nurtle.left(90);
    nurtle.forward(branchLen*0.5);
    nurtle.left(135);
    vBoxes(branchLen-15);
  }
}

void draw()
{
  nurtle.start();

  /*
  nurtle.forward(100);
  nurtle.left(90);
  nurtle.forward(50);
  nurtle.right(90);
  nurtle.up();
  nurtle.forward(100);
  nurtle.right(70);
  nurtle.backward(50);
  nurtle.down();
  nurtle.left(20);
  nurtle.backward(40);
  nurtle.left(10);
  nurtle.forward(100);
  nurtle.left(90);
  nurtle.forward(50);
  */

  //vSpiral(100);
  //vBlockySpiral(100);
  //vBlockySpiralLeft(100);
  //vBox(100);
  //vBoxes(100);
  vTree(90);
  nurtle.end();
}

