
//Nurtle Turtle Implementation
//mail@dace.de 2014
//Works with Processing 2.0.3

class Steps
{
  int iId=-1;
  float fOrientationDegrees=0;  //0 is along the x-axis
  float fPosX=0;
  float fPosY=0;
  float fPosStartX=0;
  float fPosStartY=0;
  int iType=-1;
  float fSpeed=0;
  float fMove=0;

  boolean bPenDown=false;

  Steps(int iId)
  {
    this.iId=iId;
    fOrientationDegrees=0;
    fPosX=0;
    fPosY=0;
    fPosStartX=0;
    fPosStartY=0;
    iType=-1;
    fSpeed=0;
    fMove=0;
  }

  /*
  0 reset
   2 speed
   4 forward
   5 backward
   7 left
   8 right
   10 orientation
   12 pen
   */
  void vType(int iT)
  {
    iType=iT;
  }

  int iTypeRetrieve()
  {
    return iType;
  }

  void vSpeedSave(float fS)
  {
    fSpeed=fS;
  }

  float fSpeedRetrieve()
  {
    return fSpeed;
  }

  void vResetSave(float fResX, float fResY)
  {
    fPosX=fResX;
    fPosY=fResY;
  }

  void vMoveSave(float fDist)
  {
    fMove=fDist;
  }

  float fMoveRetrieve()
  {
    return fMove;
  }

  void vOrientationSave(float f)
  {
    fOrientationDegrees=f;
  }

  float fOrientationRetrieve()
  {
    return fOrientationDegrees;
  }

  void vPosSave(float fPosX, float fPosY)
  {
    this.fPosX=fPosX;
    this.fPosY=fPosY;
  }

  float fPosXRetrieve()
  {
    return fPosX;
  }

  float fPosYRetrieve()
  {
    return fPosY;
  }

  void vPosStartSave(float fPosStartX, float fPosStartY)
  {
    this.fPosStartX=fPosStartX;
    this.fPosStartY=fPosStartY;
  }

  float fPosStartXRetrieve()
  {
    return fPosStartX;
  }

  float fPosStartYRetrieve()
  {
    return fPosStartY;
  }

  void vPenSave(boolean b)
  {
    bPenDown=b;
  }

  boolean bPenRetrieve()
  {
    return bPenDown;
  }

  //debug output
  void vOutput()
  {
    println("step "+iId+": Type "+iTypeRetrieve()+", speed "+fSpeedRetrieve()+", move "+fMoveRetrieve()+" ori "+round(fOrientationRetrieve())+", pen "+bPenRetrieve()+", pos change "+round(fPosXRetrieve())+"/"+round(fPosYRetrieve())+", pos "+round(fPosStartXRetrieve())+"/"+round(fPosStartYRetrieve()));
  }
}

