
//Nurtle Turtle Implementation
//mail@dace.de 2014
//Works with Processing 2.0.3

class Nurtle
{
  float fX=width*0.5;
  float fY=height-50;
  float fBakX=0;
  float fBakY=0;
  float fOrientationDegrees=90;  //0 is along the x-axis
  float fOrientationDegreesBak=0;
  float fPixelsPerSec=200;
  int iTicksLastUpdate=0;
  boolean bDraw=true;
  boolean bIsRunning=false;
  Steps[] step=new Steps[1000];  //array to store changes in orientation and coordinates to visit
  boolean bNoRotationAnimation=false;  //set to true for no turning animation
  float fMoveExtra=0;
  int iMyNurtle=-1;

  Nurtle()
  {
    for (int i=0; i<step.length; i++) { 
      step[i]=new Steps(i);
    } 
    iTicksLastUpdate=millis();  //needed?
  }

  boolean bIsRunning()
  {
    return bIsRunning;
  }

  void reset()
  {
    fX=width*0.5;
    fY=height-50;
    step[iMyStep].vType(0);
    step[iMyStep].vResetSave(fX, fY);
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void reset(float fToX, float fToY)
  {
    if ((fToX<0) || (fToY<0)) { 
      reset(); 
      return;
    }
    fX=fToX;
    fY=fToY;
    step[iMyStep].vType(0);
    step[iMyStep].vResetSave(fX, fY);
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void start()
  {
    if (bIsRunning()) { 
      return;
    }  //nurtle is already running, i.e. end() has been called

    for (int i=0; i<step.length; i++) { 
      step[i]=new Steps(i);
    } 
    iTicksLastUpdate=millis();

    iMyNurtle++;
    println("Nurtle "+iMyNurtle+": Start at "+fX+"/"+fY+", orientation "+fOrientationDegrees);
  }

  void end()
  {
    if (bIsRunning()==false)  //nurtle is not already running, i.e. end() has not been called
    { 
      println("Nurtle "+iMyNurtle+": End at "+fX+"/"+fY+", orientation "+fOrientationDegrees);
      bIsRunning=true;
      iMyStep=0;
      fX=width*0.5;
      fY=height-50;
      fBakX=fX;
      fBakY=fY;
      fOrientationDegreesBak=fOrientationDegrees=90;
      iTicksLastUpdate=millis();
      return;
    }

    vUpdate();
    vDisplay();
  }

  void forward(float fDist)
  {
    if (bIsRunning()) { 
      return;
    }  //nurtle is already running, i.e. end() has been called

    //x' = x cos f - y sin f
    //y' = y cos f + x sin f
    float fTargetX=(fDist*cos(radians(-1*fOrientationDegrees)))-(0*sin(radians(-1*fOrientationDegrees)));
    float fTargetY=(fDist*sin(radians(-1*fOrientationDegrees)))+(0*cos(radians(-1*fOrientationDegrees)));

    step[iMyStep].vType(4);
    step[iMyStep].vMoveSave(fDist);
    step[iMyStep].vPosSave(fTargetX, fTargetY);  //save the relative position change (not the absolute pos)
    step[iMyStep].vPosStartSave(fX, fY);  //save the absolute start pos of this step
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }

    if (bDraw) {
      stroke(0);
    }
    else { 
      stroke(80);
    }
    line(round(fX), round(fY), round(fTargetX+fX), round(fTargetY+fY));  //debug
    fX+=fTargetX;
    fY+=fTargetY;
  }

  void backward(float fDist)
  {
    if (bIsRunning()) { 
      return;
    }  //nurtle is already running, i.e. end() has been called

    fDist*=-1;

    //x' = x cos f - y sin f
    //y' = y cos f + x sin f
    float fTargetX=(fDist*cos(radians(-1*fOrientationDegrees)))-(0*sin(radians(-1*fOrientationDegrees)));
    float fTargetY=(fDist*sin(radians(-1*fOrientationDegrees)))+(0*cos(radians(-1*fOrientationDegrees)));
    if (bDraw) { 
      stroke(0);
    }
    else { 
      stroke(80);
    }

    step[iMyStep].vType(5);
    step[iMyStep].vMoveSave(-1*fDist);
    step[iMyStep].vPosSave(fTargetX, fTargetY);  //save the relative position change (not the absolute pos)
    step[iMyStep].vPosStartSave(fX, fY);  //save the absolute start pos of this step
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }

    line(round(fX), round(fY), round(fTargetX+fX), round(fTargetY+fY));  //debug
    fX+=fTargetX;
    fY+=fTargetY;
  }

  void left(float fDegrees)
  {
    if (bIsRunning()) { 
      return;
    }  //nurtle is already running, i.e. end() has been called

    fOrientationDegrees+=fDegrees;

    while (fOrientationDegrees<360) { 
      fOrientationDegrees+=360;
    }
    while (fOrientationDegrees>=360) { 
      fOrientationDegrees-=360;
    }

    step[iMyStep].vType(7);
    step[iMyStep].vOrientationSave(fOrientationDegrees);  //save the target value (not the relative change)
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void right(float fDegrees)
  {
    if (bIsRunning()) { 
      return;
    }  //nurtle is already running, i.e. end() has been called

    fOrientationDegrees-=fDegrees;  //diff to left

    while (fOrientationDegrees<360) { 
      fOrientationDegrees+=360;
    }
    while (fOrientationDegrees>=360) { 
      fOrientationDegrees-=360;
    }

    step[iMyStep].vType(8);
    step[iMyStep].vOrientationSave(fOrientationDegrees);  //save the target value (not the relative change)
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void orientation(float fNewOrientationDegrees)
  {
    if (bIsRunning()) { 
      return;
    }  //nurtle is already running, i.e. end() has been called

    fOrientationDegrees=fNewOrientationDegrees;

    step[iMyStep].vType(10);
    step[iMyStep].vOrientationSave(fNewOrientationDegrees);
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void up()
  {
    if (bIsRunning()) { 
      return;
    }  //nurtle is already running, i.e. end() has been called

    bDraw=false;
    stroke(180);

    step[iMyStep].vType(12);
    step[iMyStep].vPenSave(false);
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void down()
  {
    if (bIsRunning()) { 
      return;
    }  //nurtle is already running, i.e. end() has been called

    bDraw=true;
    stroke(0);

    step[iMyStep].vType(12);
    step[iMyStep].vPenSave(true);
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void vUpdate()
  {
    if (bIsRunning()==false) { 
      return;
    }  //needed?
    if (step[iMyStep].iTypeRetrieve()==-1) { 
      //bIsRunning=false;
      return;
    }

    background(10, 200, 12);
    int iTicksNow=millis();
    int iTicksDiff=iTicksNow-iTicksLastUpdate;
    iTicksLastUpdate=iTicksNow;  //save for next update
    noStroke();
    fill(222, 20, 145);
    rect(0, height-17, width, 17);
    fill(147, 220, 12);
    text("N: "+(iMyStep)+"  Position:"+round(fX)+"/"+round(fY)+"  Orientation:"+round(fOrientationDegrees)+"º  Draw:"+bDraw, 6, height-4);
    float fDistanceMoveNow=fMoveExtra;
    fMoveExtra=0;
    fDistanceMoveNow+=fPixelsPerSec*float(iTicksDiff)*0.001;
    if (fDistanceMoveNow==0) { 
      return;
    }

    //redraw the whole thing in the background:
    fX=width*0.5;
    fY=height-50;
    stroke(11, 182, 22);
    for (int i=0; i<step.length; i++)
    {
      if (step[i].iTypeRetrieve()==-1)
      {
        break;
      }
      else if ((step[i].iTypeRetrieve()==4) || (step[i].iTypeRetrieve()==5))  //only these have pos data
      {
        fX=step[i].fPosStartXRetrieve()+step[i].fPosXRetrieve();
        fY=step[i].fPosStartYRetrieve()+step[i].fPosYRetrieve();
        line(round(step[i].fPosStartXRetrieve()), round(step[i].fPosStartYRetrieve()), round(fX), round(fY));
      }
    }

    //we redraw the whole thing every time and fast:
    fX=width*0.5;
    fY=height-50;
    bDraw=true;
    stroke(0);
    for (int i=0; i<iMyStep; i++)
    {
      if (step[i].iTypeRetrieve()==12)  //pen on/off
      {
        if (step[i].bPenRetrieve()) { 
          stroke(0);
          bDraw=true;
        }
        else { 
          stroke(180);
          bDraw=false;
        }
      }
      if ((step[i].iTypeRetrieve()==4) || (step[i].iTypeRetrieve()==5))  //only these have pos data
      {
        fX=step[i].fPosStartXRetrieve()+step[i].fPosXRetrieve();
        fY=step[i].fPosStartYRetrieve()+step[i].fPosYRetrieve();
        line(round(step[i].fPosStartXRetrieve()), round(step[i].fPosStartYRetrieve()), round(fX), round(fY));
      }
    }

    //we might have already changed orientation and moved part of the way of this step, that needs to be restored:
    fOrientationDegrees=fOrientationDegreesBak;
    fX=fBakX;
    fY=fBakY;

    switch(step[iMyStep].iTypeRetrieve()) {
    case 0:
      vReset();
      break;
    case 2:
      vSpeed();
      break;
    case 4:
      vForward(fDistanceMoveNow);
      break;
    case 5:
      vBackward(fDistanceMoveNow);
      break;
    case 7:
      vTurnLeft(fDistanceMoveNow);
      break;
    case 8:
      vTurnRight(fDistanceMoveNow);
      break;
    case 10:
      vOrientation();
      break;
    case 12:
      vPen();
      break;
    default:
      println("Unknown step type "+step[iMyStep].iTypeRetrieve());
      break;
    }
  }

  void vReset()
  {
    fBakX=fX=step[iMyStep].fPosXRetrieve();
    fBakY=fY=step[iMyStep].fPosYRetrieve();
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void vSpeed()
  {
    fPixelsPerSec=step[iMyStep].fSpeedRetrieve();
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void vTurnLeft(float fDistanceMoveNow)
  {
    if (bNoRotationAnimation)  //this speeds it up...
    { 
      fOrientationDegreesBak=fOrientationDegrees=step[iMyStep].fOrientationRetrieve();  //...by not using the turning animation
      if (iMyStep<step.length-1) {
        iMyStep++;
      }
      return;
    }
    float fOrientationDiff=step[iMyStep].fOrientationRetrieve()-fOrientationDegrees;
    if (step[iMyStep].fOrientationRetrieve()<=fOrientationDegrees)  //turn over 0
    {
      fOrientationDiff+=360;  //diff to turn left
    }

    if (fOrientationDiff-fDistanceMoveNow<=0)  //we have more move than we need
    {
      fOrientationDegreesBak=fOrientationDegrees=step[iMyStep].fOrientationRetrieve();
      fMoveExtra=fDistanceMoveNow-fOrientationDiff;
      while (fOrientationDegrees<0) { 
        fOrientationDegrees+=360;
      }
      while (fOrientationDegrees>=360) { 
        fOrientationDegrees-=360;
      }
      if (iMyStep<step.length-1) { 
        iMyStep++;
      }
    }
    else  //we turn a bit now and come back next update
    {
      fOrientationDegrees+=fDistanceMoveNow;
      fOrientationDegreesBak=fOrientationDegrees;
    }
  }

  void vTurnRight(float fDistanceMoveNow)
  {
    if (bNoRotationAnimation)  //this speeds it up...
    { 
      fOrientationDegreesBak=fOrientationDegrees=step[iMyStep].fOrientationRetrieve();  //...by not using the turning animation
      if (iMyStep<step.length-1) {
        iMyStep++;
      }
      return;
    }
    float fOrientationDiff=fOrientationDegrees-step[iMyStep].fOrientationRetrieve();  //diff to turn left
    fOrientationDiff*=-1;
    if (step[iMyStep].fOrientationRetrieve()>fOrientationDegrees)  //turn over 0
    {
      fOrientationDiff-=360;  //diff to turn left
    }

    if (abs(fOrientationDiff)-fDistanceMoveNow<=0)  //we have more move than we need
    {
      fOrientationDegreesBak=fOrientationDegrees=step[iMyStep].fOrientationRetrieve();
      fMoveExtra=fDistanceMoveNow-fOrientationDiff;
      while (fOrientationDegrees<0) { 
        fOrientationDegrees+=360;
      }
      while (fOrientationDegrees>=360) { 
        fOrientationDegrees-=360;
      }
      if (iMyStep<step.length-1) { 
        iMyStep++;
      }
    }
    else  //we turn a bit now and come back next update
    {
      fOrientationDegrees-=fDistanceMoveNow;  //diff to turn left
      fOrientationDegreesBak=fOrientationDegrees;
    }
  }

  void vOrientation()
  {
    fOrientationDegreesBak=fOrientationDegrees=step[iMyStep].fOrientationRetrieve();
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void vPen()
  {
    bDraw=step[iMyStep].bPenRetrieve();
    if (iMyStep<step.length-1) { 
      iMyStep++;
    }
  }

  void vForward(float fDistanceMoveNow)
  {
    float fDist=dist(fX, fY, step[iMyStep].fPosStartXRetrieve()+step[iMyStep].fPosXRetrieve(), step[iMyStep].fPosStartYRetrieve()+step[iMyStep].fPosYRetrieve());

    if (fDist<=fDistanceMoveNow)  //we have more move than we need
    {
      fX=step[iMyStep].fPosStartXRetrieve()+step[iMyStep].fPosXRetrieve();
      fY=step[iMyStep].fPosStartYRetrieve()+step[iMyStep].fPosYRetrieve();
      line(round(step[iMyStep].fPosStartXRetrieve()), round(step[iMyStep].fPosStartYRetrieve()), round(fX), round(fY)); 
      fBakX=fX;
      fBakY=fY;

      fMoveExtra=fDistanceMoveNow-fDist;
      if (iMyStep<step.length-1) { 
        iMyStep++;
      }
    }
    else  //we just move a bit and come back later
    {
      //x' = x cos f - y sin f
      //y' = y cos f + x sin f
      float fTargetX=(fDistanceMoveNow*cos(radians(-1*fOrientationDegrees)))-(0*sin(radians(-1*fOrientationDegrees)));
      float fTargetY=(fDistanceMoveNow*sin(radians(-1*fOrientationDegrees)))+(0*cos(radians(-1*fOrientationDegrees)));
      line(round(step[iMyStep].fPosStartXRetrieve()), round(step[iMyStep].fPosStartYRetrieve()), round(fX+fTargetX), round(fY+fTargetY));
      fBakX=fX=fX+fTargetX;
      fBakY=fY=fY+fTargetY;
    }
  }

  void vBackward(float fDistanceMoveNow)
  {
    float fDist=dist(fX, fY, step[iMyStep].fPosStartXRetrieve()+step[iMyStep].fPosXRetrieve(), step[iMyStep].fPosStartYRetrieve()+step[iMyStep].fPosYRetrieve());

    if (fDist<=fDistanceMoveNow)  //we have more move than we need
    {
      fX=step[iMyStep].fPosStartXRetrieve()+step[iMyStep].fPosXRetrieve();
      fY=step[iMyStep].fPosStartYRetrieve()+step[iMyStep].fPosYRetrieve();
      line(round(step[iMyStep].fPosStartXRetrieve()), round(step[iMyStep].fPosStartYRetrieve()), round(fX), round(fY)); 
      fBakX=fX;
      fBakY=fY;

      fMoveExtra=fDistanceMoveNow-fDist;
      if (iMyStep<step.length-1) { 
        iMyStep++;
      }
    }
    else  //we just move a bit and come back later
    {
      //x' = x cos f - y sin f
      //y' = y cos f + x sin f
      float fTargetX=(fDistanceMoveNow*cos(radians(-1*(fOrientationDegrees+180))))-(0*sin(radians(-1*(fOrientationDegrees+180))));  //diff to turn left
      float fTargetY=(fDistanceMoveNow*sin(radians(-1*(fOrientationDegrees+180))))+(0*cos(radians(-1*(fOrientationDegrees+180))));
      line(round(step[iMyStep].fPosStartXRetrieve()), round(step[iMyStep].fPosStartYRetrieve()), round(fX+fTargetX), round(fY+fTargetY));
      fBakX=fX=fX+fTargetX;
      fBakY=fY=fY+fTargetY;
    }
  }

  void vDisplay()
  {
    if (bIsRunning()==false) { 
      return;
    }  //needed?

    //draw a triangle:
    float fTopX=(7*cos(radians(-1*fOrientationDegrees)))-(0*sin(radians(-1*fOrientationDegrees)));
    float fTopY=(7*sin(radians(-1*fOrientationDegrees)))+(0*cos(radians(-1*fOrientationDegrees)));
    float fBottomLeftX=(-5*cos(radians(-1*fOrientationDegrees)))-(-5*sin(radians(-1*fOrientationDegrees)));
    float fBottomLeftY=(-5*sin(radians(-1*fOrientationDegrees)))+(-5*cos(radians(-1*fOrientationDegrees)));
    float fBottomRightX=(-5*cos(radians(-1*fOrientationDegrees)))-(5*sin(radians(-1*fOrientationDegrees)));
    float fBottomRightY=(-5*sin(radians(-1*fOrientationDegrees)))+(5*cos(radians(-1*fOrientationDegrees)));

    if (bDraw) { 
      stroke(234, 40, 77, 178);
      line(fX+fTopX, fY+fTopY, fX, fY);
      stroke(234, 240, 77, 178);
    }
    else { 
      stroke(77, 40, 234, 178);
      line(fX+fTopX, fY+fTopY, fX, fY);
      stroke(77, 234, 240, 178);
    }

    line(fX+fTopX, fY+fTopY, fX+fBottomRightX, fY+fBottomRightY);
    line(fX+fBottomRightX, fY+fBottomRightY, fX+fBottomLeftX, fY+fBottomLeftY);
    line(fX+fBottomLeftX, fY+fBottomLeftY, fX+fTopX, fY+fTopY);

    /*
    line(fX, fY-7, fX+5, fY+5);
     line(fX+5, fY+5, fX-5, fY+5);
     line(fX-5, fY+5, fX, fY-7);
     stroke(234, 40, 77, 178);
     line(fX, fY-5, fX, fY+2);
     */
    //ellipse(fX, fY, 5, 5);
  }
}

