/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioMetaData;
import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import ddf.minim.UGen;
import ddf.minim.analysis.FFT;
import ddf.minim.ugens.FilePlayer;
import ddf.minim.ugens.TickRate;
import java.io.File;
import processing.core.PApplet;
import processing.core.PImage;

public class luna
extends PApplet {
    Minim minim;
    FilePlayer fPlayer;
    AudioOutput out;
    AudioMetaData meta;
    TickRate rateControl;
    FFT fft;
    String sPathCurrent = "/";
    int iFilesNumber = 0;
    File[] fCurrentFilelist = new File[1024];
    int iFileSelected = 0;
    int iFilePlaying = 0;
    int iFontSize = 9;
    int iWindowSizeX = 196;
    int iWindowSizeY = 293;
    int iFileListSizeX = 200;
    int iFileListSizeY = 20 * this.iFontSize + 2;
    int iFileListOffsetX = 5;
    int iFileListOffsetY = 100;
    int iFilesInFileList = 20;
    int cGreenBright = this.color(0, 160, 0);
    int cGreenDark = this.color(0, 120, 0);
    boolean bPlayback = false;
    boolean bPlaybackPaused = false;
    String sPlayback = "";
    String sPlaybackShort = "";
    int iTicksLastTime = 0;
    float fPosX = this.iFileListOffsetX;
    int iSpeedXInitial;
    int iSpeedX = this.iSpeedXInitial = -25;
    int iBottomEQ = 58;
    int iMoveTicks = 10000;
    boolean bAutoplay = true;
    int iRatePlayback = 75;
    Fonty fonty = new Fonty();

    public void setup() {
        luna.println((String)"Luna Slow Sonic Music Club MP3 Player by dace.de 2022");
        this.background(20);
        this.minim = new Minim((Object)this);
        this.fft = new FFT(1024, 320.0f);
        this.rateControl = new TickRate((float)this.iRatePlayback * 0.01f);
        this.rateControl.setInterpolation(true);
        String[] lines = this.loadStrings("lastfolder.dat");
        if (lines == null) {
            String[] editableStringArray = new String[]{this.sPathCurrent};
            this.saveStrings("lastfolder.dat", editableStringArray);
            lines = this.loadStrings("lastfolder.dat");
        }
        this.sPathCurrent = lines[0];
        File g = new File(this.sPathCurrent);
        if (!g.exists()) {
            this.sPathCurrent = "/";
        }
        this.fCurrentFilelist = this.fFilelistMake();
        this.fonty.vInit();
        this.background(0);
        this.noStroke();
        this.fill(0);
        this.rect(0.0f, 0.0f, this.width, this.iFileListOffsetY - 1);
        this.fill(0.0f, 40.0f, 0.0f);
        this.image(this.loadImage("luna.png"), (float)this.width * 0.5f - 180.0f, -40.0f);
        this.fill(0.0f, 60.0f, 0.0f);
        this.fonty.output("dace.de 2022", this.iFileListOffsetX, 98);
        this.vRedraw();
    }

    public File[] fFilelistMake() {
        File fFolder = new File(this.sPathCurrent);
        File[] fFolderList = fFolder.listFiles();
        int iAllFilesNumber = fFolderList.length;
        int iNumberFolders = 0;
        int i = 0;
        while (i < iAllFilesNumber) {
            if (fFolderList[i].isDirectory()) {
                ++iNumberFolders;
            }
            ++i;
        }
        int iNumberMP3 = 0;
        int i2 = 0;
        while (i2 < iAllFilesNumber) {
            if (fFolderList[i2].isFile() && fFolderList[i2].getName().endsWith(".mp3")) {
                ++iNumberMP3;
            }
            ++i2;
        }
        this.iFilesNumber = 1 + iNumberFolders + iNumberMP3;
        File[] fFolderListCombined = new File[this.iFilesNumber];
        fFolderListCombined[0] = fFolder;
        int iIndexToFill = 1;
        int i3 = 0;
        while (i3 < iAllFilesNumber) {
            if (fFolderList[i3].isDirectory()) {
                fFolderListCombined[iIndexToFill] = fFolderList[i3];
                ++iIndexToFill;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < iAllFilesNumber) {
            if (fFolderList[i3].isFile() && fFolderList[i3].getName().endsWith(".mp3")) {
                fFolderListCombined[iIndexToFill] = fFolderList[i3];
                ++iIndexToFill;
            }
            ++i3;
        }
        this.surface.setTitle("Luna - " + fFolder.getName());
        return fFolderListCombined;
    }

    public void vFolderFileAction() {
        File fFolder = new File(this.sPathCurrent);
        if (this.iFileSelected == 0) {
            if (fFolder.getParent() == null) {
                return;
            }
            this.sPathCurrent = fFolder.getParent();
            this.fCurrentFilelist = this.fFilelistMake();
            this.iFilesNumber = this.fCurrentFilelist.length;
        } else {
            File fFile = this.fCurrentFilelist[this.iFileSelected];
            if (fFile.isDirectory()) {
                this.sPathCurrent = this.fCurrentFilelist[this.iFileSelected].getPath();
                this.iFileSelected = 0;
                this.fCurrentFilelist = this.fFilelistMake();
                this.iFilesNumber = this.fCurrentFilelist.length;
            } else if (this.bPlayback) {
                if (this.fCurrentFilelist[this.iFileSelected].getPath().equals(this.sPlayback)) {
                    this.fPlayer.pause();
                    this.bPlayback = !this.bPlayback;
                    this.bPlaybackPaused = true;
                } else {
                    this.fPlayer.pause();
                    this.vPlaySong(this.iFileSelected);
                }
            } else if (this.fCurrentFilelist[this.iFileSelected].getPath().equals(this.sPlayback)) {
                if (!this.fPlayer.isPlaying()) {
                    this.fPlayer.rewind();
                    this.fPlayer.play();
                } else {
                    this.fPlayer.play();
                }
                this.bPlayback = !this.bPlayback;
                this.bPlaybackPaused = false;
            } else {
                this.vPlaySong(this.iFileSelected);
                this.bPlayback = !this.bPlayback;
            }
        }
    }

    public void vPlaySong(int n) {
        this.sPlayback = this.fCurrentFilelist[n].getPath();
        if (this.fPlayer != null) {
            this.fPlayer.unpatch(this.out);
            this.fPlayer.unpatch((UGen)this.rateControl);
            this.fPlayer.close();
        }
        this.fPlayer = new FilePlayer(this.minim.loadFileStream(this.sPlayback));
        this.rateControl = new TickRate(1.0f);
        this.rateControl.value.setLastValue((float)this.iRatePlayback * 0.01f);
        this.rateControl.setInterpolation(true);
        this.out = this.minim.getLineOut();
        this.fPlayer.patch((UGen)this.rateControl).patch(this.out);
        this.fPlayer.play();
        this.meta = this.fPlayer.getMetaData();
        this.sPlaybackShort = this.fCurrentFilelist[n].getName();
        this.fPosX = this.iFileListOffsetX;
        this.iSpeedX = this.iSpeedXInitial;
        this.bPlaybackPaused = false;
        this.iFilePlaying = n;
        this.iTicksLastTime = this.millis();
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 38) {
                --this.iFileSelected;
                if (this.iFileSelected < 0) {
                    this.iFileSelected = this.iFilesNumber - 1;
                }
            }
            if (this.keyCode == 40) {
                ++this.iFileSelected;
                if (this.iFileSelected >= this.iFilesNumber) {
                    this.iFileSelected = 0;
                }
            }
            if (this.keyCode == 37) {
                this.fPlayer.cue(this.fPlayer.position() - this.iMoveTicks);
            }
            if (this.keyCode == 39) {
                this.fPlayer.cue(this.fPlayer.position() + this.iMoveTicks);
            }
        } else if (this.key == '\r' || this.key == '\n' || this.key == ' ') {
            this.vFolderFileAction();
        } else if (this.key == 'a' || this.keyCode == 65) {
            this.bAutoplay = !this.bAutoplay;
        } else if (this.key == '=') {
            this.iRatePlayback = 100;
            this.rateControl.value.setLastValue((float)this.iRatePlayback * 0.01f);
        } else if (this.key == '-') {
            this.iRatePlayback -= 5;
            if (this.iRatePlayback < 5) {
                this.iRatePlayback = 5;
            } else {
                this.rateControl.value.setLastValue((float)this.iRatePlayback * 0.01f);
            }
        } else if (this.key == '+') {
            this.iRatePlayback += 5;
            if (this.iRatePlayback > 1000) {
                this.iRatePlayback = 1000;
            } else {
                this.rateControl.value.setLastValue((float)this.iRatePlayback * 0.01f);
            }
        }
        this.vRedraw();
    }

    public void vDrawEQ() {
        this.noStroke();
        this.fill(0);
        this.rect(0.0f, 0.0f, this.width, this.iFileListOffsetY - 1);
        this.fill(this.cGreenDark);
        this.fft.forward(this.out.mix);
        int iWidthBar = 28;
        this.fill(0.0f, 80.0f, 0.0f);
        int j = 2;
        while (j < this.iBottomEQ) {
            int i = 0;
            while (i < this.width - 10) {
                this.rect(6 + i, j, iWidthBar - 12, 6.0f);
                i += iWidthBar;
            }
            j += 10;
        }
        this.fill(this.cGreenBright);
        int i = 0;
        while (i < this.width - 10) {
            int iBarHeight = PApplet.parseInt((float)(this.fft.getBand(PApplet.parseInt((float)((float)i * 0.5f))) * 0.5f));
            this.rect(6 + i, this.iBottomEQ - iBarHeight * 10, iWidthBar - 12, iBarHeight * 10);
            i += iWidthBar;
        }
        this.fill(0);
        j = -2;
        while (j < this.iBottomEQ) {
            this.rect(0.0f, j, this.width, 4.0f);
            j += 10;
        }
        this.stroke(this.cGreenDark);
        this.fill(0);
        this.rect(0.0f, this.iFileListOffsetY - 8 - this.iFontSize * 2 - this.iFontSize - 5, this.width - 1, this.iFontSize);
        float posx = luna.map((float)this.fPlayer.position(), (float)0.0f, (float)this.fPlayer.length(), (float)0.0f, (float)this.width);
        this.stroke(this.cGreenDark);
        this.fill(this.cGreenDark);
        this.rect(0.0f, this.iFileListOffsetY - 8 - this.iFontSize * 2 - this.iFontSize - 5, posx, this.iFontSize);
        this.fonty.alignCenter();
        if ((float)this.fPlayer.position() > (float)this.fPlayer.length() * 0.5f) {
            this.fill(0);
        }
        this.fonty.output(String.valueOf(PApplet.parseInt((float)((float)this.fPlayer.position() * 0.001f))) + "/" + PApplet.parseInt((float)((float)this.fPlayer.length() * 0.001f)) + " s", (float)this.width * 0.5f, (float)(this.iFileListOffsetY - 8 - this.iFontSize * 2 - 6));
        this.fonty.alignLeft();
    }

    public void vRedraw() {
        this.fill(0);
        this.stroke(this.cGreenDark);
        this.rect(0.0f, this.iFileListOffsetY, this.iWindowSizeX - 1, this.iFileListSizeY);
        int iPages = this.iFilesNumber / this.iFilesInFileList;
        int iPageCurrent = this.iFileSelected / this.iFilesInFileList;
        int iPageStart = iPageCurrent * this.iFilesInFileList;
        int iLastFilename = this.iFilesNumber;
        if (iPageStart + this.iFilesInFileList < this.iFilesNumber) {
            iLastFilename = iPageStart + this.iFilesInFileList;
        }
        int iPageOffsetCompensation = this.iFontSize * iPageCurrent * this.iFilesInFileList;
        this.noStroke();
        int i = iPageStart;
        while (i < iLastFilename) {
            File someFile = this.fCurrentFilelist[i];
            if (someFile.isFile()) {
                this.fill(this.cGreenBright);
            } else {
                this.fill(this.cGreenDark);
            }
            if (i == this.iFileSelected) {
                this.stroke(this.cGreenDark);
                this.fill(this.cGreenDark);
                this.rect(0.0f, this.iFontSize * i + this.iFileListOffsetY + 1 - iPageOffsetCompensation, this.iWindowSizeX, this.iFontSize);
                this.noStroke();
                this.fill(0);
                if (!someFile.isFile()) {
                    this.fill(this.cGreenBright);
                }
            }
            if (i != 0) {
                this.fonty.output(someFile.getName(), this.iFileListOffsetX, this.iFileListOffsetY + this.iFontSize * (i + 1) - iPageOffsetCompensation);
            } else {
                this.fonty.output("..", this.iFileListOffsetX, this.iFileListOffsetY + this.iFontSize * (i + 1) - iPageOffsetCompensation);
            }
            ++i;
        }
        this.stroke(this.cGreenDark);
        this.fill(0);
        this.rect(this.iWindowSizeX - 6, this.iFileListOffsetY, 6.0f, this.iFileListSizeY);
        int iScrollbarSizeY = this.iFileListSizeY / (iPages + 1);
        this.fill(this.cGreenDark);
        this.rect(this.iWindowSizeX - 6, this.iFileListOffsetY + iScrollbarSizeY * iPageCurrent, 6.0f, iScrollbarSizeY);
        this.noStroke();
        this.fill(0.0f, 40.0f, 0.0f);
        this.rect(0.0f, this.height - 10, this.width, 10.0f);
        this.fill(0);
        this.fonty.output("[ ]utoplay", this.iFileListOffsetX, this.height - 2);
        if (this.bAutoplay) {
            this.fill(this.cGreenDark);
        }
        this.fonty.output(" A", this.iFileListOffsetX, this.height - 2);
        this.fill(0);
        this.fonty.output("           [ / / ] Rate " + this.iRatePlayback, this.iFileListOffsetX, this.height - 2);
        this.fill(this.cGreenDark);
        this.fonty.output("            - + =", this.iFileListOffsetX, this.height - 2);
    }

    public void vDrawTitle() {
        int iOverhang;
        this.fill(0);
        this.rect(0.0f, this.iFileListOffsetY - this.iFontSize * 2 - 5, this.width, this.iFontSize * 2 + 1);
        this.fill(this.cGreenBright);
        this.fonty.height(this.iFontSize * 2);
        String sTitleLong = this.sPlaybackShort;
        if (!this.meta.author().equals("")) {
            sTitleLong = String.valueOf(sTitleLong) + "..." + this.meta.author();
        }
        if (!this.meta.title().equals("")) {
            sTitleLong = String.valueOf(sTitleLong) + ": " + this.meta.title();
        }
        if (!this.meta.album().equals("")) {
            sTitleLong = String.valueOf(sTitleLong) + ", from " + this.meta.album();
        }
        if (!this.meta.date().equals("")) {
            sTitleLong = String.valueOf(sTitleLong) + " (" + this.meta.date() + ")";
        }
        if ((iOverhang = sTitleLong.length() * 12 - this.width) > 0) {
            int iTicksDelta = this.millis() - this.iTicksLastTime;
            if (!this.bPlaybackPaused) {
                this.fPosX += (float)(this.iSpeedX * iTicksDelta) * 0.001f;
            }
            if (this.fPosX < (float)(-iOverhang)) {
                this.iSpeedX *= -1;
                this.fPosX = -iOverhang;
            } else if (this.fPosX >= (float)this.iFileListOffsetX) {
                this.iSpeedX *= -1;
                this.fPosX = this.iFileListOffsetX;
            }
            this.fonty.output(sTitleLong, this.fPosX, (float)(this.iFileListOffsetY - 8));
            this.iTicksLastTime += iTicksDelta;
        } else {
            this.fonty.output(sTitleLong, this.iFileListOffsetX, this.iFileListOffsetY - 8);
        }
        this.fonty.height(this.iFontSize);
    }

    public void draw() {
        if (this.bPlayback) {
            if (!this.fPlayer.isPlaying()) {
                if (!this.bAutoplay) {
                    this.bPlaybackPaused = false;
                    this.bPlayback = false;
                    return;
                }
                int iNumberMP3 = 0;
                int i = 0;
                while (i < this.iFilesNumber) {
                    if (this.fCurrentFilelist[i].isFile() && this.fCurrentFilelist[i].getName().endsWith(".mp3")) {
                        ++iNumberMP3;
                    }
                    ++i;
                }
                int iSongNext = 0;
                int iSafety = 100;
                if (iNumberMP3 == 0) {
                    iSafety = 0;
                }
                do {
                    if (iSafety-- == 0) {
                        this.bPlaybackPaused = false;
                        this.bPlayback = false;
                        return;
                    }
                    iSongNext = PApplet.parseInt((float)this.random(this.iFilesNumber));
                    if (iSongNext != this.iFilePlaying || iNumberMP3 <= 1) continue;
                    iSongNext = 0;
                } while (!this.fCurrentFilelist[iSongNext].isFile() && !this.fCurrentFilelist[iSongNext].getName().endsWith(".mp3"));
                this.iFileSelected = iSongNext;
                this.vPlaySong(this.iFileSelected);
            }
            this.vRedraw();
            this.vDrawEQ();
            this.vDrawTitle();
        } else if (this.bPlaybackPaused) {
            this.vDrawEQ();
            this.vDrawTitle();
        }
    }

    public void exit() {
        String[] editableStringArray = new String[]{this.sPathCurrent};
        this.saveStrings("lastfolder.dat", editableStringArray);
        if (this.fPlayer != null) {
            this.fPlayer.unpatch(this.out);
            this.fPlayer.unpatch((UGen)this.rateControl);
            this.fPlayer.close();
        }
        System.exit(0);
    }

    public void settings() {
        this.size(196, 293);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"luna"};
        if (passedArgs != null) {
            PApplet.main((String[])luna.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Fonty {
        int iDotColumns = 6;
        int iDotRows = 9;
        int iBaseline;
        int iBaselineCurrent = this.iBaseline = -2;
        int iWidth = this.iDotColumns;
        int iHeight = this.iDotRows;
        int iLettersNumber = 128;
        Letter[] letters = new Letter[this.iLettersNumber];
        byte bAlign = 0;
        int iDotsNumber = this.iDotColumns * this.iDotRows;
        int iGap = 0;
        float fGap = 0.05f;

        Fonty() {
        }

        public void vInit() {
            int i = 0;
            while (i < this.letters.length) {
                this.letters[i] = new Letter(i, this.iDotColumns, this.iDotRows);
                ++i;
            }
        }

        public void vSetAlign(byte a) {
            this.bAlign = a;
        }

        public void vSetHeight(int h) {
            if (h < 1) {
                h = this.iDotRows;
            }
            this.iHeight = h;
            float fScale = PApplet.parseFloat((int)h) / (float)this.iDotRows;
            this.iWidth = PApplet.parseInt((float)((float)this.iDotColumns * fScale));
            this.iBaselineCurrent = PApplet.parseInt((float)((float)this.iBaseline * fScale));
        }

        public void vOutput(String s, int x, int y) {
            float fStrokeWeightCurrent = luna.this.getGraphics().strokeWeight;
            float fStrokeColourCurrent = luna.this.getGraphics().strokeColor;
            if (this.iHeight % this.iDotRows == 0) {
                luna.this.noStroke();
            } else {
                luna.this.stroke(luna.this.getGraphics().fillColor);
                luna.this.strokeWeight(1.0f);
            }
            float fScale = 1.0f;
            if (this.iHeight != this.iDotRows) {
                fScale = PApplet.parseFloat((int)this.iHeight) / (float)this.iDotRows;
            }
            if (this.bAlign != 0) {
                int iStringLengthPixels;
                if (this.bAlign == 1) {
                    iStringLengthPixels = s.length() * this.iDotColumns;
                    x = (int)((float)x - (float)iStringLengthPixels * fScale);
                } else {
                    iStringLengthPixels = s.length() * this.iDotColumns;
                    x = (int)((float)x - (float)iStringLengthPixels * 0.5f * fScale);
                }
            }
            int i = 0;
            while (i < s.length()) {
                char cDisplay = s.charAt(i);
                if (cDisplay >= ' ' && cDisplay < this.iLettersNumber) {
                    this.letters[cDisplay].vDisplay(x, y - this.iBaselineCurrent, this.iHeight, this.iDotColumns, this.iDotRows, fScale);
                }
                x += this.iWidth;
                ++i;
            }
            luna.this.strokeWeight(fStrokeWeightCurrent);
            luna.this.stroke(fStrokeColourCurrent);
        }

        public void alignLeft() {
            this.vSetAlign(PApplet.parseByte((int)0));
        }

        public void alignRight() {
            this.vSetAlign(PApplet.parseByte((int)1));
        }

        public void alignCenter() {
            this.vSetAlign(PApplet.parseByte((int)2));
        }

        public void height(int h) {
            this.vSetHeight(h);
        }

        public void output(String s, float x, float y) {
            this.vOutput(s, PApplet.parseInt((float)x), PApplet.parseInt((float)y));
        }

        public void output(String s, int x, int y) {
            this.vOutput(s, x, y);
        }
    }

    class Letter {
        int iId = -1;
        boolean[][] letterDots;

        Letter(int l, int iDotColumns, int iDotRows) {
            this.iId = l;
            this.letterDots = new boolean[iDotColumns][iDotRows];
            PImage sheet = luna.this.loadImage("font.png");
            PImage oneLetter = sheet.get(this.iId * iDotColumns, 0, iDotColumns, iDotRows);
            int j = 0;
            while (j < oneLetter.height) {
                int i = 0;
                while (i < oneLetter.width) {
                    this.letterDots[i][j] = oneLetter.get(i, j) != luna.this.color(0);
                    ++i;
                }
                ++j;
            }
        }

        public void vDisplay(int x, int y, int h, int iDotColumns, int iDotRows, float fScale) {
            if (h == iDotRows) {
                int j = 0;
                while (j < iDotRows) {
                    int i = 0;
                    while (i < iDotColumns) {
                        if (this.letterDots[i][j]) {
                            luna.this.rect(x + i, y + j - h, 1.0f, 1.0f);
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < iDotRows) {
                    int i = 0;
                    while (i < iDotColumns) {
                        if (this.letterDots[i][j]) {
                            luna.this.rect((float)x + (float)i * fScale, (float)y + (float)j * fScale - (float)h, fScale, fScale);
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
    }
}

