/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import com.jogamp.newt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAbstractControl;
import org.gamecontrolplus.gui.MConstants;
import org.gamecontrolplus.gui.MConstantsInternal;
import org.gamecontrolplus.gui.MMessenger;
import org.gamecontrolplus.gui.MWinData;
import org.gamecontrolplus.gui.MWindowAWT;
import org.gamecontrolplus.gui.MWindowNEWT;
import processing.core.PApplet;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public abstract class MWindow
extends PApplet
implements MConstants,
MConstantsInternal {
    protected int actionOnClose = 3843;
    public MWinData data;
    protected final int w;
    protected final int h;
    protected final String title;
    protected String renderer_type;
    public LinkedList<MAbstractControl> windowControls = new LinkedList();
    public LinkedList<MAbstractControl> toRemove = new LinkedList();
    public LinkedList<MAbstractControl> toAdd = new LinkedList();
    protected Object preHandlerObject = null;
    protected Method preHandlerMethod = null;
    protected String preHandlerMethodName;
    protected Object postHandlerObject = null;
    protected Method postHandlerMethod = null;
    protected String postHandlerMethodName;
    protected Object drawHandlerObject = null;
    protected Method drawHandlerMethod = null;
    protected String drawHandlerMethodName;
    protected Object keyHandlerObject = null;
    protected Method keyHandlerMethod = null;
    protected String keyHandlerMethodName;
    protected Object mouseHandlerObject = null;
    protected Method mouseHandlerMethod = null;
    protected String mouseHandlerMethodName;
    protected Object closeHandlerObject = null;
    protected Method closetHandlerMethod = null;
    protected String closetHandlerMethodName;
    protected boolean is3D;

    public static MWindow getWindow(PApplet pApplet, String string, int n, int n2, int n3, int n4, String string2) {
        M4P.registerSketch(pApplet);
        MWindow mWindow = null;
        if (string2.equals("processing.awt.PGraphicsJava2D")) {
            mWindow = new MWindowAWT(string, n3, n4);
        } else if (string2.equals("processing.opengl.PGraphics2D")) {
            mWindow = new MWindowNEWT(string, n3, n4, false);
        } else if (string2.equals("processing.opengl.PGraphics3D")) {
            mWindow = new MWindowNEWT(string, n3, n4, true);
        }
        if (mWindow != null) {
            String string3 = "--sketch-path=" + M4P.sketchWindow.sketchPath();
            String string4 = "--location=" + n + "," + n2;
            String string5 = mWindow.getClass().getName();
            String[] stringArray = new String[]{string3, string4, string5};
            M4P.registerWindow(mWindow);
            PApplet.runSketch((String[])stringArray, (PApplet)mWindow);
        }
        return mWindow;
    }

    protected MWindow(String string, int n, int n2) {
        this.title = string;
        this.w = n;
        this.h = n2;
        this.registerMethods();
    }

    protected void registerMethods() {
        this.registerMethod("pre", this);
        this.registerMethod("draw", this);
        this.registerMethod("post", this);
        this.registerMethod("mouseEvent", this);
        this.registerMethod("keyEvent", this);
    }

    protected void unregisterMethods() {
        this.unregisterMethod("pre", this);
        this.unregisterMethod("draw", this);
        this.unregisterMethod("post", this);
        this.unregisterMethod("mouseEvent", this);
        this.unregisterMethod("keyEvent", this);
    }

    public void addData(MWinData mWinData) {
        this.data = mWinData;
    }

    protected void addToWindow(MAbstractControl mAbstractControl) {
        if (!this.toAdd.contains(mAbstractControl) && !this.windowControls.contains(mAbstractControl)) {
            this.toAdd.add(mAbstractControl);
        }
    }

    protected void removeFromWindow(MAbstractControl mAbstractControl) {
        this.toRemove.add(mAbstractControl);
    }

    void setColorScheme(int n) {
        for (MAbstractControl mAbstractControl : this.windowControls) {
            mAbstractControl.setLocalColorScheme(n);
        }
    }

    void setAlpha(int n) {
        for (MAbstractControl mAbstractControl : this.windowControls) {
            mAbstractControl.setAlpha(n);
        }
    }

    public void draw() {
        this.pushMatrix();
        if (this.drawHandlerObject != null) {
            try {
                this.drawHandlerMethod.invoke(this.drawHandlerObject, this, this.data);
            }
            catch (Exception exception) {
                MMessenger.message(-2130706429, new Object[]{this.drawHandlerObject, this.drawHandlerMethodName, exception});
            }
        }
        this.popMatrix();
    }

    public void pre() {
        if (this.preHandlerObject != null) {
            try {
                this.preHandlerMethod.invoke(this.preHandlerObject, this, this.data);
            }
            catch (Exception exception) {
                MMessenger.message(-2130706429, new Object[]{this.preHandlerObject, this.preHandlerMethodName, exception});
            }
        }
        if (MAbstractControl.controlToTakeFocus != null && MAbstractControl.controlToTakeFocus.getPApplet() == this) {
            MAbstractControl.controlToTakeFocus.setFocus(true);
            MAbstractControl.controlToTakeFocus = null;
        }
        for (MAbstractControl mAbstractControl : this.windowControls) {
            if ((mAbstractControl.registeredMethods & 4) != 4) continue;
            mAbstractControl.pre();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() {
        if (this.postHandlerObject != null) {
            try {
                this.postHandlerMethod.invoke(this.postHandlerObject, this, this.data);
            }
            catch (Exception exception) {
                MMessenger.message(-2130706429, new Object[]{this.postHandlerObject, this.postHandlerMethodName, exception});
            }
        }
        if (M4P.cursorChangeEnabled) {
            if (MAbstractControl.cursorIsOver != null && MAbstractControl.cursorIsOver.getPApplet() == this) {
                this.cursor(MAbstractControl.cursorIsOver.cursorOver);
            } else {
                this.cursor(M4P.mouseOff);
            }
        }
        for (MAbstractControl iterator : this.windowControls) {
            if ((iterator.registeredMethods & 0x10) != 16) continue;
            iterator.post();
        }
        MWindow mWindow = this;
        synchronized (mWindow) {
            if (!this.toRemove.isEmpty()) {
                for (MAbstractControl mAbstractControl : this.toRemove) {
                    if (MAbstractControl.focusIsWith == mAbstractControl) {
                        mAbstractControl.loseFocus(null);
                    }
                    mAbstractControl.buffer = null;
                    if (mAbstractControl.parent != null) {
                        mAbstractControl.parent.children.remove(mAbstractControl);
                        mAbstractControl.parent = null;
                    }
                    if (mAbstractControl.children != null) {
                        mAbstractControl.children.clear();
                    }
                    mAbstractControl.palette = null;
                    mAbstractControl.jpalette = null;
                    mAbstractControl.eventHandlerObject = null;
                    mAbstractControl.eventHandlerMethod = null;
                    mAbstractControl.winApp = null;
                    this.windowControls.remove(mAbstractControl);
                    System.gc();
                }
                this.toRemove.clear();
            }
            if (!this.toAdd.isEmpty()) {
                for (MAbstractControl mAbstractControl : this.toAdd) {
                    this.windowControls.add(mAbstractControl);
                }
                this.toAdd.clear();
                Collections.sort(this.windowControls, M4P.zorder);
            }
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (this.mouseHandlerObject != null) {
            try {
                this.mouseHandlerMethod.invoke(this.mouseHandlerObject, this, this.data, mouseEvent);
            }
            catch (Exception exception) {
                MMessenger.message(-2130706429, new Object[]{this.mouseHandlerObject, this.mouseHandlerMethodName, exception});
            }
        }
        for (MAbstractControl mAbstractControl : this.windowControls) {
            if ((mAbstractControl.registeredMethods & 2) != 2) continue;
            mAbstractControl.mouseEvent(mouseEvent);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (this.keyHandlerObject != null) {
            try {
                this.keyHandlerMethod.invoke(this.keyHandlerObject, this, this.data, keyEvent);
            }
            catch (Exception exception) {
                MMessenger.message(-2130706429, new Object[]{this.keyHandlerObject, this.keyHandlerMethodName, exception});
            }
        }
        for (MAbstractControl mAbstractControl : this.windowControls) {
            if ((mAbstractControl.registeredMethods & 8) != 8) continue;
            mAbstractControl.keyEvent(keyEvent);
        }
    }

    public void addDrawHandler(Object object, String string) {
        try {
            this.drawHandlerMethod = object.getClass().getMethod(string, PApplet.class, MWinData.class);
            this.drawHandlerObject = object;
            this.drawHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.drawHandlerObject = null;
            MMessenger.message(0x1000002, new Object[]{this, string, new Class[]{PApplet.class, MWinData.class}});
        }
    }

    public void addPreHandler(Object object, String string) {
        try {
            this.preHandlerMethod = object.getClass().getMethod(string, PApplet.class, MWinData.class);
            this.preHandlerObject = object;
            this.preHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.preHandlerMethod = null;
            MMessenger.message(0x1000002, new Object[]{this, string, new Class[]{PApplet.class, MWinData.class}});
        }
    }

    public void addMouseHandler(Object object, String string) {
        try {
            this.mouseHandlerMethod = object.getClass().getMethod(string, PApplet.class, MWinData.class, MouseEvent.class);
            this.mouseHandlerObject = object;
            this.mouseHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.mouseHandlerObject = null;
            MMessenger.message(0x1000002, new Object[]{this, string, new Class[]{PApplet.class, MWinData.class, MouseEvent.class}});
        }
    }

    public void addKeyHandler(Object object, String string) {
        try {
            this.keyHandlerMethod = object.getClass().getMethod(string, PApplet.class, MWinData.class, KeyEvent.class);
            this.keyHandlerObject = object;
            this.keyHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.keyHandlerObject = null;
            MMessenger.message(0x1000002, new Object[]{this, string, new Class[]{PApplet.class, MWinData.class, KeyEvent.class}});
        }
    }

    public void addPostHandler(Object object, String string) {
        try {
            this.postHandlerMethod = object.getClass().getMethod(string, PApplet.class, MWinData.class);
            this.postHandlerObject = object;
            this.postHandlerMethodName = string;
        }
        catch (Exception exception) {
            this.postHandlerObject = null;
            MMessenger.message(0x1000002, new Object[]{this, string, new Class[]{PApplet.class, MWinData.class}});
        }
    }

    public void addOnCloseHandler(Object object, String string) {
        try {
            this.closeHandlerObject = object;
            this.closetHandlerMethodName = string;
            this.closetHandlerMethod = object.getClass().getMethod(string, PApplet.class, MWinData.class);
        }
        catch (Exception exception) {
            MMessenger.message(0x1000002, new Object[]{this, string, new Class[]{MWindow.class}});
            this.closeHandlerObject = null;
            this.closetHandlerMethodName = "";
        }
    }

    public abstract void close();

    public abstract void forceClose();

    public abstract void setActionOnClose(int var1);

    public void settings() {
        this.size(this.w, this.h, this.renderer_type);
    }

    protected abstract void initListeners();

    public void setup() {
        this.surface.setTitle(this.title);
        this.initListeners();
    }

    public void performCloseAction() {
        if (this.closeHandlerObject != null) {
            try {
                this.closetHandlerMethod.invoke(this.closeHandlerObject, this, this.data);
            }
            catch (Exception exception) {
                MMessenger.message(-2130706429, new Object[]{this.preHandlerObject, this.preHandlerMethodName, exception});
            }
        }
    }

    protected class WindowAdapterNEWT
    extends WindowAdapter {
        MWindow window = null;

        public WindowAdapterNEWT(MWindow mWindow2) {
            this.window = mWindow2;
        }

        public void windowGainedFocus(com.jogamp.newt.event.WindowEvent windowEvent) {
            MWindow.this.focused = true;
            MWindow.this.focusGained();
        }

        public void windowLostFocus(com.jogamp.newt.event.WindowEvent windowEvent) {
            MWindow.this.focused = false;
            MWindow.this.focusLost();
        }

        public void windowDestroyNotify(com.jogamp.newt.event.WindowEvent windowEvent) {
            switch (MWindow.this.actionOnClose) {
                case 3841: {
                    MWindow.this.noLoop();
                    MWindow.this.unregisterMethods();
                    MWindow.this.dispose();
                    MWindow.this.exitActual();
                    break;
                }
                case 3842: {
                    MWindow.this.noLoop();
                    MWindow.this.unregisterMethods();
                    MWindow.this.performCloseAction();
                    MWindow.this.dispose();
                    M4P.deregisterWindow(this.window);
                }
            }
        }
    }

    protected class WindowAdapterAWT
    extends java.awt.event.WindowAdapter {
        MWindow window = null;

        public WindowAdapterAWT(MWindow mWindow2) {
            this.window = mWindow2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            switch (MWindow.this.actionOnClose) {
                case 3841: {
                    System.exit(0);
                    break;
                }
                case 3842: {
                    MWindow.this.noLoop();
                    MWindow.this.unregisterMethods();
                    MWindow.this.performCloseAction();
                    MWindow.this.dispose();
                    M4P.deregisterWindow(this.window);
                }
            }
        }
    }
}

