/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import org.gamecontrolplus.gui.MAlign;
import org.gamecontrolplus.gui.MImageManager;
import org.gamecontrolplus.gui.MStyledString;
import org.gamecontrolplus.gui.MTextAlign;
import processing.core.PApplet;
import processing.core.PImage;

public abstract class MTextIconAlignBase
extends MTextAlign {
    protected PImage[] bicon = null;
    protected int iconW = 0;
    protected int iconH = 0;
    protected MAlign iconAlignH = MAlign.RIGHT;
    protected MAlign iconAlignV = MAlign.MIDDLE;
    protected int siX;
    protected int siY;

    public MTextIconAlignBase(PApplet pApplet, float f, float f2, float f3, float f4) {
        super(pApplet, f, f2, f3, f4);
    }

    @Override
    public void setText(String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this.stext = this.iconW == 0 ? new MStyledString(string, (int)this.width - 4) : new MStyledString(string, (int)this.width - this.iconW - 8);
        this.bufferInvalid = true;
    }

    public void setIcon(String string, int n, MAlign mAlign, MAlign mAlign2) {
        PImage pImage = MImageManager.loadImage(this.winApp, string);
        this.setIcon(pImage, n, mAlign, mAlign2);
    }

    public void setIcon(PImage pImage, int n, MAlign mAlign, MAlign mAlign2) {
        if (pImage != null) {
            if (n == 3) {
                this.bicon = MImageManager.makeTiles1D(this.winApp, pImage, n, 1);
            } else {
                this.bicon = new PImage[3];
                PImage[] pImageArray = MImageManager.makeTiles1D(this.winApp, pImage, n, 1);
                System.arraycopy(pImageArray, 0, this.bicon, 0, pImageArray.length);
                for (int i = pImageArray.length; i < 3; ++i) {
                    this.bicon[i] = this.bicon[i - 1];
                }
            }
            if (mAlign != null && mAlign.isHorzAlign() && mAlign != MAlign.CENTER) {
                this.iconAlignH = mAlign;
            }
            if (mAlign2 != null && mAlign2.isVertAlign()) {
                this.iconAlignV = mAlign2;
            }
            this.iconW = this.bicon[0].width;
            this.iconH = this.bicon[0].height;
            this.stext.setWrapWidth((int)this.width - this.iconW - 8);
            this.bufferInvalid = true;
        }
    }

    public void setIconAlign(MAlign mAlign, MAlign mAlign2) {
        if (this.iconW != 0) {
            if (mAlign != null && mAlign.isHorzAlign() && mAlign != MAlign.CENTER) {
                this.iconAlignH = mAlign;
            }
            if (mAlign2 != null && mAlign2 != null && mAlign2.isVertAlign()) {
                this.iconAlignV = mAlign2;
            }
            this.bufferInvalid = true;
        }
    }

    @Override
    protected void calcAlignment() {
        super.calcAlignment();
        if (this.iconW != 0) {
            switch (this.iconAlignH) {
                case LEFT: {
                    this.siX = 2;
                    if (this.textAlignH == MAlign.RIGHT) break;
                    this.stX += (float)(this.iconW + 4);
                    break;
                }
                default: {
                    this.siX = (int)this.width - this.iconW - 4;
                    if (this.textAlignH != MAlign.RIGHT) break;
                    this.stX -= (float)(this.iconW + 4);
                }
            }
            switch (this.iconAlignV) {
                case TOP: {
                    this.siY = 2;
                    break;
                }
                case BOTTOM: {
                    this.siY = (int)this.height - this.iconH - 4;
                    break;
                }
                default: {
                    this.siY = (int)(this.height - (float)this.iconH) / 2;
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.tag;
    }
}

