/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.gamecontrolplus.gui.MAbstractControl;
import org.gamecontrolplus.gui.MConstants;
import org.gamecontrolplus.gui.MFileChooserFilter;
import org.gamecontrolplus.gui.MFilenameChooserFilter;
import org.gamecontrolplus.gui.MWindow;
import org.gamecontrolplus.gui.MWindowImpl;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PConstants;

public class M4P
implements MConstants,
PConstants {
    static PApplet sketchWindow = null;
    static MWindowImpl sketchWindowImpl = null;
    static List<MWindow> allWindows = new LinkedList<MWindow>();
    static int globalColorScheme = 6;
    static int globalAlpha = 255;
    static Font globalFont = new Font("Dialog", 0, 12);
    static Font numericLabelFont = new Font("DialogInput", 1, 12);
    static MAbstractControl.Z_Order zorder = new MAbstractControl.Z_Order();
    static boolean cursorChangeEnabled = true;
    static int mouseOff = 0;
    static boolean showMessages = true;
    static LinkedList<G4Pstyle> styles = new LinkedList();
    static JColorChooser chooser = null;
    static Color lastColor = Color.white;
    private static String PANE_TEXT_STYLE_MACOS = "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" } p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head> <b>@@TITLE@@</b> <p>@@MESSAGE@@</p>";
    private static String PANE_TEXT_STYLE_OTHER = "<html> <head> <style type=\"text/css\">b { font: 12pt \"Lucida Grande\" } p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head> <b>@@MESSAGE@@ </b>";

    public static String getPrettyVersion() {
        return "1.2.2";
    }

    public static String getVersion() {
        return "8";
    }

    static void registerWindow(MWindow mWindow) {
        if (!allWindows.contains(mWindow)) {
            allWindows.add(mWindow);
        }
    }

    static void deregisterWindow(MWindow mWindow) {
        allWindows.remove(mWindow);
    }

    static void registerControl(MAbstractControl mAbstractControl) {
        PApplet pApplet = mAbstractControl.getPApplet();
        if (pApplet == sketchWindow) {
            sketchWindowImpl.addToWindow(mAbstractControl);
        } else if (pApplet instanceof MWindow) {
            ((MWindow)pApplet).addToWindow(mAbstractControl);
        }
    }

    public static void registerSketch(PApplet pApplet) {
        if (sketchWindow == null && pApplet != null) {
            sketchWindow = pApplet;
            sketchWindowImpl = new MWindowImpl(sketchWindow);
        }
    }

    public static void setGlobalColorScheme(int n) {
        if (globalColorScheme != (n = Math.abs(n) % 16)) {
            globalColorScheme = n;
            for (MWindow mWindow : allWindows) {
                mWindow.setColorScheme(globalColorScheme);
            }
            if (sketchWindowImpl != null) {
                sketchWindowImpl.setColorScheme(globalColorScheme);
            }
        }
    }

    public static void setWindowColorScheme(PApplet pApplet, int n) {
        n = Math.abs(n) % 16;
        if (pApplet == sketchWindow) {
            if (sketchWindowImpl != null) {
                sketchWindowImpl.setColorScheme(n);
            }
        } else if (pApplet instanceof MWindow) {
            ((MWindow)pApplet).setColorScheme(n);
        }
    }

    public static void setGlobalAlpha(int n) {
        if (globalAlpha != (n = Math.abs(n) % 256)) {
            globalAlpha = n;
            for (MWindow mWindow : allWindows) {
                mWindow.setAlpha(globalAlpha);
            }
            if (sketchWindowImpl != null) {
                sketchWindowImpl.setAlpha(globalAlpha);
            }
        }
    }

    public static void setWindowAlpha(PApplet pApplet, int n) {
        n = Math.abs(n) % 256;
        if (pApplet == sketchWindow) {
            if (sketchWindowImpl != null) {
                sketchWindowImpl.setAlpha(n);
            }
        } else if (pApplet instanceof MWindow) {
            ((MWindow)pApplet).setAlpha(n);
        }
    }

    static boolean removeControl(MAbstractControl mAbstractControl) {
        PApplet pApplet = mAbstractControl.getPApplet();
        if (pApplet == sketchWindow) {
            if (sketchWindowImpl != null) {
                sketchWindowImpl.removeFromWindow(mAbstractControl);
                return true;
            }
            return false;
        }
        if (pApplet instanceof MWindow) {
            ((MWindow)pApplet).removeFromWindow(mAbstractControl);
            return true;
        }
        return false;
    }

    public static void messagesEnabled(boolean bl) {
        showMessages = bl;
    }

    public static void setMouseOverEnabled(boolean bl) {
        cursorChangeEnabled = bl;
    }

    @Deprecated
    public static void setCursorOff(int n) {
        mouseOff = n;
    }

    public static void setCursor(int n) {
        mouseOff = n;
        for (MWindow mWindow : allWindows) {
            mWindow.cursor(n);
        }
        if (sketchWindow != null) {
            sketchWindow.cursor(n);
        }
    }

    public static int getCursor() {
        return mouseOff;
    }

    @Deprecated
    public static int getCursorOff() {
        return mouseOff;
    }

    static void pushStyle() {
        G4Pstyle g4Pstyle = new G4Pstyle();
        g4Pstyle.showMessages = showMessages;
        styles.addLast(g4Pstyle);
    }

    static void popStyle() {
        G4Pstyle g4Pstyle = styles.removeLast();
        showMessages = g4Pstyle.showMessages;
    }

    public static ArrayList<MWindow> getOpenWindowsAsList(ArrayList<MWindow> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        } else {
            arrayList.clear();
        }
        for (MWindow mWindow : allWindows) {
            arrayList.add(mWindow);
        }
        return arrayList;
    }

    public static MWindow[] getOpenWindowsAsArray() {
        ArrayList<MWindow> arrayList = M4P.getOpenWindowsAsList(null);
        return arrayList.toArray(new MWindow[arrayList.size()]);
    }

    public static boolean isWindowOpen(MWindow mWindow) {
        return mWindow != null && allWindows.contains(mWindow);
    }

    public static String selectFolder(String string) {
        String string2 = null;
        Frame frame = M4P.getFrame(sketchWindow);
        if (PApplet.platform == 2 && PApplet.useNativeSelect) {
            FileDialog fileDialog = new FileDialog(frame, string, 0);
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String string3 = fileDialog.getFile();
            if (string3 != null) {
                try {
                    string2 = new File(fileDialog.getDirectory(), fileDialog.getFile()).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(frame);
            if (n == 0) {
                try {
                    string2 = jFileChooser.getSelectedFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        }
        return string2;
    }

    public static String selectInput(String string) {
        return M4P.selectInput(string, null, null);
    }

    public static String selectInput(String string, String string2, String string3) {
        return M4P.selectImpl(string, 0, string2, string3);
    }

    public static String selectOutput(String string) {
        return M4P.selectOutput(string, null, null);
    }

    public static String selectOutput(String string, String string2, String string3) {
        return M4P.selectImpl(string, 1, string2, string3);
    }

    private static String selectImpl(String string, int n, String string2, String string3) {
        String string4 = null;
        Frame frame = M4P.getFrame(sketchWindow);
        if (PApplet.useNativeSelect) {
            FileDialog fileDialog = new FileDialog(frame, string, n);
            MFilenameChooserFilter mFilenameChooserFilter = null;
            if (string2 != null && string2.length() > 0) {
                mFilenameChooserFilter = new MFilenameChooserFilter(string2);
                fileDialog.setFilenameFilter(mFilenameChooserFilter);
            }
            fileDialog.setVisible(true);
            String string5 = fileDialog.getDirectory();
            if (string5 != null && (string4 = fileDialog.getFile()) != null) {
                try {
                    string4 = new File(string5, string4).getCanonicalPath();
                }
                catch (IOException iOException) {
                    string4 = null;
                }
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(string);
            MFileChooserFilter mFileChooserFilter = null;
            if (string2 != null && string2.length() > 0) {
                mFileChooserFilter = new MFileChooserFilter(string2, string3);
                jFileChooser.setFileFilter(mFileChooserFilter);
            }
            int n2 = -1;
            if (n == 1) {
                n2 = jFileChooser.showSaveDialog(frame);
            } else if (n == 0) {
                n2 = jFileChooser.showOpenDialog(frame);
            }
            if (n2 == 0) {
                try {
                    string4 = jFileChooser.getSelectedFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    string4 = null;
                }
            }
        }
        return string4;
    }

    public static void showMessage(PApplet pApplet, String string, String string2, int n) {
        String string3;
        Frame frame = M4P.getFrame(pApplet);
        if (PApplet.platform == 2) {
            string3 = PANE_TEXT_STYLE_MACOS.replaceAll("@@TITLE@@", string2);
            string2 = "";
            string3 = string3.replaceAll("@@MESSAGE@@", string);
        } else {
            string3 = PANE_TEXT_STYLE_OTHER.replaceAll("@@MESSAGE@@", string);
        }
        JOptionPane.showMessageDialog(frame, string3, string2, n);
    }

    public static int selectOption(PApplet pApplet, String string, String string2, int n, int n2) {
        String string3;
        Frame frame = M4P.getFrame(pApplet);
        if (PApplet.platform == 2) {
            string3 = PANE_TEXT_STYLE_MACOS.replaceAll("@@TITLE@@", string2);
            string2 = "";
            string3 = string3.replaceAll("@@MESSAGE@@", string);
        } else {
            string3 = PANE_TEXT_STYLE_OTHER.replaceAll("@@MESSAGE@@", string);
        }
        return JOptionPane.showOptionDialog(frame, string3, string2, n2, n, null, null, null);
    }

    private static Frame getFrame(PApplet pApplet) {
        Frame frame = null;
        try {
            frame = ((PSurfaceAWT.SmoothCanvas)pApplet.getSurface().getNative()).getFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return frame;
    }

    static class G4Pstyle {
        boolean showMessages;

        G4Pstyle() {
        }
    }
}

