/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import org.gamecontrolplus.ControlInput;
import org.gamecontrolplus.Plug;
import processing.core.PApplet;

public class ControlButton
extends ControlInput {
    private boolean pressed = false;
    private boolean oldPressed = false;
    private final PApplet parent;
    protected final List<Plug> onPressPlugs = new ArrayList<Plug>();
    protected final List<Plug> onReleasePlugs = new ArrayList<Plug>();
    protected final List<Plug> whilePressPlugs = new ArrayList<Plug>();

    ControlButton(Component component, PApplet pApplet) {
        super(component);
        this.parent = pApplet;
        this.inputType = 1;
    }

    @Override
    void update() {
        this.actualValue = this.component.getPollData() * 8.0f;
        boolean bl = this.pressed = this.actualValue > 0.0f;
        if (this.pressed && this.oldPressed) {
            this.callPlugs(this.whilePressPlugs);
        } else if (this.pressed && !this.oldPressed) {
            this.callPlugs(this.onPressPlugs);
        } else if (!this.pressed && this.oldPressed) {
            this.callPlugs(this.onReleasePlugs);
        }
        this.oldPressed = this.pressed;
    }

    public boolean pressed() {
        return this.pressed;
    }

    public void plug(Object object, String string, int n) {
        List<Plug> list;
        Plug plug = new Plug(object, string);
        switch (n) {
            case 0: {
                list = this.onPressPlugs;
                break;
            }
            case 1: {
                list = this.onReleasePlugs;
                break;
            }
            case 2: {
                list = this.whilePressPlugs;
                break;
            }
            default: {
                throw new RuntimeException("Error on plug " + string + " check the given event type");
            }
        }
        list.add(plug);
    }

    public void plug(String string, int n) {
        this.plug(this.parent, string, n);
    }

    protected void callPlugs(List<Plug> list) {
        for (int i = 0; i < list.size(); ++i) {
            Plug plug = list.get(i);
            plug.call();
        }
    }

    public String toText(String string) {
        String string2 = this.actualName.length() > 20 ? this.actualName.substring(0, 17) + "..." : (this.actualName + "                    ").substring(0, 20);
        return string + "button    " + string2 + "-";
    }
}

