/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import ddf.minim.ugens.Sampler;
import java.util.ArrayList;
import org.gamecontrolplus.ControlDevice;
import org.gamecontrolplus.ControlIO;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class jozsefatomick
extends PApplet {
    int iScreenWidth = 320;
    int iScreenHeight = 256;
    int iScreenWidthHalf = PApplet.parseInt((float)((float)this.iScreenWidth * 0.5f));
    int iNumberTiles = 640;
    int iNumberEnemies = 20;
    int iNumberLevels = 13;
    int iNumberParticles = 256;
    int iNumberLeafs = 80;
    Sky sky = null;
    Clouds clouds = null;
    Level[] levels = new Level[this.iNumberLevels];
    Particle[] particles = new Particle[this.iNumberParticles];
    Leaf[] leafs = new Leaf[this.iNumberLeafs];
    int iLevelCurrent = 0;
    int inLevelCurrentSavedForHighscoreEntry = 0;
    int iTileSize = 32;
    int iTileSizeHalf = PApplet.parseInt((float)((float)this.iTileSize * 0.5f));
    screen sScreen = screen.TITLE;
    PImage pTitle = null;
    PImage pLogo = null;
    float fLevelIdlePosition = 0.0f;
    byte bLevelIdleDirection = (byte)-1;
    int iLevelIdleTicks = 0;
    float fGravityFactor = 0.06f;
    byte bGrace = (byte)3;
    int iPlayersNumber = 1;
    Player[] players = new Player[this.iPlayersNumber];
    int iPointsCollectable = 10;
    int iPointsEnemy = 2;
    String sPlayerSpritesheet = "surge_mod5.png";
    String sTilesheet = "tilesheet8_320x256_trans.png";
    String sTilesheetOverlay = "tilesheet_overlay_32x32_trans.png";
    Fonty fonty = new Fonty();
    ScreenMenu screenMenu = null;
    ScreenAbout screenAbout = null;
    ScreenHiscoreShow screenHiscoreShow = null;
    ScreenHiscoreEnter screenHiscoreEnter = null;
    int iTicksTimedEvent = 7000;
    float fTimedEventChance = 0.5f;
    int iResLowX = this.iScreenWidth;
    int iResLowY = this.iScreenHeight;
    float fFactor = 1.0f;
    int iOffsetX = 0;
    int iOffsetY = 0;
    PGraphics pBackground;
    int iTicksLast = 0;
    ControlIO control;
    ControlDevice joystick0 = null;
    ControlDevice joystick1 = null;
    boolean[] bJoystick0Controls = new boolean[5];
    boolean[] bJoystick1Controls = new boolean[5];
    int buttonNumber = 12;
    int[] joypadButtons;
    boolean gamepad;
    boolean but;
    Minim minim;
    AudioOutput out;
    Sampler[] samples;
    boolean bAudioIsOn;

    public jozsefatomick() {
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        this.joypadButtons = nArray;
        this.gamepad = false;
        this.but = false;
        this.bAudioIsOn = true;
    }

    public void setup() {
        this.noCursor();
        this.pBackground = this.createGraphics(this.iResLowX, this.iResLowY);
        jozsefatomick.println((String)("w " + this.width + " h " + this.height));
        jozsefatomick.println((String)("we want resolution " + this.iResLowX + "x" + this.iResLowY));
        float fFactorX = 1.0f;
        float fFactorY = 1.0f;
        fFactorX = (float)this.width / (float)this.iResLowX;
        fFactorY = (float)this.height / (float)this.iResLowY;
        jozsefatomick.println((String)("factor x " + fFactorX + " y " + fFactorY));
        if (fFactorX <= fFactorY) {
            fFactorY = fFactorX;
            this.iOffsetX = 0;
            this.iOffsetY = (int)(((float)this.height - (float)this.iResLowY * fFactorY) * 0.5f);
        } else {
            fFactorX = fFactorY;
            this.iOffsetX = (int)(((float)this.width - (float)this.iResLowX * fFactorX) * 0.5f);
            this.iOffsetY = 0;
        }
        this.fFactor = fFactorX;
        this.background(0);
        this.surface.setTitle("J\u00f3zsef Atomick");
        this.noStroke();
        this.sky = new Sky();
        this.clouds = new Clouds();
        this.screenMenu = new ScreenMenu();
        this.screenAbout = new ScreenAbout();
        this.screenHiscoreShow = new ScreenHiscoreShow();
        this.screenHiscoreEnter = new ScreenHiscoreEnter();
        int i = 0;
        while (i < this.levels.length) {
            this.levels[i] = new Level(i);
            ++i;
        }
        i = 0;
        while (i < this.levels.length) {
            this.levels[i].vInitTiles(i);
            ++i;
        }
        i = 0;
        while (i < this.iPlayersNumber) {
            this.players[i] = new Player(PApplet.parseByte((int)i));
            ++i;
        }
        this.players[0].vAssignKeys('w', 's', 'a', 'd', 'q');
        i = 0;
        while (i < this.particles.length) {
            this.particles[i] = new Particle(i);
            ++i;
        }
        i = 0;
        while (i < this.leafs.length) {
            this.leafs[i] = new Leaf(i);
            ++i;
        }
        this.pTitle = this.loadImage("title3_320x256_greens.png");
        this.pLogo = this.loadImage("logo4_160x98_trans.png");
        this.control = ControlIO.getInstance((PApplet)this);
        jozsefatomick.println((Object)this.control.getDevices());
        ArrayList jo = new ArrayList();
        jo = (ArrayList)this.control.getDevices();
        int loc = 0;
        int[] devicesPlayers = new int[]{-1, -1};
        int i2 = 0;
        while (i2 < jo.size()) {
            String name = ((ControlDevice)jo.get(i2)).toString();
            loc = name.indexOf("Xin-Mo");
            jozsefatomick.println((int)loc);
            if (loc != -1) {
                if (devicesPlayers[0] == -1) {
                    devicesPlayers[0] = i2;
                } else {
                    devicesPlayers[1] = i2;
                    break;
                }
            }
            ++i2;
        }
        if (devicesPlayers[0] == -1) {
            jozsefatomick.println((String)"No joysticks connected");
            this.gamepad = false;
        } else if (devicesPlayers[1] == -1) {
            jozsefatomick.println((String)("One joystick connected on position " + devicesPlayers[0]));
            this.gamepad = true;
            this.joystick0 = this.control.getDevice(devicesPlayers[0]);
        } else {
            jozsefatomick.println((String)("Two joysticks connected on position " + devicesPlayers[0] + " and " + devicesPlayers[1]));
            this.gamepad = true;
            this.joystick0 = this.control.getDevice(devicesPlayers[0]);
            this.joystick1 = this.control.getDevice(devicesPlayers[1]);
        }
        this.minim = new Minim((Object)this);
        this.out = this.minim.getLineOut();
        this.samples = new Sampler[23];
        int bVoices = 2;
        this.samples[0] = new Sampler("./audio/Retro Instrument - drumset - C12.wav", bVoices, this.minim);
        this.samples[1] = new Sampler("./audio/mixkit-explainer-video-game-alert-sweep-236.wav", bVoices, this.minim);
        this.samples[2] = new Sampler("./audio/Pop_1.wav", bVoices, this.minim);
        this.samples[3] = new Sampler("./audio/Button_13.wav", bVoices, this.minim);
        this.samples[4] = new Sampler("./audio/Hit_3.wav", bVoices, this.minim);
        this.samples[5] = new Sampler("./audio/Click_9.wav", bVoices, this.minim);
        this.samples[6] = new Sampler("./audio/Retro Impact Punch 07.wav", bVoices, this.minim);
        this.samples[7] = new Sampler("./audio/Retro Computer 02.wav", bVoices, this.minim);
        this.samples[8] = new Sampler("./audio/mixkit-winning-a-coin-video-game-2069.wav", bVoices, this.minim);
        this.samples[9] = new Sampler("./audio/mixkit-video-game-treasure-2066.wav", bVoices, this.minim);
        this.samples[10] = new Sampler("./audio/mixkit-extra-bonus-in-a-video-game-2045.wav", bVoices, this.minim);
        this.samples[11] = new Sampler("./audio/Retro PowerUP 09.wav", bVoices, this.minim);
        this.samples[12] = new Sampler("./audio/Retro Turn Off 12.wav", bVoices, this.minim);
        this.samples[13] = new Sampler("./audio/Retro Ambience 02.wav", bVoices, this.minim);
        this.samples[14] = new Sampler("./audio/mixkit-arcade-video-game-scoring-presentation-274.wav", bVoices, this.minim);
        this.samples[15] = new Sampler("./audio/Retro Ambience Short 09.wav", bVoices, this.minim);
        this.samples[16] = new Sampler("./audio/mixkit-game-level-completed-2059.wav", bVoices, this.minim);
        this.samples[17] = new Sampler("./audio/Click_4.wav", bVoices, this.minim);
        this.samples[18] = new Sampler("./audio/Button_4.wav", bVoices, this.minim);
        this.samples[19] = new Sampler("./audio/Retro Roar Krushed 01.wav", bVoices, this.minim);
        this.samples[20] = new Sampler("./audio/Retro Birds 07.wav", bVoices, this.minim);
        this.samples[21] = new Sampler("./audio/Retro Crow 01.wav", bVoices, this.minim);
        this.samples[22] = new Sampler("./audio/Retro Owl 01.wav", bVoices, this.minim);
        int i3 = 0;
        while (i3 < this.samples.length) {
            this.samples[i3].patch(this.out);
            ++i3;
        }
        this.samples[13].trigger();
        this.fonty.vInit();
    }

    public int iGetEnemiesKilledTotal() {
        int iValue = 0;
        int i = 1;
        while (i < this.iNumberLevels) {
            iValue += this.levels[i].iGetEnemiesKilled();
            ++i;
        }
        return iValue;
    }

    public int iGetRodsAllLevels(int iUpToLevel) {
        if (iUpToLevel == 0) {
            return 0;
        }
        int iValue = 0;
        int i = 1;
        while (i <= iUpToLevel) {
            iValue += this.levels[i].iGetRodsPerLevel();
            ++i;
        }
        return iValue;
    }

    public int iGetTicksLevelDurationFinalTotal() {
        int iValue = 0;
        int i = 1;
        while (i < this.iNumberLevels) {
            iValue += this.levels[i].iGetTicksLevelDurationFinal();
            ++i;
        }
        return iValue;
    }

    public String sPadWithBlanks(float n, int b) {
        n = PApplet.parseFloat((String)jozsefatomick.nf((float)n, (int)0, (int)1));
        int iLengthMissing = b - (("" + n).length() - 2);
        String sReturn = "";
        int i = 0;
        while (i < iLengthMissing) {
            sReturn = String.valueOf(sReturn) + " ";
            ++i;
        }
        return String.valueOf(sReturn) + n;
    }

    public String sPadWithBlanks(int n, int b) {
        int iLengthMissing = b - ("" + n).length();
        String sReturn = "";
        int i = 0;
        while (i < iLengthMissing) {
            sReturn = String.valueOf(sReturn) + " ";
            ++i;
        }
        return String.valueOf(sReturn) + n;
    }

    public void vAudioPlay(int s) {
        if (this.bAudioIsOn) {
            this.samples[s].trigger();
        }
    }

    public void vAudioStop() {
        int i = 0;
        while (i < this.samples.length) {
            ++i;
        }
    }

    public void vExplosion(int x, int y, int c) {
        int iNumberParticles = 8;
        int i = 0;
        while (i < this.particles.length) {
            if (!this.particles[i].bIsOn()) {
                this.particles[i].vInit(x, y, c);
                --iNumberParticles;
            }
            if (iNumberParticles == 0) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.particles.length) {
            this.particles[PApplet.parseInt((float)this.random(this.particles.length))].vInit(x, y, c);
            ++i;
        }
    }

    public void vGoToScreenAbout() {
        this.vAudioPlay(13);
        this.sScreen = screen.ABOUT;
    }

    public void vGoToScreenMenu() {
        this.vAudioStop();
        this.vAudioPlay(17);
        if (this.iLevelCurrent != 0) {
            this.iLevelCurrent = 0;
            this.fLevelIdlePosition = 0.0f;
            this.iLevelIdleTicks = this.millis();
        }
        this.sScreen = screen.MENU;
    }

    public void vGoToScreenGame() {
        this.vAudioPlay(13);
        ++this.iLevelCurrent;
        int i = 0;
        while (i < this.iPlayersNumber) {
            this.players[i].vResetForNextLevel();
            ++i;
        }
        this.levels[this.iLevelCurrent].vInitTiles(this.iLevelCurrent);
        this.levels[this.iLevelCurrent].vEnemiesReset();
        this.sScreen = screen.GAME;
    }

    public void vGoToScreenLevelTransition() {
        this.vAudioPlay(14);
        this.levels[this.iLevelCurrent].vTicksLevelDurationTrigger();
        this.sScreen = screen.LEVELTRANSITION;
        if (this.iLevelCurrent >= this.iNumberLevels - 1) {
            this.sScreen = screen.GAMEWON;
        }
    }

    public void vGoToScreenGameOver() {
        this.vAudioPlay(12);
        this.sScreen = screen.GAMEOVER;
    }

    public void vGoToScreenHiscoreShow() {
        this.vAudioPlay(15);
        this.screenHiscoreShow.vInit();
        int iScoreLowestHiscore = this.screenHiscoreShow.iGetScoreLowestHiscore();
        jozsefatomick.println((String)("iScoreLowestHiscore is " + iScoreLowestHiscore + ", players[0].iGetScore() is " + this.players[0].iGetScore()));
        float fScoreLowestTime = this.screenHiscoreShow.fGetScoreLowestTime();
        if (iScoreLowestHiscore < this.players[0].iGetScore() || iScoreLowestHiscore == this.players[0].iGetScore() && fScoreLowestTime < (float)this.iGetTicksLevelDurationFinalTotal() * 0.001f) {
            this.vGoToScreenHiscoreEnter();
            return;
        }
        this.sScreen = screen.HISCORESHOW;
    }

    public void vGoToScreenHiscoreEnter() {
        this.vAudioPlay(16);
        this.screenHiscoreEnter.vInit();
        this.sScreen = screen.HISCOREENTER;
    }

    public void vGoToScreenTransitionIn() {
        jozsefatomick.println((String)"vGoToScreenTransitionIn");
        int i = 0;
        while (i < this.leafs.length) {
            this.leafs[i].vInit(false);
            ++i;
        }
        this.sScreen = screen.TRANSITIONIN;
    }

    public void vGoToScreenTransitionOut() {
        jozsefatomick.println((String)"vGoToScreenTransitionOut");
        int i = 0;
        while (i < this.leafs.length) {
            this.leafs[i].vInit(true);
            ++i;
        }
        this.inLevelCurrentSavedForHighscoreEntry = this.iLevelCurrent;
        this.iLevelCurrent = 0;
        this.sScreen = screen.TRANSITIONOUT;
    }

    public void vLevelUp() {
        this.vGoToScreenLevelTransition();
    }

    public void vButtonPressed(char k) {
        if (this.sScreen == screen.TITLE) {
            if (k == ' ' || k == '\n' || k == '\r' || k == this.players[0].cGetKeyFire()) {
                this.vGoToScreenMenu();
            }
        } else if (this.sScreen == screen.MENU) {
            this.screenMenu.vKeyPressed(k);
        } else if (this.sScreen == screen.GAME) {
            int i = 0;
            while (i < this.iPlayersNumber) {
                this.players[i].vKeyIsPressed(k);
                ++i;
            }
        } else if (this.sScreen == screen.LEVELTRANSITION) {
            if (k == ' ' || k == '\n' || k == '\r' || k == this.players[0].cGetKeyFire()) {
                this.vGoToScreenGame();
            }
        } else if (this.sScreen == screen.GAMEOVER) {
            if (k == ' ' || k == '\n' || k == '\r' || k == this.players[0].cGetKeyFire()) {
                this.vGoToScreenTransitionIn();
            }
        } else if (this.sScreen == screen.GAMEWON) {
            if (k == ' ' || k == '\n' || k == '\r' || k == this.players[0].cGetKeyFire()) {
                this.vGoToScreenTransitionIn();
            }
        } else if (this.sScreen == screen.HISCORESHOW) {
            this.screenHiscoreShow.vKeyPressed(k);
        } else if (this.sScreen == screen.HISCOREENTER) {
            this.screenHiscoreEnter.vKeyPressed(k);
        } else if (this.sScreen == screen.ABOUT) {
            this.screenAbout.vKeyPressed(k);
        }
        if (k == '+') {
            ++this.iLevelCurrent;
            jozsefatomick.println((String)("level increased to " + this.iLevelCurrent));
            this.levels[this.iLevelCurrent].vInitTiles(this.iLevelCurrent);
            this.levels[this.iLevelCurrent].vEnemiesReset();
        } else if (k == '-') {
            --this.iLevelCurrent;
            jozsefatomick.println((String)("level idecreased to " + this.iLevelCurrent));
            this.levels[this.iLevelCurrent].vInitTiles(this.iLevelCurrent);
            this.levels[this.iLevelCurrent].vEnemiesReset();
        }
    }

    public void vButtonReleased(char k) {
        if (this.sScreen == screen.GAME) {
            int i = 0;
            while (i < this.iPlayersNumber) {
                this.players[i].vKeyIsReleased(k);
                ++i;
            }
        }
    }

    public void keyPressed() {
        this.vButtonPressed(this.key);
    }

    public void keyReleased() {
        this.vButtonReleased(this.key);
    }

    public void draw() {
        int iDistanceLeft;
        int i;
        if (this.sScreen == screen.TITLE) {
            this.pBackground.beginDraw();
            this.pBackground.image(this.pTitle, 0.0f, 0.0f);
            this.pBackground.stroke(0, 220.0f);
            i = 0;
            while (i < this.width) {
                this.pBackground.line(0.0f, (float)i, (float)this.width, (float)i);
                this.pBackground.line(0.0f, (float)(i + 1), (float)this.width, (float)(i + 1));
                i += 4;
            }
            this.pBackground.endDraw();
        } else if (this.sScreen == screen.MENU) {
            this.sky.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.clouds.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.levels[this.iLevelCurrent].vUpdate();
            this.fLevelIdlePosition += (float)(this.millis() - this.iLevelIdleTicks) * 0.05f * (float)this.bLevelIdleDirection;
            this.iLevelIdleTicks = this.millis();
            if (this.fLevelIdlePosition < 0.0f) {
                this.fLevelIdlePosition = 0.0f;
                this.bLevelIdleDirection = 1;
            } else if (this.fLevelIdlePosition >= (float)(this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth)) {
                this.fLevelIdlePosition = this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth;
                this.bLevelIdleDirection = (byte)-1;
            }
            this.levels[0].vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.screenMenu.vDisplay();
            this.pBackground.beginDraw();
            this.pBackground.fill(0, 60.0f);
            this.fonty.output(this.pBackground, "dace.de 2022", 8, 237);
            this.pBackground.endDraw();
        } else if (this.sScreen == screen.GAME) {
            this.sky.vDisplay(this.players[0].iGetPosX());
            this.clouds.vDisplay(this.players[0].iGetPosX());
            this.levels[this.iLevelCurrent].vUpdate();
            this.levels[this.iLevelCurrent].vDisplay(this.players[0].iGetPosX() - this.iScreenWidthHalf);
            i = 0;
            while (i < this.players.length) {
                this.players[i].vUpdate();
                this.players[i].vDisplay(this.players[0].iGetPosX());
                ++i;
            }
        } else if (this.sScreen == screen.LEVELTRANSITION) {
            this.sky.vDisplay(this.players[0].iGetPosX());
            this.clouds.vDisplay(this.players[0].iGetPosX());
            this.levels[this.iLevelCurrent].vUpdate();
            this.levels[this.iLevelCurrent].vDisplay(this.players[0].iGetPosX() - this.iScreenWidthHalf);
            iDistanceLeft = 90;
            this.pBackground.beginDraw();
            this.pBackground.fill(0);
            this.pBackground.endDraw();
            this.fonty.output(this.pBackground, "Level " + this.iLevelCurrent + ": Good job!", iDistanceLeft, 80);
            this.fonty.output(this.pBackground, "Rods collected " + this.sPadWithBlanks(this.levels[this.iLevelCurrent].iGetRodsCollected(), 5) + "/" + this.levels[this.iLevelCurrent].iGetRodsPerLevel(), iDistanceLeft, 100);
            this.fonty.output(this.pBackground, "Points         " + this.sPadWithBlanks(this.players[0].iGetScore(), 5), iDistanceLeft, 120);
            this.fonty.output(this.pBackground, "Enemies killed " + this.sPadWithBlanks(this.levels[this.iLevelCurrent].iGetEnemiesKilled(), 5), iDistanceLeft, 140);
            this.fonty.output(this.pBackground, "Seconds        " + this.sPadWithBlanks((float)this.levels[this.iLevelCurrent].iGetTicksLevelDurationFinal() * 0.001f, 5), iDistanceLeft, 160);
            this.fonty.alignCenter();
            this.fonty.output(this.pBackground, "\nPress fire to continue", this.iScreenWidthHalf, 200);
            this.fonty.alignLeft();
        } else if (this.sScreen == screen.GAMEOVER) {
            this.sky.vDisplay(this.players[0].iGetPosX());
            this.clouds.vDisplay(this.players[0].iGetPosX());
            this.levels[this.iLevelCurrent].vUpdate();
            this.levels[this.iLevelCurrent].vDisplay(this.players[0].iGetPosX() - this.iScreenWidthHalf);
            iDistanceLeft = 90;
            this.pBackground.beginDraw();
            this.pBackground.fill(0);
            this.pBackground.endDraw();
            this.fonty.output(this.pBackground, "Level " + this.iLevelCurrent + " of " + (this.iNumberLevels - 1) + ": Game over", iDistanceLeft, 80);
            this.fonty.output(this.pBackground, "Total rods     " + this.sPadWithBlanks(this.iGetRodsAllLevels(this.iLevelCurrent - 1) + this.levels[this.iLevelCurrent].iGetRodsCollected(), 5) + "/" + this.iLevelCurrent * this.levels[this.iLevelCurrent].iGetRodsPerLevel(), iDistanceLeft, 100);
            this.fonty.output(this.pBackground, "Total points   " + this.sPadWithBlanks(this.players[0].iGetScore(), 5), iDistanceLeft, 120);
            this.fonty.output(this.pBackground, "Enemies killed " + this.sPadWithBlanks(this.iGetEnemiesKilledTotal(), 5), iDistanceLeft, 140);
            this.fonty.output(this.pBackground, "Total seconds  " + this.sPadWithBlanks((float)this.iGetTicksLevelDurationFinalTotal() * 0.001f, 5), iDistanceLeft, 160);
            this.fonty.alignCenter();
            this.fonty.output(this.pBackground, "Press fire to continue", this.iScreenWidthHalf, 200);
            this.fonty.alignLeft();
        } else if (this.sScreen == screen.GAMEWON) {
            this.sky.vDisplay(this.players[0].iGetPosX());
            this.clouds.vDisplay(this.players[0].iGetPosX());
            this.levels[this.iLevelCurrent].vUpdate();
            this.levels[this.iLevelCurrent].vDisplay(this.players[0].iGetPosX() - this.iScreenWidthHalf);
            iDistanceLeft = 90;
            this.pBackground.beginDraw();
            this.pBackground.fill(0);
            this.pBackground.endDraw();
            this.fonty.output(this.pBackground, "Level " + this.iLevelCurrent + " of " + (this.iNumberLevels - 1) + ": You beat the game!", iDistanceLeft, 80);
            this.fonty.output(this.pBackground, "Total rods     " + this.sPadWithBlanks(this.iGetRodsAllLevels(this.iLevelCurrent) + this.levels[this.iLevelCurrent].iGetRodsCollected(), 5) + "/" + this.iLevelCurrent * this.levels[this.iLevelCurrent].iGetRodsPerLevel(), iDistanceLeft, 100);
            this.fonty.output(this.pBackground, "Total points   " + this.sPadWithBlanks(this.players[0].iGetScore(), 5), iDistanceLeft, 120);
            this.fonty.output(this.pBackground, "Enemies killed " + this.sPadWithBlanks(this.iGetEnemiesKilledTotal(), 5), iDistanceLeft, 140);
            this.fonty.output(this.pBackground, "Total seconds  " + this.sPadWithBlanks((float)this.iGetTicksLevelDurationFinalTotal() * 0.001f, 5), iDistanceLeft, 160);
            this.fonty.alignCenter();
            this.fonty.output(this.pBackground, "Press fire to continue", this.iScreenWidthHalf, 200);
            this.fonty.alignLeft();
        } else if (this.sScreen == screen.HISCORESHOW) {
            this.sky.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.clouds.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.levels[this.iLevelCurrent].vUpdate();
            this.fLevelIdlePosition += (float)(this.millis() - this.iLevelIdleTicks) * 0.05f * (float)this.bLevelIdleDirection;
            this.iLevelIdleTicks = this.millis();
            if (this.fLevelIdlePosition < 0.0f) {
                this.fLevelIdlePosition = 0.0f;
                this.bLevelIdleDirection = 1;
            } else if (this.fLevelIdlePosition >= (float)(this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth)) {
                this.fLevelIdlePosition = this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth;
                this.bLevelIdleDirection = (byte)-1;
            }
            this.levels[0].vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.screenHiscoreShow.vDisplay();
        } else if (this.sScreen == screen.HISCOREENTER) {
            this.sky.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.clouds.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.levels[this.iLevelCurrent].vUpdate();
            this.fLevelIdlePosition += (float)(this.millis() - this.iLevelIdleTicks) * 0.05f * (float)this.bLevelIdleDirection;
            this.iLevelIdleTicks = this.millis();
            if (this.fLevelIdlePosition < 0.0f) {
                this.fLevelIdlePosition = 0.0f;
                this.bLevelIdleDirection = 1;
            } else if (this.fLevelIdlePosition >= (float)(this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth)) {
                this.fLevelIdlePosition = this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth;
                this.bLevelIdleDirection = (byte)-1;
            }
            this.levels[0].vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.screenHiscoreEnter.vDisplay();
        } else if (this.sScreen == screen.ABOUT) {
            this.sky.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.clouds.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.levels[this.iLevelCurrent].vUpdate();
            this.fLevelIdlePosition += (float)(this.millis() - this.iLevelIdleTicks) * 0.05f * (float)this.bLevelIdleDirection;
            this.iLevelIdleTicks = this.millis();
            if (this.fLevelIdlePosition < 0.0f) {
                this.fLevelIdlePosition = 0.0f;
                this.bLevelIdleDirection = 1;
            } else if (this.fLevelIdlePosition >= (float)(this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth)) {
                this.fLevelIdlePosition = this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth;
                this.bLevelIdleDirection = (byte)-1;
            }
            this.levels[0].vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.screenAbout.vDisplay();
        } else if (this.sScreen == screen.TRANSITIONIN) {
            this.sky.vDisplay(this.players[0].iGetPosX());
            this.clouds.vDisplay(this.players[0].iGetPosX());
            this.levels[this.iLevelCurrent].vUpdate();
            this.levels[this.iLevelCurrent].vDisplay(this.players[0].iGetPosX() - this.iScreenWidthHalf);
            i = 0;
            while (i < this.leafs.length) {
                this.leafs[i].vUpdate();
                ++i;
            }
            i = 0;
            while (i < this.leafs.length) {
                this.leafs[i].vDisplay();
                ++i;
            }
        } else if (this.sScreen == screen.TRANSITIONOUT) {
            this.sky.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.clouds.vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.levels[this.iLevelCurrent].vUpdate();
            this.fLevelIdlePosition += (float)(this.millis() - this.iLevelIdleTicks) * 0.05f * (float)this.bLevelIdleDirection;
            this.iLevelIdleTicks = this.millis();
            if (this.fLevelIdlePosition < 0.0f) {
                this.fLevelIdlePosition = 0.0f;
                this.bLevelIdleDirection = 1;
            } else if (this.fLevelIdlePosition >= (float)(this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth)) {
                this.fLevelIdlePosition = this.levels[0].iTileNumberHorizontal * this.iTileSize - this.iScreenWidth;
                this.bLevelIdleDirection = (byte)-1;
            }
            this.levels[0].vDisplay(PApplet.parseInt((float)this.fLevelIdlePosition));
            this.pBackground.beginDraw();
            this.pBackground.noStroke();
            this.pBackground.fill(0, 40.0f);
            this.pBackground.rect(0.0f, 0.0f, (float)this.iScreenWidth, (float)this.iScreenHeight);
            this.pBackground.endDraw();
            i = 0;
            while (i < this.leafs.length) {
                this.leafs[i].vUpdate();
                ++i;
            }
            i = 0;
            while (i < this.leafs.length) {
                this.leafs[i].vDisplay();
                ++i;
            }
        }
        i = 0;
        while (i < this.particles.length) {
            this.particles[i].vUpdate();
            ++i;
        }
        i = 0;
        while (i < this.particles.length) {
            this.particles[i].vDisplay(0);
            ++i;
        }
        if (this.gamepad) {
            if ((this.joystick0.getButton(0).pressed() || this.joystick0.getButton(1).pressed() || this.joystick0.getButton(2).pressed()) && !this.bJoystick0Controls[0]) {
                this.bJoystick0Controls[0] = true;
                if (this.sScreen == screen.GAME) {
                    this.vButtonPressed(this.players[0].cGetKeyUp());
                } else {
                    this.vButtonPressed(this.players[0].cGetKeyFire());
                }
            }
            if (this.joystick0.getSlider(1).getValue() == -1.0f && !this.bJoystick0Controls[1]) {
                this.bJoystick0Controls[1] = true;
                this.vButtonPressed(this.players[0].cGetKeyUp());
            } else if (this.joystick0.getSlider(1).getValue() == 1.0f && !this.bJoystick0Controls[2]) {
                this.bJoystick0Controls[2] = true;
                this.vButtonPressed(this.players[0].cGetKeyDown());
            }
            if (this.joystick0.getSlider(0).getValue() == -1.0f && !this.bJoystick0Controls[3]) {
                this.bJoystick0Controls[3] = true;
                this.vButtonPressed(this.players[0].cGetKeyLeft());
            } else if (this.joystick0.getSlider(0).getValue() == 1.0f && !this.bJoystick0Controls[4]) {
                this.bJoystick0Controls[4] = true;
                this.vButtonPressed(this.players[0].cGetKeyRight());
            }
            if (this.joystick1 != null) {
                if ((this.joystick1.getButton(0).pressed() || this.joystick1.getButton(1).pressed() || this.joystick1.getButton(2).pressed()) && !this.bJoystick1Controls[0]) {
                    this.bJoystick1Controls[0] = true;
                    if (this.sScreen == screen.GAME) {
                        this.vButtonPressed(this.players[0].cGetKeyUp());
                    } else {
                        this.vButtonPressed(this.players[0].cGetKeyFire());
                    }
                }
                if (this.joystick1.getSlider(1).getValue() == -1.0f && !this.bJoystick1Controls[1]) {
                    this.bJoystick1Controls[1] = true;
                    this.vButtonPressed(this.players[0].cGetKeyUp());
                } else if (this.joystick1.getSlider(1).getValue() == 1.0f && !this.bJoystick1Controls[2]) {
                    this.bJoystick1Controls[2] = true;
                    this.vButtonPressed(this.players[0].cGetKeyDown());
                }
                if (this.joystick1.getSlider(0).getValue() == -1.0f && !this.bJoystick1Controls[3]) {
                    this.bJoystick1Controls[3] = true;
                    this.vButtonPressed(this.players[0].cGetKeyLeft());
                } else if (this.joystick1.getSlider(0).getValue() == 1.0f && !this.bJoystick1Controls[4]) {
                    this.bJoystick1Controls[4] = true;
                    this.vButtonPressed(this.players[0].cGetKeyRight());
                }
            }
            if (!(this.joystick0.getButton(0).pressed() && this.joystick0.getButton(1).pressed() && this.joystick0.getButton(2).pressed() || !this.bJoystick0Controls[0])) {
                this.bJoystick0Controls[0] = false;
                if (this.sScreen == screen.GAME) {
                    this.vButtonReleased(this.players[0].cGetKeyUp());
                } else {
                    this.vButtonReleased(this.players[0].cGetKeyFire());
                }
            }
            if (this.joystick0.getSlider(1).getValue() != -1.0f && this.bJoystick0Controls[1]) {
                this.bJoystick0Controls[1] = false;
                this.vButtonReleased(this.players[0].cGetKeyUp());
            } else if (this.joystick0.getSlider(1).getValue() != 1.0f && this.bJoystick0Controls[2]) {
                this.bJoystick0Controls[2] = false;
                this.vButtonReleased(this.players[0].cGetKeyDown());
            }
            if (this.joystick0.getSlider(0).getValue() != -1.0f && this.bJoystick0Controls[3]) {
                this.bJoystick0Controls[3] = false;
                this.vButtonReleased(this.players[0].cGetKeyLeft());
            } else if (this.joystick0.getSlider(0).getValue() != 1.0f && this.bJoystick0Controls[4]) {
                this.bJoystick0Controls[4] = false;
                this.vButtonReleased(this.players[0].cGetKeyRight());
            }
            if (this.joystick1 != null) {
                if (!(this.joystick1.getButton(0).pressed() && this.joystick1.getButton(1).pressed() && this.joystick1.getButton(2).pressed() || !this.bJoystick1Controls[0])) {
                    this.bJoystick1Controls[0] = false;
                    if (this.sScreen == screen.GAME) {
                        this.vButtonReleased(this.players[0].cGetKeyUp());
                    } else {
                        this.vButtonReleased(this.players[0].cGetKeyFire());
                    }
                }
                if (this.joystick1.getSlider(1).getValue() != -1.0f && this.bJoystick1Controls[1]) {
                    this.bJoystick1Controls[1] = false;
                    this.vButtonReleased(this.players[0].cGetKeyUp());
                } else if (this.joystick1.getSlider(1).getValue() != 1.0f && this.bJoystick1Controls[2]) {
                    this.bJoystick1Controls[2] = false;
                    this.vButtonReleased(this.players[0].cGetKeyDown());
                }
                if (this.joystick1.getSlider(0).getValue() != -1.0f && this.bJoystick1Controls[3]) {
                    this.bJoystick1Controls[3] = false;
                    this.vButtonReleased(this.players[0].cGetKeyLeft());
                } else if (this.joystick1.getSlider(0).getValue() != 1.0f && this.bJoystick1Controls[4]) {
                    this.bJoystick1Controls[4] = false;
                    this.vButtonReleased(this.players[0].cGetKeyRight());
                }
            }
        }
        this.image((PImage)this.pBackground, this.iOffsetX, this.iOffsetY, (float)this.iResLowX * this.fFactor, (float)this.iResLowY * this.fFactor);
    }

    public void stop() {
        this.minim.stop();
        super.stop();
    }

    public void settings() {
        this.fullScreen();
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"jozsefatomick"};
        if (passedArgs != null) {
            PApplet.main((String[])jozsefatomick.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Clouds {
        PImage img = null;

        Clouds() {
            this.img = jozsefatomick.this.loadImage("clouds3_640x256.png");
        }

        public void vDisplay(int hor) {
            if ((hor = (int)((float)hor * 0.25f)) > this.img.width) {
                hor %= this.img.width;
            }
            jozsefatomick.this.pBackground.beginDraw();
            if (hor >= jozsefatomick.this.iScreenWidth) {
                jozsefatomick.this.pBackground.image(this.img, (float)(-hor + this.img.width), 0.0f);
            }
            jozsefatomick.this.pBackground.image(this.img, (float)(-hor), 0.0f);
            jozsefatomick.this.pBackground.endDraw();
        }
    }

    class Enemy {
        byte bId = (byte)-1;
        float fPosX = 0.0f;
        float fPosY = 0.0f;
        float fInitialPosX = 0.0f;
        float fInitialPosY = 0.0f;
        byte bOverlapHor = (byte)3;
        float fSpeed = 0.03f;
        byte bDirection = (byte)-1;
        boolean bStandsOnGround = false;
        boolean bIsOn = false;
        PImage graphics = null;
        float fMovementVert = 0.0f;
        float fMovementVertMax = 10.0f;
        int iTypeNumber = -1;
        int iTicksLast = 0;
        int iTicksLastJump = 0;
        int iTicksJumpFrequency = 2400;
        float fSpeedJumpInitial = -4.0f;

        Enemy(byte n) {
            this.bId = n;
        }

        public boolean bIsOn() {
            return this.bIsOn;
        }

        public boolean bIsOnScreen(int hor) {
            if (!this.bIsOn) {
                return false;
            }
            return this.fPosX - (float)hor >= 0.0f && this.fPosX - (float)hor < (float)jozsefatomick.this.iScreenWidth;
        }

        public int cGetColour() {
            return jozsefatomick.this.color(this.bId * 77 % 255, this.bId * 117 % 255, this.bId * 213 % 255);
        }

        public int iCollisionCheck(int n, int x, int y) {
            if (!this.bIsOn) {
                return -1;
            }
            if ((float)x >= this.fPosX && (float)x < this.fPosX + (float)jozsefatomick.this.iTileSize && (float)y >= this.fPosY && (float)y < this.fPosY + (float)jozsefatomick.this.iTileSize) {
                return this.bId;
            }
            return -1;
        }

        public int iGetPosX() {
            return PApplet.parseInt((float)this.fPosX);
        }

        public int iGetPosY() {
            return PApplet.parseInt((float)this.fPosY);
        }

        public int iGetPosXCentre() {
            return PApplet.parseInt((float)this.fPosX) + jozsefatomick.this.iTileSizeHalf;
        }

        public int iGetPosYCentre() {
            return PApplet.parseInt((float)this.fPosY) + jozsefatomick.this.iTileSizeHalf;
        }

        public int iGetPoints() {
            return jozsefatomick.this.iPointsEnemy * (this.bId % 10);
        }

        public int iGetType() {
            return this.iTypeNumber;
        }

        public void vAdd(int n, int x, int y, PImage p) {
            this.iTypeNumber = n;
            this.fSpeed *= (float)(this.iTypeNumber % 10);
            this.fSpeedJumpInitial = -2.0f + this.fSpeedJumpInitial * (float)(this.iTypeNumber % 10);
            this.iTicksJumpFrequency *= this.iTypeNumber % 10;
            this.fInitialPosX = this.fPosX = (float)x;
            this.fInitialPosY = this.fPosY = (float)y;
            this.graphics = p;
            this.bIsOn = true;
        }

        public void vDisplay(int hor) {
            if (!this.bIsOn) {
                return;
            }
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.image(this.graphics, this.fPosX - (float)hor, this.fPosY);
            jozsefatomick.this.pBackground.endDraw();
        }

        public void vJump() {
            if (this.bStandsOnGround) {
                if (this.bIsOnScreen(jozsefatomick.this.players[0].iGetPosX())) {
                    jozsefatomick.this.vAudioPlay(3);
                }
                this.bStandsOnGround = false;
                this.fMovementVert = this.fSpeedJumpInitial;
            }
        }

        public void vLifeLost(boolean e) {
            if (this.bIsOnScreen(jozsefatomick.this.players[0].iGetPosX())) {
                jozsefatomick.this.vAudioPlay(6);
            }
            if (e) {
                jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vExplosion(PApplet.parseInt((float)(this.fPosX + (float)jozsefatomick.this.iTileSizeHalf)), PApplet.parseInt((float)(this.fPosY + (float)jozsefatomick.this.iTileSizeHalf)), this.cGetColour());
            }
            this.bIsOn = false;
            this.fPosY = 0.0f;
            this.fMovementVert = 0.0f;
            this.bStandsOnGround = true;
        }

        public void vReset() {
            if (!this.bIsOn) {
                return;
            }
            this.fPosX = this.fInitialPosX;
            this.fPosY = this.fInitialPosY;
            this.fMovementVert = 0.0f;
            this.bStandsOnGround = false;
            this.iTicksLast = this.iTicksLastJump = jozsefatomick.this.millis();
        }

        public void vUpdate() {
            int iCollisionEnemyTop;
            int iTileBelow;
            if (!this.bIsOn) {
                return;
            }
            int iDeltaTicksJump = jozsefatomick.this.millis() - this.iTicksLastJump;
            if (iDeltaTicksJump >= this.iTicksJumpFrequency) {
                this.iTicksLastJump += iDeltaTicksJump;
                this.vJump();
            }
            int iTicksDelta = jozsefatomick.this.millis() - this.iTicksLast;
            this.iTicksLast += iTicksDelta;
            if (this.bStandsOnGround) {
                if (this.bDirection < 0) {
                    this.fPosX += (float)iTicksDelta * this.fSpeed * (float)this.bDirection;
                    int iTileLeft = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosX() + this.bOverlapHor, this.iGetPosYCentre(), direction.LEFT);
                    if (iTileLeft != -1) {
                        this.fPosX = iTileLeft - this.bOverlapHor;
                        this.bDirection = (byte)(this.bDirection * -1);
                    }
                } else {
                    this.fPosX += (float)iTicksDelta * this.fSpeed * (float)this.bDirection;
                    int iTileRight = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosX() + jozsefatomick.this.iTileSize - 1 - this.bOverlapHor, this.iGetPosYCentre(), direction.RIGHT);
                    if (iTileRight != -1) {
                        this.fPosX = iTileRight + this.bOverlapHor;
                        this.bDirection = (byte)(this.bDirection * -1);
                    }
                }
                if ((iTileBelow = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosXCentre(), this.iGetPosY() + jozsefatomick.this.iTileSize, direction.BELOW)) != -1) {
                    this.fPosY = iTileBelow;
                } else {
                    int iRand = PApplet.parseInt((float)jozsefatomick.this.random(100.0f));
                    if (iRand < 96) {
                        this.bDirection = (byte)(this.bDirection * -1);
                    } else if (iRand < 97) {
                        this.bStandsOnGround = true;
                        this.vJump();
                    } else {
                        this.fMovementVert += (float)iTicksDelta * jozsefatomick.this.fGravityFactor;
                        if (this.fMovementVert > this.fMovementVertMax) {
                            this.fMovementVert = this.fMovementVertMax;
                        }
                        this.fPosY += this.fMovementVert;
                        this.bStandsOnGround = false;
                    }
                }
            } else {
                if (this.bDirection < 0) {
                    this.fPosX += (float)iTicksDelta * -this.fSpeed;
                    int iTileLeftBottom = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosX() + this.bOverlapHor, this.iGetPosY() + jozsefatomick.this.iTileSize - 1 - jozsefatomick.this.bGrace, direction.LEFT);
                    if (iTileLeftBottom != -1) {
                        this.fPosX = iTileLeftBottom - this.bOverlapHor;
                        this.bDirection = (byte)(this.bDirection * -1);
                    } else {
                        int iTileLeftTop = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosX() + this.bOverlapHor, this.iGetPosY(), direction.LEFT);
                        if (iTileLeftTop != -1) {
                            this.fPosX = iTileLeftTop - this.bOverlapHor;
                            this.bDirection = (byte)(this.bDirection * -1);
                        }
                    }
                } else {
                    this.fPosX += (float)iTicksDelta * this.fSpeed;
                    int iTileRightBottom = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosX() + jozsefatomick.this.iTileSize - 1 - this.bOverlapHor, this.iGetPosY() + jozsefatomick.this.iTileSize - 1 - jozsefatomick.this.bGrace, direction.RIGHT);
                    if (iTileRightBottom != -1) {
                        this.fPosX = iTileRightBottom + this.bOverlapHor;
                        this.bDirection = (byte)(this.bDirection * -1);
                    } else {
                        int iTileRightTop = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosX() + jozsefatomick.this.iTileSize - 1 - this.bOverlapHor, this.iGetPosY(), direction.RIGHT);
                        if (iTileRightTop != -1) {
                            this.fPosX = iTileRightTop + this.bOverlapHor;
                            this.bDirection = (byte)(this.bDirection * -1);
                        }
                    }
                }
                this.fMovementVert += (float)iTicksDelta * jozsefatomick.this.fGravityFactor;
                if (this.fMovementVert > this.fMovementVertMax) {
                    this.fMovementVert = this.fMovementVertMax;
                }
                this.fPosY += this.fMovementVert;
                if (this.fMovementVert < 0.0f) {
                    int iTileAbove = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosXCentre(), this.iGetPosY(), direction.ABOVE);
                    if (iTileAbove != -1) {
                        if (this.bIsOnScreen(jozsefatomick.this.players[0].iGetPosX())) {
                            jozsefatomick.this.vAudioPlay(5);
                        }
                        this.fPosY = iTileAbove;
                        this.fMovementVert = 0.0f;
                    }
                } else {
                    iTileBelow = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)(this.bId + 10)), this.iGetPosXCentre(), this.iGetPosY() + jozsefatomick.this.iTileSize, direction.BELOW);
                    if (iTileBelow != -1) {
                        if (this.bIsOnScreen(jozsefatomick.this.players[0].iGetPosX())) {
                            jozsefatomick.this.vAudioPlay(5);
                        }
                        this.fPosY = iTileBelow;
                        this.bStandsOnGround = true;
                        this.fMovementVert = 0.0f;
                    }
                }
            }
            if (this.fPosY > (float)jozsefatomick.this.iScreenHeight) {
                this.vLifeLost(false);
            }
            if ((iCollisionEnemyTop = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyCollisionCheck(this.bId, this.iGetPosXCentre(), this.iGetPosY())) != -1 && iCollisionEnemyTop != this.bId) {
                this.vLifeLost(true);
                jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vEnemyJump(iCollisionEnemyTop);
                return;
            }
            int iCollisionEnemyLeft = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyCollisionCheck(this.bId, this.iGetPosX(), this.iGetPosYCentre());
            if (iCollisionEnemyLeft != -1 && iCollisionEnemyLeft != this.bId) {
                this.bDirection = (byte)(this.bDirection * -1);
                return;
            }
            int iCollisionEnemyRight = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyCollisionCheck(this.bId, this.iGetPosX() + jozsefatomick.this.iTileSize - 1, this.iGetPosYCentre());
            if (iCollisionEnemyRight != -1 && iCollisionEnemyRight != this.bId) {
                this.bDirection = (byte)(this.bDirection * -1);
                return;
            }
            int iCollisionEnemyBottom = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyCollisionCheck(this.bId, this.iGetPosXCentre(), this.iGetPosY() + jozsefatomick.this.iTileSize - 1);
            if (iCollisionEnemyBottom != -1 && iCollisionEnemyBottom != this.bId) {
                jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vEnemyLifeLost(iCollisionEnemyBottom, true);
                this.vJump();
                return;
            }
        }
    }

    class Fonty {
        int iDotColumns = 6;
        int iDotRows = 9;
        int iBaseline;
        int iBaselineCurrent = this.iBaseline = -2;
        int iWidth = this.iDotColumns;
        int iHeight = this.iDotRows;
        int iLettersNumber = 128;
        Letter[] letters = new Letter[this.iLettersNumber];
        byte bAlign = 0;
        int iDotsNumber = this.iDotColumns * this.iDotRows;
        int iGap = 0;
        float fGap = 0.05f;

        Fonty() {
        }

        public void vInit() {
            int i = 0;
            while (i < this.letters.length) {
                this.letters[i] = new Letter(i, this.iDotColumns, this.iDotRows);
                ++i;
            }
        }

        public void vSetAlign(byte a) {
            this.bAlign = a;
        }

        public void vSetHeight(int h) {
            if (h < 1) {
                h = this.iDotRows;
            }
            this.iHeight = h;
            float fScale = PApplet.parseFloat((int)h) / (float)this.iDotRows;
            this.iWidth = PApplet.parseInt((float)((float)this.iDotColumns * fScale));
            this.iBaselineCurrent = PApplet.parseInt((float)((float)this.iBaseline * fScale));
        }

        public void vOutput(String s, int x, int y) {
            float fStrokeWeightCurrent = jozsefatomick.this.getGraphics().strokeWeight;
            float fStrokeColourCurrent = jozsefatomick.this.getGraphics().strokeColor;
            if (this.iHeight % this.iDotRows == 0) {
                jozsefatomick.this.noStroke();
            } else {
                jozsefatomick.this.stroke(jozsefatomick.this.getGraphics().fillColor);
                jozsefatomick.this.strokeWeight(1.0f);
            }
            float fScale = 1.0f;
            if (this.iHeight != this.iDotRows) {
                fScale = PApplet.parseFloat((int)this.iHeight) / (float)this.iDotRows;
            }
            if (this.bAlign != 0) {
                int iStringLengthPixels;
                if (this.bAlign == 1) {
                    iStringLengthPixels = s.length() * this.iDotColumns;
                    x = (int)((float)x - (float)iStringLengthPixels * fScale);
                } else {
                    iStringLengthPixels = s.length() * this.iDotColumns;
                    x = (int)((float)x - (float)iStringLengthPixels * 0.5f * fScale);
                }
            }
            int i = 0;
            while (i < s.length()) {
                char cDisplay = s.charAt(i);
                if (cDisplay >= ' ' && cDisplay < this.iLettersNumber) {
                    this.letters[cDisplay].vDisplay(x, y - this.iBaselineCurrent, this.iHeight, this.iDotColumns, this.iDotRows, fScale);
                }
                x += this.iWidth;
                ++i;
            }
            jozsefatomick.this.strokeWeight(fStrokeWeightCurrent);
            jozsefatomick.this.stroke(fStrokeColourCurrent);
        }

        public void vOutput(PGraphics pg, String s, int x, int y) {
            float fStrokeWeightCurrent = jozsefatomick.this.getGraphics().strokeWeight;
            float fStrokeColourCurrent = jozsefatomick.this.getGraphics().strokeColor;
            if (this.iHeight % this.iDotRows == 0) {
                pg.beginDraw();
                pg.noStroke();
                pg.endDraw();
            } else {
                pg.beginDraw();
                pg.stroke(jozsefatomick.this.getGraphics().fillColor);
                pg.strokeWeight(1.0f);
                pg.endDraw();
            }
            float fScale = 1.0f;
            if (this.iHeight != this.iDotRows) {
                fScale = PApplet.parseFloat((int)this.iHeight) / (float)this.iDotRows;
            }
            if (this.bAlign != 0) {
                int iStringLengthPixels;
                if (this.bAlign == 1) {
                    iStringLengthPixels = s.length() * this.iDotColumns;
                    x = (int)((float)x - (float)iStringLengthPixels * fScale);
                } else {
                    iStringLengthPixels = s.length() * this.iDotColumns;
                    x = (int)((float)x - (float)iStringLengthPixels * 0.5f * fScale);
                }
            }
            int i = 0;
            while (i < s.length()) {
                char cDisplay = s.charAt(i);
                if (cDisplay >= ' ' && cDisplay < this.iLettersNumber) {
                    this.letters[cDisplay].vDisplay(pg, x, y - this.iBaselineCurrent, this.iHeight, this.iDotColumns, this.iDotRows, fScale);
                }
                x += this.iWidth;
                ++i;
            }
            pg.beginDraw();
            pg.strokeWeight(fStrokeWeightCurrent);
            pg.stroke(fStrokeColourCurrent);
            pg.endDraw();
        }

        public void alignLeft() {
            this.vSetAlign(PApplet.parseByte((int)0));
        }

        public void alignRight() {
            this.vSetAlign(PApplet.parseByte((int)1));
        }

        public void alignCenter() {
            this.vSetAlign(PApplet.parseByte((int)2));
        }

        public void height(int h) {
            this.vSetHeight(h);
        }

        public void output(String s, float x, float y) {
            this.vOutput(s, PApplet.parseInt((float)x), PApplet.parseInt((float)y));
        }

        public void output(PGraphics pg, String s, float x, float y) {
            this.vOutput(pg, s, PApplet.parseInt((float)x), PApplet.parseInt((float)y));
        }

        public void output(String s, int x, int y) {
            this.vOutput(s, x, y);
        }

        public void output(PGraphics pg, String s, int x, int y) {
            this.vOutput(pg, s, x, y);
        }
    }

    class Leaf {
        int iId = -1;
        int iPosX = -1;
        int iPosY = -1;
        int iSize;
        float fSpeed;
        int iTicksStart;
        int iTicksLast;
        int cColour;
        float fProgress;
        boolean bGoOut;

        Leaf(int n) {
            this.iSize = jozsefatomick.this.iTileSize;
            this.fSpeed = 1.0f;
            this.iTicksStart = jozsefatomick.this.millis();
            this.iTicksLast = 0;
            this.cColour = 0;
            this.fProgress = 0.0f;
            this.bGoOut = false;
            this.iId = n;
            this.iPosX = n % (jozsefatomick.this.iScreenWidth / this.iSize) * this.iSize;
            this.iPosY = n / (jozsefatomick.this.iScreenWidth / this.iSize) * this.iSize;
        }

        public boolean bIsOn() {
            return false;
        }

        public void vDisplay() {
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.noStroke();
            jozsefatomick.this.pBackground.fill(this.cColour);
            if (!this.bGoOut) {
                jozsefatomick.this.pBackground.rect((float)this.iPosX + (float)this.iSize * 0.5f - (float)this.iSize * this.fProgress * 0.5f, (float)this.iPosY + (float)this.iSize * 0.5f - (float)this.iSize * this.fProgress * 0.5f, (float)this.iSize * this.fProgress, (float)this.iSize * this.fProgress);
            } else {
                jozsefatomick.this.pBackground.rect((float)this.iPosX, (float)this.iPosY, (float)this.iSize, (float)this.iSize * 0.5f - (float)this.iSize * this.fProgress * 0.5f);
                jozsefatomick.this.pBackground.rect((float)this.iPosX, (float)this.iPosY + (float)this.iSize * 0.5f - (float)this.iSize * this.fProgress * 0.5f - 1.0f, (float)this.iSize * 0.5f - (float)this.iSize * this.fProgress * 0.5f, (float)this.iSize * this.fProgress + 2.0f);
                jozsefatomick.this.pBackground.rect((float)this.iPosX + (float)this.iSize * 0.5f + (float)this.iSize * this.fProgress * 0.5f, (float)this.iPosY + (float)this.iSize * 0.5f - (float)this.iSize * this.fProgress * 0.5f - 1.0f, (float)this.iSize * 0.5f - (float)this.iSize * this.fProgress * 0.5f, (float)this.iSize * this.fProgress + 2.0f);
                jozsefatomick.this.pBackground.rect((float)this.iPosX, (float)this.iPosY + (float)this.iSize * 0.5f + (float)this.iSize * this.fProgress * 0.5f, (float)this.iSize, (float)this.iSize * 0.5f - (float)this.iSize * this.fProgress * 0.5f);
            }
            jozsefatomick.this.pBackground.endDraw();
        }

        public void vInit(boolean goOut) {
            this.bGoOut = goOut;
            this.fProgress = 0.0f;
            this.iTicksLast = jozsefatomick.this.millis();
        }

        public void vUpdate() {
            int iDelta = jozsefatomick.this.millis() - this.iTicksLast;
            this.iTicksLast += iDelta;
            this.fProgress += this.fSpeed * (float)iDelta * 5.0E-4f + (float)(jozsefatomick.this.iScreenWidth - this.iPosX) / PApplet.parseFloat((int)jozsefatomick.this.iScreenWidth) * 0.01f;
            if (this.iId == jozsefatomick.this.iNumberLeafs - 1 && this.fProgress > 1.0f) {
                if (jozsefatomick.this.sScreen == screen.TRANSITIONIN) {
                    jozsefatomick.this.vGoToScreenTransitionOut();
                } else {
                    jozsefatomick.this.vGoToScreenHiscoreShow();
                }
            }
            if (this.fProgress > 1.0f) {
                this.fProgress = 1.0f;
            }
            this.cColour = !this.bGoOut ? jozsefatomick.this.color(((float)(this.iId * this.iPosX) + (float)(jozsefatomick.this.millis() - this.iTicksStart) * 0.001f) % 255.0f, this.iId * this.iPosY * 17 % 255, this.iPosX * this.iPosY * 37 % 255) : jozsefatomick.this.color(((float)(this.iId * this.iPosX) + (float)(jozsefatomick.this.millis() - this.iTicksStart) * 0.001f) % 255.0f, this.iId * this.iPosY * 17 % 255, this.iPosX * this.iPosY * 37 % 255);
        }
    }

    class Letter {
        int iId = -1;
        boolean[][] letterDots;

        Letter(int l, int iDotColumns, int iDotRows) {
            this.iId = l;
            this.letterDots = new boolean[iDotColumns][iDotRows];
            PImage sheet = jozsefatomick.this.loadImage("font.png");
            PImage oneLetter = sheet.get(this.iId * iDotColumns, 0, iDotColumns, iDotRows);
            int j = 0;
            while (j < oneLetter.height) {
                int i = 0;
                while (i < oneLetter.width) {
                    this.letterDots[i][j] = oneLetter.get(i, j) != jozsefatomick.this.color(0);
                    ++i;
                }
                ++j;
            }
        }

        public void vDisplay(int x, int y, int h, int iDotColumns, int iDotRows, float fScale) {
            if (h == iDotRows) {
                int j = 0;
                while (j < iDotRows) {
                    int i = 0;
                    while (i < iDotColumns) {
                        if (this.letterDots[i][j]) {
                            jozsefatomick.this.rect(x + i, y + j - h, 1.0f, 1.0f);
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < iDotRows) {
                    int i = 0;
                    while (i < iDotColumns) {
                        if (this.letterDots[i][j]) {
                            jozsefatomick.this.rect((float)x + (float)i * fScale, (float)y + (float)j * fScale - (float)h, fScale, fScale);
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }

        public void vDisplay(PGraphics pg, int x, int y, int h, int iDotColumns, int iDotRows, float fScale) {
            if (h == iDotRows) {
                pg.beginDraw();
                int j = 0;
                while (j < iDotRows) {
                    int i = 0;
                    while (i < iDotColumns) {
                        if (this.letterDots[i][j]) {
                            pg.rect((float)(x + i), (float)(y + j - h), 1.0f, 1.0f);
                        }
                        ++i;
                    }
                    ++j;
                }
                pg.endDraw();
            } else {
                pg.beginDraw();
                int j = 0;
                while (j < iDotRows) {
                    int i = 0;
                    while (i < iDotColumns) {
                        if (this.letterDots[i][j]) {
                            pg.rect((float)x + (float)i * fScale, (float)y + (float)j * fScale - (float)h, fScale, fScale);
                        }
                        ++i;
                    }
                    ++j;
                }
                pg.endDraw();
            }
        }
    }

    class Level {
        int iId = -1;
        Enemy[] enemies;
        Tile[] tiles;
        int iTileNumberHorizontal;
        int iTileNumberVertical;
        PImage pTileSheet;
        Particle[] particles;
        byte bRodsPerLevel;
        int iRodsCollected;
        int iTicksLevelStart;
        int iTicksLevelDuration;
        int iEnemiesKilled;
        int iTickLastRandomTimedEvent;

        Level(int levelNumber) {
            this.enemies = new Enemy[jozsefatomick.this.iNumberEnemies];
            this.tiles = new Tile[jozsefatomick.this.iNumberTiles];
            this.iTileNumberHorizontal = 0;
            this.iTileNumberVertical = 0;
            this.pTileSheet = null;
            this.particles = new Particle[jozsefatomick.this.iNumberParticles];
            this.bRodsPerLevel = (byte)6;
            this.iRodsCollected = 0;
            this.iTicksLevelStart = 0;
            this.iTicksLevelDuration = 0;
            this.iEnemiesKilled = 0;
            this.iTickLastRandomTimedEvent = 0;
            this.iId = levelNumber;
            int i = 0;
            while (i < this.enemies.length) {
                this.enemies[i] = new Enemy(PApplet.parseByte((int)i));
                ++i;
            }
            i = 0;
            while (i < this.particles.length) {
                this.particles[i] = new Particle(i);
                ++i;
            }
        }

        public int cEnemyGetColour(int n) {
            return this.enemies[n].cGetColour();
        }

        public int iCollisionCheck(byte b, int x, int y, direction side) {
            if (x < 0 || y < 0 || x >= this.iTileNumberHorizontal * jozsefatomick.this.iTileSize || y >= this.iTileNumberVertical * jozsefatomick.this.iTileSize) {
                return -1;
            }
            int iTileX = x / jozsefatomick.this.iTileSize;
            int iTileY = y / jozsefatomick.this.iTileSize;
            int iTileToCheck = iTileX + iTileY * this.iTileNumberHorizontal;
            return this.tiles[iTileToCheck].iCollisionCheck(b, x, y, side);
        }

        public int iEnemyCollisionCheck(byte n, int x, int y) {
            int i = 0;
            while (i < this.enemies.length) {
                int iIsThereCollision = this.enemies[i].iCollisionCheck(n, x, y);
                if (iIsThereCollision != -1) {
                    return iIsThereCollision;
                }
                ++i;
            }
            return -1;
        }

        public int iEnemyGetFree() {
            int i = 0;
            while (i < this.enemies.length) {
                if (!this.enemies[i].bIsOn()) {
                    return i;
                }
                ++i;
            }
            jozsefatomick.println((String)("Error: Not enough array spots to hold all enemies for level " + jozsefatomick.this.iLevelCurrent));
            return PApplet.parseInt((float)jozsefatomick.this.random(this.enemies.length));
        }

        public int iEnemyGetPoints(int n) {
            return this.enemies[n].iGetPoints();
        }

        public int iEnemyGetType(int n) {
            return this.enemies[n].iGetType();
        }

        public int iGetEnemiesKilled() {
            return this.iEnemiesKilled;
        }

        public int iGetRodsCollected() {
            return this.iRodsCollected;
        }

        public int iGetRodsPerLevel() {
            return this.bRodsPerLevel;
        }

        public int iGetTicksLevelDuration() {
            return jozsefatomick.this.millis() - this.iTicksLevelStart;
        }

        public int iGetTicksLevelDurationFinal() {
            return this.iTicksLevelDuration;
        }

        public PImage pGetTileFromTilesheet(int i, int j) {
            return this.pTileSheet.get(i * jozsefatomick.this.iTileSize, j * jozsefatomick.this.iTileSize, jozsefatomick.this.iTileSize, jozsefatomick.this.iTileSize);
        }

        public void vEnemyAdd(int n, int x, int y, PImage p) {
            jozsefatomick.print((String)("level " + this.iId + ": "));
            this.enemies[this.iEnemyGetFree()].vAdd(n, x, y, p);
        }

        public void vEnemyJump(int n) {
            this.enemies[n].vJump();
        }

        public void vEnemyKilled() {
            ++this.iEnemiesKilled;
        }

        public void vEnemyLifeLost(int e, boolean b) {
            this.enemies[e].vLifeLost(b);
        }

        public void vEnemiesReset() {
            int i = 0;
            while (i < this.enemies.length) {
                this.enemies[i].vReset();
                ++i;
            }
            this.iTickLastRandomTimedEvent = jozsefatomick.this.millis();
        }

        public void vDisplay(int hor) {
            int i = 0;
            while (i < this.tiles.length) {
                this.tiles[i].vDisplay(hor);
                ++i;
            }
            i = 0;
            while (i < this.particles.length) {
                this.particles[i].vDisplay(hor);
                ++i;
            }
            i = 0;
            while (i < this.enemies.length) {
                this.enemies[i].vDisplay(hor);
                ++i;
            }
        }

        public void vExplosion(int x, int y, int c) {
            int iNumberParticles = 8;
            int i = 0;
            while (i < this.particles.length) {
                if (!this.particles[i].bIsOn()) {
                    this.particles[i].vInit(x, y, c);
                    --iNumberParticles;
                }
                if (iNumberParticles == 0) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.particles.length) {
                this.particles[PApplet.parseInt((float)jozsefatomick.this.random(this.particles.length))].vInit(x, y, c);
                ++i;
            }
        }

        public void vInitTiles(int levelNumber) {
            this.pTileSheet = jozsefatomick.this.loadImage(jozsefatomick.this.sTilesheet);
            int i = 0;
            while (i < this.tiles.length) {
                this.tiles[i] = new Tile(i);
                ++i;
            }
            byte bTilesInTileSheetHorizontal = PApplet.parseByte((int)(this.pTileSheet.width / jozsefatomick.this.iTileSize));
            String[] lines = jozsefatomick.this.loadStrings("level" + levelNumber + ".txt");
            this.iTileNumberHorizontal = lines[0].length();
            this.iTileNumberVertical = lines.length;
            int currentTile = 0;
            int j = 0;
            while (j < lines.length) {
                int i2 = 0;
                while (i2 < lines[j].length()) {
                    int iTileNumber = lines[j].charAt(i2);
                    byte bColumn = PApplet.parseByte((int)((iTileNumber -= 46) % bTilesInTileSheetHorizontal));
                    byte bRow = PApplet.parseByte((int)(iTileNumber / bTilesInTileSheetHorizontal));
                    this.tiles[currentTile].vAdd(iTileNumber, i2 * jozsefatomick.this.iTileSize, j * jozsefatomick.this.iTileSize, this.pTileSheet.get(bColumn * jozsefatomick.this.iTileSize, bRow * jozsefatomick.this.iTileSize, jozsefatomick.this.iTileSize, jozsefatomick.this.iTileSize));
                    ++currentTile;
                    ++i2;
                }
                ++j;
            }
            this.iRodsCollected = 0;
            this.iEnemiesKilled = 0;
            this.iTicksLevelStart = jozsefatomick.this.millis();
        }

        public void vRodCollected() {
            ++this.iRodsCollected;
            if (jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetRodsCollected() < jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetRodsPerLevel()) {
                jozsefatomick.this.vAudioPlay(8);
            } else {
                jozsefatomick.this.vAudioPlay(9);
            }
        }

        public void vTicksLevelDurationTrigger() {
            this.iTicksLevelDuration = this.iGetTicksLevelDuration();
        }

        public void vUpdate() {
            int iDelta = jozsefatomick.this.millis() - this.iTickLastRandomTimedEvent;
            if (iDelta >= jozsefatomick.this.iTicksTimedEvent) {
                this.iTickLastRandomTimedEvent += iDelta;
                if (jozsefatomick.this.random(1.0f) < jozsefatomick.this.fTimedEventChance) {
                    int iSoundEffect = 19 + PApplet.parseInt((float)(jozsefatomick.this.random(1.0f) * 4.0f));
                    jozsefatomick.this.vAudioPlay(iSoundEffect);
                }
            }
            int i = 0;
            while (i < this.enemies.length) {
                this.enemies[i].vUpdate();
                ++i;
            }
            i = 0;
            while (i < this.particles.length) {
                this.particles[i].vUpdate();
                ++i;
            }
        }
    }

    class Particle {
        int iId = -1;
        float fPosX = -1.0f;
        float fPosY = -1.0f;
        int iSize = 3;
        float fSpeedX = 0.0f;
        float fSpeedY = 0.0f;
        boolean bIsOn = false;
        boolean bMoving = false;
        int iTicksLast = 0;
        int cColor = 0;

        Particle(int n) {
            this.iId = n;
        }

        public boolean bIsOn() {
            return this.bIsOn;
        }

        public void vDisplay(int hor) {
            if (!this.bIsOn) {
                return;
            }
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.noStroke();
            jozsefatomick.this.pBackground.fill(this.cColor);
            jozsefatomick.this.pBackground.rect(this.fPosX - (float)hor, this.fPosY, (float)this.iSize, (float)this.iSize);
            jozsefatomick.this.pBackground.endDraw();
        }

        public void vInit(int x, int y, int c) {
            this.fPosX = (float)x - (float)this.iSize * 0.5f;
            this.fPosY = (float)y - (float)this.iSize * 0.5f;
            this.cColor = c;
            this.fSpeedX = jozsefatomick.this.random(2.0f) - 1.0f;
            this.fSpeedY = -4.0f + jozsefatomick.this.random(-4.0f);
            this.bIsOn = true;
            this.bMoving = true;
            this.iTicksLast = jozsefatomick.this.millis();
        }

        public void vUpdate() {
            if (!this.bIsOn) {
                return;
            }
            if (!this.bMoving) {
                return;
            }
            if (this.fPosY >= (float)jozsefatomick.this.iScreenHeight) {
                this.bIsOn = false;
                return;
            }
            int iTicksDelta = jozsefatomick.this.millis() - this.iTicksLast;
            this.iTicksLast += iTicksDelta;
            this.fPosX += (float)iTicksDelta * this.fSpeedX * 0.1f;
            this.fPosY += (float)iTicksDelta * this.fSpeedY * 0.1f;
            this.fSpeedY += (float)iTicksDelta * jozsefatomick.this.fGravityFactor;
            if (jozsefatomick.this.sScreen == screen.GAME) {
                if (this.fSpeedY > 0.0f) {
                    int iTileBelow = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)-1), PApplet.parseInt((float)(this.fPosX + (float)this.iSize * 0.5f)), PApplet.parseInt((float)(this.fPosY + (float)this.iSize)), direction.BELOW);
                    if (iTileBelow != -1) {
                        this.fPosY = iTileBelow + jozsefatomick.this.iTileSize - this.iSize;
                        this.bMoving = false;
                    }
                } else {
                    int iTileAbove = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(PApplet.parseByte((int)-1), PApplet.parseInt((float)(this.fPosX + (float)this.iSize * 0.5f)), PApplet.parseInt((float)(this.fPosY + (float)this.iSize)), direction.ABOVE);
                    if (iTileAbove != -1) {
                        this.fPosY = iTileAbove;
                    }
                }
            }
        }
    }

    class Player {
        byte bId = (byte)-1;
        float fPosX = 0.0f;
        float fPosY = 0.0f;
        int iWidth;
        boolean bStandsOnGround;
        char cKeyUp;
        char cKeyDown;
        char cKeyLeft;
        char cKeyRight;
        char cKeyFire;
        boolean bKeyIsPressedUp;
        boolean bKeyIsPressedDown;
        boolean bKeyIsPressedLeft;
        boolean bKeyIsPressedRight;
        boolean bFacingRight;
        PImage graphics;
        float fSpeed;
        float fMovementVert;
        float fMovementVertMax;
        int iTicksLast;
        byte bOverlapHor;
        byte bLives;
        int iScore;
        int iAnimationTicksLast;
        byte bAnimationFrameX;
        byte bAnimationFrameY;
        int iAnimationTicksPerFrame;
        float fSpeedJumpInitial;
        PImage tilesheetOverlay;

        Player(byte n) {
            this.iWidth = jozsefatomick.this.iTileSize;
            this.bStandsOnGround = false;
            this.cKeyUp = (char)32;
            this.cKeyDown = (char)32;
            this.cKeyLeft = (char)32;
            this.cKeyRight = (char)32;
            this.cKeyFire = (char)32;
            this.bKeyIsPressedUp = false;
            this.bKeyIsPressedDown = false;
            this.bKeyIsPressedLeft = false;
            this.bKeyIsPressedRight = false;
            this.bFacingRight = true;
            this.graphics = null;
            this.fSpeed = 0.29f;
            this.fMovementVert = 0.0f;
            this.fMovementVertMax = 9.0f;
            this.iTicksLast = 0;
            this.bOverlapHor = (byte)9;
            this.bLives = 0;
            this.iScore = 0;
            this.iAnimationTicksLast = 0;
            this.bAnimationFrameX = 0;
            this.bAnimationFrameY = 0;
            this.iAnimationTicksPerFrame = 100;
            this.fSpeedJumpInitial = -18.0f;
            this.tilesheetOverlay = null;
            this.bId = n;
            this.graphics = jozsefatomick.this.loadImage(jozsefatomick.this.sPlayerSpritesheet);
            this.tilesheetOverlay = jozsefatomick.this.loadImage(jozsefatomick.this.sTilesheetOverlay);
            this.vResetAll();
        }

        public boolean bGetStanding() {
            return this.bStandsOnGround;
        }

        public int cGetColour() {
            return jozsefatomick.this.color(206, 76, 1);
        }

        public char cGetKeyUp() {
            return this.cKeyUp;
        }

        public char cGetKeyDown() {
            return this.cKeyDown;
        }

        public char cGetKeyLeft() {
            return this.cKeyLeft;
        }

        public char cGetKeyRight() {
            return this.cKeyRight;
        }

        public char cGetKeyFire() {
            return this.cKeyFire;
        }

        public float fGetMovementVert() {
            return this.fMovementVert;
        }

        public int iGetPosX() {
            return PApplet.parseInt((float)this.fPosX);
        }

        public int iGetPosY() {
            return PApplet.parseInt((float)this.fPosY);
        }

        public int iGetPosXCentre() {
            return PApplet.parseInt((float)this.fPosX) + jozsefatomick.this.iTileSizeHalf;
        }

        public int iGetPosYCentre() {
            return PApplet.parseInt((float)this.fPosY) + jozsefatomick.this.iTileSizeHalf;
        }

        public int iGetScore() {
            return this.iScore;
        }

        public void vAssignKeys(char u, char d, char l, char r, char f) {
            this.cKeyUp = u;
            this.cKeyDown = d;
            this.cKeyLeft = l;
            this.cKeyRight = r;
            this.cKeyFire = f;
        }

        public void vDisplay(int hor) {
            jozsefatomick.this.pBackground.beginDraw();
            int i = 0;
            while (i < this.bLives) {
                PImage livesPic = this.graphics.get(0, 0, jozsefatomick.this.iTileSize, jozsefatomick.this.iTileSize);
                jozsefatomick.this.pBackground.image(livesPic, (float)(4 + i * 10 + 100 * this.bId), 4.0f, (float)jozsefatomick.this.iTileSizeHalf, (float)jozsefatomick.this.iTileSizeHalf);
                ++i;
            }
            PImage rodPic = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].pGetTileFromTilesheet(8, 4);
            jozsefatomick.this.pBackground.image(rodPic, (float)(4 + 100 * this.bId), 24.0f, (float)jozsefatomick.this.iTileSizeHalf, (float)jozsefatomick.this.iTileSizeHalf);
            jozsefatomick.this.pBackground.fill(0, 120.0f);
            jozsefatomick.this.pBackground.endDraw();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, String.valueOf(jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetRodsCollected()) + "/" + jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetRodsPerLevel(), 22 + 100 * this.bId, 36);
            PImage scorePic = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].pGetTileFromTilesheet(9, 3);
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.image(scorePic, (float)(4 + 100 * this.bId), 44.0f, (float)jozsefatomick.this.iTileSizeHalf, (float)jozsefatomick.this.iTileSizeHalf);
            jozsefatomick.this.pBackground.endDraw();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "" + this.iScore, 22 + 100 * this.bId, 56);
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.image(this.tilesheetOverlay, (float)(4 + 100 * this.bId), 64.0f, (float)jozsefatomick.this.iTileSizeHalf, (float)jozsefatomick.this.iTileSizeHalf);
            jozsefatomick.this.pBackground.endDraw();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, jozsefatomick.nf((float)((float)jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetTicksLevelDuration() * 0.001f), (int)0, (int)1), 22 + 100 * this.bId, 76);
            if (this.bId == 0) {
                hor = 0;
            }
            this.bAnimationFrameY = this.bFacingRight ? (byte)0 : 1;
            if (this.bStandsOnGround) {
                int iDelta;
                if (!this.bKeyIsPressedLeft && !this.bKeyIsPressedRight) {
                    if (this.bAnimationFrameX >= 4) {
                        this.bAnimationFrameX = 0;
                        this.iAnimationTicksLast = jozsefatomick.this.millis();
                    }
                    if ((iDelta = jozsefatomick.this.millis() - this.iAnimationTicksLast) > this.iAnimationTicksPerFrame) {
                        this.bAnimationFrameX = (byte)(this.bAnimationFrameX + 1);
                        if (this.bAnimationFrameX >= 4) {
                            this.bAnimationFrameX = 0;
                        }
                        this.iAnimationTicksLast += iDelta;
                    }
                } else {
                    if (this.bAnimationFrameX < 4 || this.bAnimationFrameX >= 8) {
                        this.bAnimationFrameX = (byte)4;
                        this.iAnimationTicksLast = jozsefatomick.this.millis();
                    }
                    if ((iDelta = jozsefatomick.this.millis() - this.iAnimationTicksLast) > this.iAnimationTicksPerFrame) {
                        this.bAnimationFrameX = (byte)(this.bAnimationFrameX + 1);
                        if (this.bAnimationFrameX >= 8) {
                            jozsefatomick.this.vAudioPlay(0);
                            this.bAnimationFrameX = (byte)4;
                        }
                        this.iAnimationTicksLast += iDelta;
                    }
                }
            } else {
                this.bAnimationFrameX = !this.bKeyIsPressedLeft && !this.bKeyIsPressedRight ? (byte)8 : (byte)7;
            }
            PImage framePic = this.graphics.get(jozsefatomick.this.iTileSize * this.bAnimationFrameX, jozsefatomick.this.iTileSize * this.bAnimationFrameY, jozsefatomick.this.iTileSize, jozsefatomick.this.iTileSize);
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.image(framePic, (float)(jozsefatomick.this.iScreenWidthHalf - hor), this.fPosY);
            jozsefatomick.this.pBackground.endDraw();
        }

        public void vFire() {
        }

        public void vJump() {
            if (this.bStandsOnGround) {
                jozsefatomick.this.vAudioPlay(2);
                this.bStandsOnGround = false;
                this.fMovementVert = this.fSpeedJumpInitial;
            }
        }

        public void vKeyIsPressed(char c) {
            if (c == this.cKeyRight) {
                this.bFacingRight = true;
                this.bKeyIsPressedRight = true;
            } else if (c == this.cKeyLeft) {
                this.bKeyIsPressedLeft = true;
                this.bFacingRight = false;
            } else if (c == this.cKeyUp) {
                this.bKeyIsPressedUp = true;
                this.vJump();
            } else if (c == this.cKeyDown) {
                this.bKeyIsPressedDown = true;
            } else if (c == this.cKeyFire) {
                this.vFire();
            }
        }

        public void vKeyIsReleased(char c) {
            if (c == this.cKeyRight) {
                this.bKeyIsPressedRight = false;
            } else if (c == this.cKeyLeft) {
                this.bKeyIsPressedLeft = false;
            } else if (c == this.cKeyUp) {
                this.bKeyIsPressedUp = false;
                if (this.fMovementVert < 0.0f) {
                    this.fMovementVert = 0.0f;
                }
            } else if (c == this.cKeyDown) {
                this.bKeyIsPressedDown = false;
            }
        }

        public void vLifeGained() {
            jozsefatomick.this.vAudioPlay(11);
            this.bLives = (byte)(this.bLives + 1);
        }

        public void vLifeLost(boolean e) {
            jozsefatomick.this.vAudioPlay(7);
            if (e) {
                jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vExplosion(PApplet.parseInt((float)(this.fPosX + (float)jozsefatomick.this.iTileSizeHalf)), PApplet.parseInt((float)(this.fPosY + (float)jozsefatomick.this.iTileSizeHalf)), jozsefatomick.this.color(206, 76, 1));
            }
            this.bLives = (byte)(this.bLives - 1);
            if (this.bLives < 1) {
                jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vTicksLevelDurationTrigger();
                jozsefatomick.this.vGoToScreenGameOver();
                return;
            }
            this.vResetForNextLevel();
        }

        public void vResetAll() {
            this.vResetForNextLevel();
            this.iScore = 0;
            this.bLives = (byte)3;
        }

        public void vResetForNextLevel() {
            this.fPosX = jozsefatomick.this.iTileSize * 2 + this.bId * jozsefatomick.this.iTileSize * 2;
            this.fPosY = jozsefatomick.this.iTileSize;
            this.bKeyIsPressedDown = false;
            this.bKeyIsPressedUp = false;
            this.bKeyIsPressedLeft = false;
            this.bKeyIsPressedRight = false;
            this.bFacingRight = true;
            this.fMovementVert = 0.0f;
            this.iTicksLast = this.iAnimationTicksLast = jozsefatomick.this.millis();
        }

        public void vScoreAdd(int s) {
            this.iScore += s;
        }

        public void vUpdate() {
            int iCollisionEnemyBottom;
            int iTileBelowRight;
            int iTileBelowLeft;
            int iTicksDelta = jozsefatomick.this.millis() - this.iTicksLast;
            this.iTicksLast += iTicksDelta;
            if (this.bStandsOnGround) {
                if (this.bKeyIsPressedLeft) {
                    this.fPosX += (float)iTicksDelta * -this.fSpeed;
                    int iTileLeft = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + this.bOverlapHor, this.iGetPosYCentre(), direction.LEFT);
                    if (iTileLeft != -1) {
                        this.fPosX = iTileLeft - this.bOverlapHor;
                    }
                } else if (this.bKeyIsPressedRight) {
                    this.fPosX += (float)iTicksDelta * this.fSpeed;
                    int iTileRight = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + jozsefatomick.this.iTileSize - 1 - this.bOverlapHor, this.iGetPosYCentre(), direction.RIGHT);
                    if (iTileRight != -1) {
                        this.fPosX = iTileRight + this.bOverlapHor;
                    }
                }
                if ((iTileBelowLeft = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + this.bOverlapHor + 4, this.iGetPosY() + jozsefatomick.this.iTileSize, direction.BELOW)) != -1) {
                    this.fPosY = iTileBelowLeft;
                } else {
                    iTileBelowRight = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + jozsefatomick.this.iTileSize - this.bOverlapHor - 4, this.iGetPosY() + jozsefatomick.this.iTileSize, direction.BELOW);
                    if (iTileBelowRight != -1) {
                        this.fPosY = iTileBelowRight;
                    } else {
                        this.fMovementVert += (float)iTicksDelta * jozsefatomick.this.fGravityFactor;
                        if (this.fMovementVert > this.fMovementVertMax) {
                            this.fMovementVert = this.fMovementVertMax;
                        }
                        this.fPosY += this.fMovementVert;
                        this.bStandsOnGround = false;
                    }
                }
            } else {
                if (this.bKeyIsPressedLeft) {
                    this.fPosX += (float)iTicksDelta * -this.fSpeed;
                    int iTileLeftBottom = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + this.bOverlapHor, this.iGetPosY() + jozsefatomick.this.iTileSize - 1 - jozsefatomick.this.bGrace, direction.LEFT);
                    if (iTileLeftBottom != -1) {
                        this.fPosX = iTileLeftBottom - this.bOverlapHor;
                    } else {
                        int iTileLeftTop = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + this.bOverlapHor, this.iGetPosY(), direction.LEFT);
                        if (iTileLeftTop != -1) {
                            this.fPosX = iTileLeftTop - this.bOverlapHor;
                        }
                    }
                } else if (this.bKeyIsPressedRight) {
                    this.fPosX += (float)iTicksDelta * this.fSpeed;
                    int iTileRightBottom = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + jozsefatomick.this.iTileSize - 1 - this.bOverlapHor, this.iGetPosY() + jozsefatomick.this.iTileSize - 1 - jozsefatomick.this.bGrace, direction.RIGHT);
                    if (iTileRightBottom != -1) {
                        this.fPosX = iTileRightBottom + this.bOverlapHor;
                    } else {
                        int iTileRightTop = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + jozsefatomick.this.iTileSize - 1 - this.bOverlapHor, this.iGetPosY(), direction.RIGHT);
                        if (iTileRightTop != -1) {
                            this.fPosX = iTileRightTop + this.bOverlapHor;
                        }
                    }
                }
                this.fMovementVert += (float)iTicksDelta * jozsefatomick.this.fGravityFactor;
                if (this.fMovementVert > this.fMovementVertMax) {
                    this.fMovementVert = this.fMovementVertMax;
                }
                this.fPosY += this.fMovementVert;
                if (this.fMovementVert < 0.0f) {
                    int iTileAboveLeft = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + this.bOverlapHor + 4, this.iGetPosY(), direction.ABOVE);
                    if (iTileAboveLeft != -1) {
                        this.fPosY = iTileAboveLeft;
                        this.fMovementVert = 0.0f;
                    } else {
                        int iTileAboveRight = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + jozsefatomick.this.iTileSize - this.bOverlapHor - 4, this.iGetPosY(), direction.ABOVE);
                        if (iTileAboveRight != -1) {
                            this.fPosY = iTileAboveRight;
                            this.fMovementVert = 0.0f;
                        }
                    }
                } else {
                    iTileBelowLeft = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + this.bOverlapHor + 4, this.iGetPosY() + jozsefatomick.this.iTileSize, direction.BELOW);
                    if (iTileBelowLeft != -1) {
                        jozsefatomick.this.vAudioPlay(4);
                        this.fPosY = iTileBelowLeft;
                        this.bStandsOnGround = true;
                        this.fMovementVert = 0.0f;
                        if (this.bKeyIsPressedUp) {
                            this.vJump();
                        }
                    } else {
                        iTileBelowRight = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iCollisionCheck(this.bId, this.iGetPosX() + jozsefatomick.this.iTileSize - this.bOverlapHor - 4, this.iGetPosY() + jozsefatomick.this.iTileSize, direction.BELOW);
                        if (iTileBelowRight != -1) {
                            jozsefatomick.this.vAudioPlay(4);
                            this.fPosY = iTileBelowRight;
                            this.bStandsOnGround = true;
                            this.fMovementVert = 0.0f;
                            if (this.bKeyIsPressedUp) {
                                this.vJump();
                            }
                        }
                    }
                }
            }
            if (this.fPosY > (float)jozsefatomick.this.iScreenHeight) {
                this.vLifeLost(false);
            }
            if ((iCollisionEnemyBottom = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyCollisionCheck(this.bId, this.iGetPosXCentre(), this.iGetPosY() + jozsefatomick.this.iTileSize - 1)) != -1) {
                jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vEnemyLifeLost(iCollisionEnemyBottom, true);
                if (this.bKeyIsPressedUp) {
                    this.bStandsOnGround = true;
                    this.vJump();
                }
                this.vScoreAdd(jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyGetPoints(iCollisionEnemyBottom));
                jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vEnemyKilled();
                return;
            }
            int iCollisionEnemyTop = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyCollisionCheck(this.bId, this.iGetPosXCentre(), this.iGetPosY());
            if (iCollisionEnemyTop != -1) {
                this.vLifeLost(true);
                return;
            }
            int iCollisionEnemyLeft = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyCollisionCheck(this.bId, this.iGetPosX(), this.iGetPosYCentre());
            if (iCollisionEnemyLeft != -1) {
                this.vLifeLost(true);
                return;
            }
            int iCollisionEnemyRight = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyCollisionCheck(this.bId, this.iGetPosX() + jozsefatomick.this.iTileSize - 1, this.iGetPosYCentre());
            if (iCollisionEnemyRight != -1) {
                this.vLifeLost(true);
                return;
            }
        }
    }

    class ScreenAbout {
        int iDistanceLeft = 6;
        int iDistanceTop = 12;

        ScreenAbout() {
        }

        public void vDisplay() {
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.fill(0, 40.0f);
            jozsefatomick.this.pBackground.rect(0.0f, 0.0f, (float)jozsefatomick.this.iScreenWidth, (float)jozsefatomick.this.iScreenHeight);
            int iLine = 0;
            int iLineSpread = 8;
            jozsefatomick.this.pBackground.fill(0);
            jozsefatomick.this.pBackground.endDraw();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "J\u00f3zsef Atomick - Super Radioaktivn\u00ed Raketa, edition", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "for English", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Control game by pressing keyboard keys first player", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "WSAD plus Q for fire button, or use four-way control", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "stick. Attack bad enemies by jumping on them.", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Collect the six fuel rods per level to open portal", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "to next level doorway.", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "This game brings you back most popular children's", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "character hero J\u00f3zsef Atomick. Most iconic character", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "from golden-age time media Western gamer must find", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "slightly obscure. In game, there has been very small", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "tiny miniature negligible nuclear accident was", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "caused no doubt by people's enemies, and J\u00f3zsef", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "needs to find and collect back missing nuclear fuel", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "rods before they fall into wrong hands. Also,", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "people's hero in this narrative story saves peace-", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "loving productive peasants who live healthy in", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "countryside. Imperialist saboteurs trying to prevent", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "progress for atomic nuclear power plant built on", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "field what was before green pastures to help econo-", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "mic way ahead. J\u00f3zsef jumps on saboteurs to send", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "back to imperialist border, degenerates needs help", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "too in excellent people's health system, decadent", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Westeners need find work, and too war-mongering", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "industrialists profiteers. For bad times J\u00f3zsef", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "collects some diamond jewellery in case socialist", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "worker paradise is not going to last and to help", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "start new life in decadent capitalist country.", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "This is free game to share all peasants, workers and", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "students and can be friends.", this.iDistanceLeft, this.iDistanceTop + iLineSpread * iLine++);
            jozsefatomick.this.fonty.alignCenter();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Press fire to continue", jozsefatomick.this.iScreenWidthHalf, 253);
            jozsefatomick.this.fonty.alignLeft();
        }

        public void vKeyPressed(char k) {
            if (k == ' ' || k == '\n' || k == '\r' || k == jozsefatomick.this.players[0].cGetKeyFire()) {
                jozsefatomick.this.vAudioPlay(17);
                jozsefatomick.this.sScreen = screen.MENU;
            }
        }
    }

    class ScreenHiscoreEnter {
        byte bSpacingVert = (byte)12;
        int iDistanceLeft = 28;
        int iDistanceTop = 84;
        int iHiscoresEntriesNumber = 10;
        String[] sHiscoreNames;
        int[] iHiscoreScores;
        float[] fHiscoreTimes;
        int[] iHiscoreLevels;
        char[] cInput;
        byte bHiscoreIndex = 0;
        byte bNameLength = (byte)4;
        int iLetterLow = 64;
        int iLetterHigh = 90;
        int iVertPosEnter = 0;
        byte bEntryLine = 0;
        String sNameLastTime = "";

        ScreenHiscoreEnter() {
            this.sHiscoreNames = new String[this.iHiscoresEntriesNumber];
            this.iHiscoreScores = new int[this.iHiscoresEntriesNumber];
            this.fHiscoreTimes = new float[this.iHiscoresEntriesNumber];
            this.iHiscoreLevels = new int[this.iHiscoresEntriesNumber];
            this.cInput = new char[this.bNameLength];
        }

        public void vDisplay() {
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.noStroke();
            jozsefatomick.this.pBackground.fill(0, 40.0f);
            jozsefatomick.this.pBackground.rect(0.0f, 0.0f, (float)jozsefatomick.this.iScreenWidth, (float)jozsefatomick.this.iScreenHeight);
            jozsefatomick.this.pBackground.fill(0);
            jozsefatomick.this.pBackground.endDraw();
            jozsefatomick.this.fonty.alignCenter();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Hiscore List", jozsefatomick.this.iScreenWidthHalf, this.iDistanceTop - jozsefatomick.this.iTileSize);
            jozsefatomick.this.fonty.alignLeft();
            int i = 0;
            while (i < this.iHiscoresEntriesNumber) {
                jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, jozsefatomick.this.sPadWithBlanks(i + 1, 2) + "  " + this.sHiscoreNames[i] + " " + jozsefatomick.this.sPadWithBlanks(this.iHiscoreScores[i], 5) + " points " + jozsefatomick.this.sPadWithBlanks(this.fHiscoreTimes[i], 4) + " secs  level " + jozsefatomick.this.sPadWithBlanks(this.iHiscoreLevels[i], 2), this.iDistanceLeft, this.iDistanceTop + this.bSpacingVert * i);
                ++i;
            }
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.noStroke();
            jozsefatomick.this.pBackground.fill(220.0f, 180.0f, 60.0f);
            jozsefatomick.this.pBackground.rect((float)(this.iDistanceLeft + 24 + 6 * this.bHiscoreIndex - 1), (float)(this.iDistanceTop + this.iVertPosEnter - 9 + 1), 7.0f, 9.0f);
            jozsefatomick.this.pBackground.fill(0);
            jozsefatomick.this.pBackground.endDraw();
            i = 0;
            while (i < this.cInput.length) {
                if (this.cInput[i] == '@') {
                    jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, " ", this.iDistanceLeft + 24 + 6 * i, this.iDistanceTop + this.iVertPosEnter);
                } else {
                    jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "" + this.cInput[i], this.iDistanceLeft + 24 + 6 * i, this.iDistanceTop + this.iVertPosEnter);
                }
                ++i;
            }
            jozsefatomick.this.fonty.alignCenter();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Enter name and press fire to finish", jozsefatomick.this.iScreenWidthHalf, 212);
            jozsefatomick.this.fonty.alignLeft();
        }

        public void vInit() {
            int i;
            block10: {
                this.sHiscoreNames = jozsefatomick.this.loadStrings("highscorenames.txt");
                String[] lines = jozsefatomick.this.loadStrings("highscorescores.txt");
                i = 0;
                while (i < lines.length) {
                    this.iHiscoreScores[i] = PApplet.parseInt((String)lines[i]);
                    ++i;
                }
                lines = jozsefatomick.this.loadStrings("highscoretimes.txt");
                i = 0;
                while (i < lines.length) {
                    this.fHiscoreTimes[i] = PApplet.parseFloat((String)lines[i]);
                    ++i;
                }
                lines = jozsefatomick.this.loadStrings("highscorelevels.txt");
                i = 0;
                while (i < lines.length) {
                    this.iHiscoreLevels[i] = PApplet.parseInt((String)lines[i]);
                    ++i;
                }
                this.bEntryLine = PApplet.parseByte((int)(this.iHiscoresEntriesNumber - 1));
                while (jozsefatomick.this.players[0].iGetScore() > this.iHiscoreScores[this.bEntryLine] || jozsefatomick.this.players[0].iGetScore() == this.iHiscoreScores[this.bEntryLine] && (float)jozsefatomick.this.iGetTicksLevelDurationFinalTotal() * 0.001f < this.fHiscoreTimes[this.bEntryLine]) {
                    if (this.bEntryLine == 0) {
                        jozsefatomick.println((String)"we are top");
                        break block10;
                    }
                    this.bEntryLine = (byte)(this.bEntryLine - 1);
                }
                this.bEntryLine = (byte)(this.bEntryLine + 1);
            }
            i = this.iHiscoresEntriesNumber - 1;
            while (i > this.bEntryLine) {
                this.sHiscoreNames[i] = this.sHiscoreNames[i - 1];
                this.iHiscoreScores[i] = this.iHiscoreScores[i - 1];
                this.fHiscoreTimes[i] = this.fHiscoreTimes[i - 1];
                this.iHiscoreLevels[i] = this.iHiscoreLevels[i - 1];
                --i;
            }
            this.sHiscoreNames[this.bEntryLine] = "    ";
            this.iHiscoreScores[this.bEntryLine] = jozsefatomick.this.players[0].iGetScore();
            this.fHiscoreTimes[this.bEntryLine] = PApplet.parseFloat((String)jozsefatomick.nf((float)((float)jozsefatomick.this.iGetTicksLevelDurationFinalTotal() * 0.001f), (int)0, (int)1));
            this.iHiscoreLevels[this.bEntryLine] = jozsefatomick.this.inLevelCurrentSavedForHighscoreEntry;
            if (!this.sNameLastTime.equals("")) {
                i = 0;
                while (i < this.cInput.length) {
                    this.cInput[i] = this.sNameLastTime.charAt(i) == ' ' ? PApplet.parseChar((int)this.iLetterLow) : this.sNameLastTime.charAt(i);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.cInput.length) {
                    this.cInput[i] = PApplet.parseChar((int)this.iLetterLow);
                    ++i;
                }
            }
            this.bHiscoreIndex = 0;
            this.iVertPosEnter = this.bEntryLine * this.bSpacingVert;
            jozsefatomick.this.vExplosion(this.iDistanceLeft + 24 + 6 * this.bHiscoreIndex - 1 + 4, this.iDistanceTop + this.iVertPosEnter - 9 + 1 + 4, jozsefatomick.this.color(220, 180, 60));
        }

        public void vKeyPressed(char k) {
            if (k == ' ' || k == '\n' || k == '\r' || k == jozsefatomick.this.players[0].cGetKeyFire()) {
                this.vKeySelect();
            } else if (k == jozsefatomick.this.players[0].cGetKeyUp()) {
                this.vKeyUp();
            } else if (k == jozsefatomick.this.players[0].cGetKeyDown()) {
                this.vKeyDown();
            } else if (k == jozsefatomick.this.players[0].cGetKeyLeft()) {
                this.vKeyLeft();
            } else if (k == jozsefatomick.this.players[0].cGetKeyRight()) {
                this.vKeyRight();
            }
        }

        public void vKeyUp() {
            this.cInput[this.bHiscoreIndex] = this.cInput[this.bHiscoreIndex] == this.iLetterHigh ? PApplet.parseChar((int)this.iLetterLow) : PApplet.parseChar((int)(this.cInput[this.bHiscoreIndex] + '\u0001'));
        }

        public void vKeyDown() {
            this.cInput[this.bHiscoreIndex] = this.cInput[this.bHiscoreIndex] == this.iLetterLow ? PApplet.parseChar((int)this.iLetterHigh) : PApplet.parseChar((int)(this.cInput[this.bHiscoreIndex] - '\u0001'));
        }

        public void vKeyLeft() {
            this.bHiscoreIndex = (byte)(this.bHiscoreIndex - 1);
            if (this.bHiscoreIndex < 0) {
                this.bHiscoreIndex = 0;
            }
        }

        public void vKeyRight() {
            this.bHiscoreIndex = (byte)(this.bHiscoreIndex + 1);
            if (this.bHiscoreIndex >= this.bNameLength) {
                this.bHiscoreIndex = PApplet.parseByte((int)(this.bNameLength - 1));
            }
        }

        public void vKeySelect() {
            jozsefatomick.this.vExplosion(this.iDistanceLeft + 24 + 6 * this.bHiscoreIndex - 1 + 4, this.iDistanceTop + this.iVertPosEnter - 9 + 1 + 4, jozsefatomick.this.color(220, 180, 60));
            this.vSave();
        }

        public void vSave() {
            this.sHiscoreNames[this.bEntryLine] = "";
            int i = 0;
            while (i < this.cInput.length) {
                if (this.cInput[i] == this.iLetterLow) {
                    this.cInput[i] = 32;
                }
                byte by = this.bEntryLine;
                this.sHiscoreNames[by] = String.valueOf(this.sHiscoreNames[by]) + this.cInput[i];
                ++i;
            }
            this.sNameLastTime = this.sHiscoreNames[this.bEntryLine];
            jozsefatomick.this.saveStrings("data/highscorenames.txt", this.sHiscoreNames);
            String[] lines = new String[this.iHiscoreScores.length];
            int i2 = 0;
            while (i2 < lines.length) {
                lines[i2] = jozsefatomick.str((int)this.iHiscoreScores[i2]);
                ++i2;
            }
            jozsefatomick.this.saveStrings("data/highscorescores.txt", lines);
            lines = new String[this.fHiscoreTimes.length];
            i2 = 0;
            while (i2 < lines.length) {
                lines[i2] = jozsefatomick.str((float)this.fHiscoreTimes[i2]);
                ++i2;
            }
            jozsefatomick.this.saveStrings("data/highscoretimes.txt", lines);
            lines = new String[this.iHiscoreLevels.length];
            i2 = 0;
            while (i2 < lines.length) {
                lines[i2] = jozsefatomick.str((int)this.iHiscoreLevels[i2]);
                ++i2;
            }
            jozsefatomick.this.saveStrings("data/highscorelevels.txt", lines);
            jozsefatomick.this.players[0].vResetAll();
            jozsefatomick.this.vGoToScreenHiscoreShow();
        }
    }

    class ScreenHiscoreShow {
        byte bSpacingVert = (byte)12;
        int iDistanceLeft = 28;
        int iDistanceTop = 84;
        int iHiscoresEntriesNumber = 10;
        String[] sHiscoreNames = new String[this.iHiscoresEntriesNumber];
        int[] iHiscoreScores = new int[this.iHiscoresEntriesNumber];
        float[] fHiscoreTimes = new float[this.iHiscoresEntriesNumber];
        int[] iHiscoreLevels = new int[this.iHiscoresEntriesNumber];

        ScreenHiscoreShow() {
        }

        public int iGetScoreLowestHiscore() {
            return this.iHiscoreScores[9];
        }

        public float fGetScoreLowestTime() {
            return this.fHiscoreTimes[9];
        }

        public void vDisplay() {
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.noStroke();
            jozsefatomick.this.pBackground.fill(0, 40.0f);
            jozsefatomick.this.pBackground.rect(0.0f, 0.0f, (float)jozsefatomick.this.iScreenWidth, (float)jozsefatomick.this.iScreenHeight);
            jozsefatomick.this.pBackground.fill(0);
            jozsefatomick.this.pBackground.endDraw();
            jozsefatomick.this.fonty.alignCenter();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Hiscore List", jozsefatomick.this.iScreenWidthHalf, this.iDistanceTop - jozsefatomick.this.iTileSize);
            jozsefatomick.this.fonty.alignLeft();
            int i = 0;
            while (i < this.iHiscoresEntriesNumber) {
                jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, jozsefatomick.this.sPadWithBlanks(i + 1, 2) + "  " + this.sHiscoreNames[i] + " " + jozsefatomick.this.sPadWithBlanks(this.iHiscoreScores[i], 5) + " points " + jozsefatomick.this.sPadWithBlanks(this.fHiscoreTimes[i], 4) + " secs  level " + jozsefatomick.this.sPadWithBlanks(this.iHiscoreLevels[i], 2), this.iDistanceLeft, this.iDistanceTop + this.bSpacingVert * i);
                ++i;
            }
            jozsefatomick.this.fonty.alignCenter();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Press fire to continue", jozsefatomick.this.iScreenWidthHalf, 212);
            jozsefatomick.this.fonty.alignLeft();
        }

        public void vInit() {
            this.sHiscoreNames = jozsefatomick.this.loadStrings("highscorenames.txt");
            String[] lines = jozsefatomick.this.loadStrings("highscorescores.txt");
            int i = 0;
            while (i < lines.length) {
                this.iHiscoreScores[i] = PApplet.parseInt((String)lines[i]);
                ++i;
            }
            lines = jozsefatomick.this.loadStrings("highscoretimes.txt");
            i = 0;
            while (i < lines.length) {
                this.fHiscoreTimes[i] = PApplet.parseFloat((String)lines[i]);
                ++i;
            }
            lines = jozsefatomick.this.loadStrings("highscorelevels.txt");
            i = 0;
            while (i < lines.length) {
                this.iHiscoreLevels[i] = PApplet.parseInt((String)lines[i]);
                ++i;
            }
        }

        public void vKeyPressed(char k) {
            if (k == ' ' || k == '\n' || k == '\r' || k == jozsefatomick.this.players[0].cGetKeyFire()) {
                jozsefatomick.this.vGoToScreenMenu();
            }
        }
    }

    class ScreenMenu {
        byte bItemSelected = 0;
        byte bItemNumber = (byte)4;
        byte bSpacingVert;
        int iDistanceLeft;
        int iDistanceTop;
        PImage graphics;

        ScreenMenu() {
            this.bSpacingVert = PApplet.parseByte((int)jozsefatomick.this.iTileSize);
            this.iDistanceLeft = 100;
            this.iDistanceTop = 148;
            this.graphics = null;
            this.graphics = jozsefatomick.this.loadImage(jozsefatomick.this.sPlayerSpritesheet);
        }

        public void vKeyPressed(char k) {
            if (k == ' ' || k == '\n' || k == '\r' || k == jozsefatomick.this.players[0].cGetKeyFire()) {
                this.vKeySelect();
            } else if (k == jozsefatomick.this.players[0].cGetKeyDown()) {
                this.vKeyDown();
            } else if (k == jozsefatomick.this.players[0].cGetKeyUp()) {
                this.vKeyUp();
            }
        }

        public void vKeyDown() {
            jozsefatomick.this.vAudioPlay(18);
            this.bItemSelected = (byte)(this.bItemSelected + 1);
            if (this.bItemSelected >= this.bItemNumber) {
                this.bItemSelected = 0;
            }
        }

        public void vKeyUp() {
            jozsefatomick.this.vAudioPlay(18);
            this.bItemSelected = (byte)(this.bItemSelected - 1);
            if (this.bItemSelected < 0) {
                this.bItemSelected = PApplet.parseByte((int)(this.bItemNumber - 1));
            }
        }

        public void vKeySelect() {
            jozsefatomick.this.vAudioPlay(17);
            if (this.bItemSelected == 0) {
                int i = 0;
                while (i < jozsefatomick.this.iPlayersNumber) {
                    jozsefatomick.this.players[i].vResetAll();
                    ++i;
                }
                jozsefatomick.this.vGoToScreenGame();
            } else if (this.bItemSelected == 1) {
                this.vToggleAudio();
            } else if (this.bItemSelected == 2) {
                jozsefatomick.this.vGoToScreenHiscoreShow();
            } else if (this.bItemSelected == 3) {
                jozsefatomick.this.vGoToScreenAbout();
            } else {
                jozsefatomick.this.exit();
            }
        }

        public void vDisplay() {
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.noStroke();
            jozsefatomick.this.pBackground.fill(0, 40.0f);
            jozsefatomick.this.pBackground.rect(0.0f, 0.0f, (float)jozsefatomick.this.iScreenWidth, (float)jozsefatomick.this.iScreenHeight);
            jozsefatomick.this.pBackground.image(jozsefatomick.this.pLogo, (float)jozsefatomick.this.iScreenWidth * 0.5f - (float)jozsefatomick.this.pLogo.width * 0.5f + 10.0f, (float)(this.iDistanceTop - 120));
            int iLine = 0;
            jozsefatomick.this.pBackground.fill(0);
            jozsefatomick.this.pBackground.endDraw();
            jozsefatomick.this.fonty.alignLeft();
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Play Game", this.iDistanceLeft + jozsefatomick.this.iTileSize, this.iDistanceTop + this.bSpacingVert * iLine++);
            if (jozsefatomick.this.bAudioIsOn) {
                jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Toggle Audio: On", this.iDistanceLeft + jozsefatomick.this.iTileSize, this.iDistanceTop + this.bSpacingVert * iLine++);
            } else {
                jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Toggle Audio: Off", this.iDistanceLeft + jozsefatomick.this.iTileSize, this.iDistanceTop + this.bSpacingVert * iLine++);
            }
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Hiscores", this.iDistanceLeft + jozsefatomick.this.iTileSize, this.iDistanceTop + this.bSpacingVert * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "About", this.iDistanceLeft + jozsefatomick.this.iTileSize, this.iDistanceTop + this.bSpacingVert * iLine++);
            jozsefatomick.this.fonty.output(jozsefatomick.this.pBackground, "Quit", this.iDistanceLeft + jozsefatomick.this.iTileSize, this.iDistanceTop + this.bSpacingVert * iLine++);
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.image(this.graphics.get(0 * jozsefatomick.this.iTileSize, 0, jozsefatomick.this.iTileSize, jozsefatomick.this.iTileSize), (float)this.iDistanceLeft, (float)(this.iDistanceTop + this.bSpacingVert * this.bItemSelected - 25));
            jozsefatomick.this.pBackground.endDraw();
        }

        public void vToggleAudio() {
            jozsefatomick.this.bAudioIsOn = !jozsefatomick.this.bAudioIsOn;
            jozsefatomick.this.vAudioPlay(17);
        }
    }

    class Sky {
        PImage img = null;

        Sky() {
            this.img = jozsefatomick.this.loadImage("sky3_640x256.png");
        }

        public void vDisplay(int hor) {
            if ((hor = (int)((float)hor * 0.5f)) > this.img.width) {
                hor %= this.img.width;
            }
            jozsefatomick.this.pBackground.beginDraw();
            if (hor >= jozsefatomick.this.iScreenWidth) {
                jozsefatomick.this.pBackground.image(this.img, (float)(-hor + this.img.width), 0.0f);
            }
            jozsefatomick.this.pBackground.image(this.img, (float)(-hor), 0.0f);
            jozsefatomick.this.pBackground.endDraw();
        }
    }

    class Tile {
        int iId = -1;
        float iPosX = 0.0f;
        int iPosY = 0;
        tileType type = tileType.INVISIBLE;
        int iTypeNumber = -1;
        PImage img = null;
        boolean isCollidable = false;
        boolean isShown = false;

        Tile(int n) {
            this.iId = n;
        }

        public int iCollisionCheck(byte b, int x, int y, direction side) {
            if (!this.isShown) {
                return -1;
            }
            if (!this.isCollidable && this.type != tileType.TRAP && this.type != tileType.COLLECTABLE && this.type != tileType.SPECIAL) {
                return -1;
            }
            if (this.isCollidable) {
                if (side == direction.ABOVE) {
                    return this.iGetPositionCollision(direction.ABOVE);
                }
                if (side == direction.RIGHT) {
                    return this.iGetPositionCollision(direction.RIGHT);
                }
                if (side == direction.BELOW) {
                    return this.iGetPositionCollision(direction.BELOW);
                }
                return this.iGetPositionCollision(direction.LEFT);
            }
            if (this.type == tileType.TRAP) {
                if (this.iTypeNumber == 32) {
                    this.isShown = false;
                    int c = 0;
                    c = b >= 0 && b < 10 ? jozsefatomick.this.players[b].cGetColour() : jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].cEnemyGetColour(b - 10);
                    jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vExplosion(PApplet.parseInt((float)(this.iPosX + (float)jozsefatomick.this.iTileSizeHalf)), PApplet.parseInt((float)(this.iPosY + jozsefatomick.this.iTileSizeHalf)), c);
                }
                if (b >= 0 && b < 10) {
                    jozsefatomick.this.players[b].vLifeLost(true);
                } else if (b >= 10) {
                    jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vEnemyLifeLost(b - 10, true);
                }
                return -1;
            }
            if (this.type == tileType.COLLECTABLE) {
                if (this.iTypeNumber >= 44 && this.iTypeNumber < 50) {
                    if (b >= 0 && b < 10) {
                        jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vRodCollected();
                        this.iTypeNumber = 43;
                        this.img = jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].pGetTileFromTilesheet(3, 4);
                    }
                    return -1;
                }
                if (this.iTypeNumber >= 34 && this.iTypeNumber < 40) {
                    if (b >= 0 && b < 10) {
                        jozsefatomick.this.vAudioPlay(10);
                        jozsefatomick.this.players[b].vScoreAdd(jozsefatomick.this.iPointsCollectable);
                        this.isShown = false;
                    }
                    return -1;
                }
                if (this.iTypeNumber == 40 && b >= 0 && b < 10) {
                    jozsefatomick.this.players[b].vLifeGained();
                    this.isShown = false;
                }
            } else if (this.type == tileType.SPECIAL) {
                if (b >= 0 && b < 10) {
                    if (this.iTypeNumber == 71) {
                        if (jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetRodsCollected() >= jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetRodsPerLevel()) {
                            jozsefatomick.this.vLevelUp();
                        }
                    } else if (this.iTypeNumber == 78) {
                        jozsefatomick.this.vLevelUp();
                    }
                } else if (b >= 10) {
                    jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vEnemyLifeLost(b - 10, false);
                    if (jozsefatomick.this.iLevelCurrent + 1 < jozsefatomick.this.iNumberLevels) {
                        jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent + 1].vEnemyAdd(jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iEnemyGetType(b - 10), 64, 32, jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].pGetTileFromTilesheet(2, 7));
                    }
                }
                return -1;
            }
            return -1;
        }

        public boolean bIsCollidable() {
            return this.isCollidable;
        }

        public boolean bIsShown() {
            return this.isShown;
        }

        public int iGetPosX() {
            return PApplet.parseInt((float)this.iPosX);
        }

        public int iGetPosY() {
            return this.iPosY;
        }

        public int iGetPositionCollision(direction d) {
            if (d == direction.ABOVE) {
                return this.iPosY + jozsefatomick.this.iTileSize;
            }
            if (d == direction.RIGHT) {
                return PApplet.parseInt((float)this.iPosX) - jozsefatomick.this.iTileSize;
            }
            if (d == direction.BELOW) {
                return this.iPosY - jozsefatomick.this.iTileSize;
            }
            if (d == direction.LEFT) {
                return PApplet.parseInt((float)this.iPosX) + jozsefatomick.this.iTileSize;
            }
            return -1;
        }

        public void vAdd(int n, int x, int y, PImage p) {
            this.iPosX = x;
            this.iPosY = y;
            this.img = p;
            this.iTypeNumber = n;
            this.type = this.iTypeNumber == 0 ? tileType.INVISIBLE : (this.iTypeNumber < 30 ? tileType.SOLID : (this.iTypeNumber < 34 ? tileType.TRAP : (this.iTypeNumber < 50 ? tileType.COLLECTABLE : (this.iTypeNumber < 70 ? tileType.DECORATION : tileType.SPECIAL))));
            if (this.type == tileType.INVISIBLE) {
                this.isCollidable = false;
                this.isShown = false;
            } else if (this.type == tileType.SOLID) {
                this.isCollidable = true;
                this.isShown = true;
            } else if (this.type == tileType.TRAP) {
                this.isCollidable = false;
                this.isShown = true;
            } else if (this.type == tileType.COLLECTABLE) {
                this.isCollidable = false;
                this.isShown = true;
            } else if (this.type == tileType.DECORATION) {
                this.isCollidable = false;
                this.isShown = true;
            } else if (this.type == tileType.SPECIAL) {
                if (this.iTypeNumber + 46 >= 118 && this.iTypeNumber + 46 < 122) {
                    jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].vEnemyAdd(this.iTypeNumber, x, y, p);
                    this.isShown = false;
                    this.isCollidable = false;
                } else {
                    this.isCollidable = false;
                    this.isShown = true;
                }
            }
        }

        public void vDisplay(int hor) {
            if (!this.isShown) {
                return;
            }
            if (this.iPosX - (float)hor < (float)(-jozsefatomick.this.iTileSize) || this.iPosX - (float)hor > (float)jozsefatomick.this.iScreenWidth) {
                return;
            }
            if (this.iTypeNumber == 71 && jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetRodsCollected() < jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].iGetRodsPerLevel()) {
                jozsefatomick.this.pBackground.beginDraw();
                jozsefatomick.this.pBackground.image(jozsefatomick.this.levels[jozsefatomick.this.iLevelCurrent].pGetTileFromTilesheet(0, 7), this.iPosX - (float)hor, (float)this.iPosY, (float)jozsefatomick.this.iTileSize, (float)jozsefatomick.this.iTileSize);
                jozsefatomick.this.pBackground.endDraw();
                return;
            }
            jozsefatomick.this.pBackground.beginDraw();
            jozsefatomick.this.pBackground.image(this.img, this.iPosX - (float)hor, (float)this.iPosY, (float)jozsefatomick.this.iTileSize, (float)jozsefatomick.this.iTileSize);
            jozsefatomick.this.pBackground.endDraw();
        }
    }

    static enum direction {
        ABOVE,
        RIGHT,
        BELOW,
        LEFT;

    }

    static enum menuItem {
        GAME1P,
        GAME2PCOMP,
        GAME2PCOLL,
        HISCORES,
        SETTINGS,
        ABOUT,
        QUIT;

    }

    static enum screen {
        TITLE,
        MENU,
        GAME,
        LEVELTRANSITION,
        GAMEOVER,
        GAMEWON,
        HISCOREENTER,
        HISCORESHOW,
        ABOUT,
        TRANSITIONIN,
        TRANSITIONOUT;

    }

    static enum tileType {
        INVISIBLE,
        SOLID,
        TRAP,
        COLLECTABLE,
        DECORATION,
        SPECIAL;

    }
}

