/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MAbstractControl;
import org.gamecontrolplus.gui.MClip;
import org.gamecontrolplus.gui.MEditableTextControl;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MHotSpot;
import org.gamecontrolplus.gui.MScrollbar;
import org.gamecontrolplus.gui.MStyledString;
import processing.awt.PGraphicsJava2D;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.MouseEvent;

public class MTextField
extends MEditableTextControl {
    public MTextField(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, f, f2, f3, f4, 0);
    }

    public MTextField(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        super(pApplet, f, f2, f3, f4, n);
        this.children = new LinkedList();
        this.ty = 2.0f;
        this.tx = 2.0f;
        this.tw = this.width - 4.0f;
        this.th = this.height - (float)((this.scrollbarPolicy & 2) != 0 ? 11 : 0);
        this.wrapWidth = Integer.MAX_VALUE;
        this.gpTextDisplayArea = new GeneralPath();
        this.gpTextDisplayArea.moveTo(0.0f, 0.0f);
        this.gpTextDisplayArea.lineTo(0.0f, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, this.th);
        this.gpTextDisplayArea.lineTo(this.tw, 0.0f);
        this.gpTextDisplayArea.closePath();
        this.hotspots = new MHotSpot[]{new MHotSpot.HSrect(1, this.tx, this.ty, this.tw, this.th), new MHotSpot.HSrect(9, 0.0f, 0.0f, this.width, this.height)};
        M4P.pushStyle();
        M4P.showMessages = false;
        this.z = 0;
        if ((this.scrollbarPolicy & 2) != 0) {
            this.hsb = new MScrollbar(pApplet, 0.0f, 0.0f, this.tw, 10.0f);
            this.addControl(this.hsb, this.tx, this.ty + this.th + 2.0f, 0.0f);
            this.hsb.addEventHandler(this, "hsbEventHandler");
            this.hsb.setAutoHide(this.autoHide);
        }
        M4P.popStyle();
        this.setText("");
        this.createEventHandler(M4P.sketchWindow, "handleTextEvents", new Class[]{MEditableTextControl.class, MEvent.class}, new String[]{"textcontrol", "event"});
        this.registeredMethods = 15;
        M4P.registerControl(this);
        this.bufferInvalid = true;
    }

    @Override
    public void setStyledText(MStyledString mStyledString) {
        this.stext = mStyledString.convertToSingleLineText();
        this.stext.getLines(this.buffer.g2);
        if (this.stext.getNbrLines() > 0) {
            this.endTLHI.tli = this.stext.getLines(this.buffer.g2).getFirst();
            this.endTLHI.thi = this.endTLHI.tli.layout.getNextLeftHit(1);
            this.startTLHI.copyFrom(this.endTLHI);
            this.calculateCaretPos(this.endTLHI);
            this.keepCursorInView = true;
        }
        this.pty = 0.0f;
        this.ptx = 0.0f;
        if (this.hsb != null) {
            if (this.stext.getMaxLineLength() < this.tw) {
                this.hsb.setValue(0.0f, 1.0f);
            } else {
                this.hsb.setValue(0.0f, this.tw / this.stext.getMaxLineLength());
            }
        }
        this.bufferInvalid = true;
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.setStyledText(new MStyledString(string, Integer.MAX_VALUE));
    }

    public void appendText(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (this.stext.insertCharacters(this.stext.length(), string) == 0) {
            return;
        }
        LinkedList<MStyledString.TextLayoutInfo> linkedList = this.stext.getLines(this.buffer.g2);
        this.endTLHI.tli = linkedList.getLast();
        this.endTLHI.thi = this.endTLHI.tli.layout.getNextRightHit(this.endTLHI.tli.nbrChars - 1);
        this.startTLHI.copyFrom(this.endTLHI);
        this.calculateCaretPos(this.endTLHI);
        if (this.hsb != null) {
            float f = linkedList.getLast().layout.getVisibleAdvance();
            float f2 = this.stext.getMaxLineLength();
            float f3 = Math.min(1.0f, this.tw / f2);
            if (this.caretX < this.tw) {
                this.hsb.setValue(0.0f, f3);
            } else {
                this.hsb.setValue(f / f2, f3);
            }
            this.keepCursorInView = true;
        }
        this.bufferInvalid = true;
    }

    @Override
    public PGraphics getSnapshot() {
        this.updateBuffer();
        PGraphicsJava2D pGraphicsJava2D = (PGraphicsJava2D)this.winApp.createGraphics(this.buffer.width, this.buffer.height, "processing.awt.PGraphicsJava2D");
        pGraphicsJava2D.beginDraw();
        pGraphicsJava2D.image((PImage)this.buffer, 0.0f, 0.0f);
        if (this.hsb != null) {
            pGraphicsJava2D.pushMatrix();
            pGraphicsJava2D.translate(this.hsb.getX(), this.hsb.getY());
            pGraphicsJava2D.image((PImage)this.hsb.getBuffer(), 0.0f, 0.0f);
            pGraphicsJava2D.popMatrix();
        }
        pGraphicsJava2D.endDraw();
        return pGraphicsJava2D;
    }

    @Override
    public void pre() {
        if (this.keepCursorInView) {
            boolean bl = false;
            float f = this.caretX - this.tw + 2.0f;
            if (this.endTLHI != null) {
                if (this.ptx > this.caretX) {
                    this.ptx -= HORZ_SCROLL_RATE;
                    if (this.ptx < 0.0f) {
                        this.ptx = 0.0f;
                    }
                    bl = true;
                } else if (this.ptx < f) {
                    this.ptx += HORZ_SCROLL_RATE;
                    if (this.ptx > f) {
                        this.ptx = f;
                    }
                    bl = true;
                }
                if (this.ptx > 0.0f && this.endTLHI.tli.layout.getAdvance() - this.ptx < this.tw - 2.0f) {
                    this.ptx = Math.max(0.0f, this.endTLHI.tli.layout.getAdvance() - this.tw - 2.0f);
                    bl = true;
                }
                if (bl && this.hsb != null) {
                    this.hsb.setValue(this.ptx / (this.stext.getMaxLineLength() + 4.0f));
                }
            }
            if (bl) {
                this.bufferInvalid = true;
            } else {
                this.keepCursorInView = false;
            }
        }
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (!(this.visible && this.enabled && this.available)) {
            return;
        }
        this.calcTransformedOrigin(this.winApp.mouseX, this.winApp.mouseY);
        this.ox -= this.tx;
        this.oy -= this.ty;
        this.currSpot = this.whichHotSpot(this.ox, this.oy);
        if (this.currSpot == 1 || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                if (this.currSpot == 1) {
                    if (focusIsWith != this && this.z >= MTextField.focusObjectZ()) {
                        this.keepCursorInView = true;
                        this.takeFocus();
                    }
                    this.dragging = false;
                    if (this.stext == null || this.stext.length() == 0) {
                        this.stext = new MStyledString(" ", this.wrapWidth);
                        this.stext.getLines(this.buffer.g2);
                    }
                    this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                    this.startTLHI = new MStyledString.TextLayoutHitInfo(this.endTLHI);
                    this.calculateCaretPos(this.endTLHI);
                    this.bufferInvalid = true;
                    break;
                }
                if (focusIsWith != this) break;
                this.loseFocus(null);
                break;
            }
            case 2: {
                this.dragging = false;
                this.bufferInvalid = true;
                break;
            }
            case 4: {
                if (focusIsWith != this) break;
                this.keepCursorInView = true;
                this.dragging = true;
                this.endTLHI = this.stext.calculateFromXY(this.buffer.g2, this.ox + this.ptx, this.oy + this.pty);
                this.calculateCaretPos(this.endTLHI);
                this.fireEvent(new Object[]{this, MEvent.SELECTION_CHANGED});
                this.bufferInvalid = true;
            }
        }
    }

    @Override
    protected void keyPressedProcess(int n, char c, boolean bl, boolean bl2) {
        boolean bl3 = true;
        switch (n) {
            case 37: {
                this.moveCaretLeft(this.endTLHI);
                break;
            }
            case 39: {
                this.moveCaretRight(this.endTLHI);
                break;
            }
            case 36: {
                this.moveCaretStartOfLine(this.endTLHI);
                break;
            }
            case 35: {
                this.moveCaretEndOfLine(this.endTLHI);
                break;
            }
            case 65: {
                if (!bl2) break;
                this.moveCaretStartOfLine(this.startTLHI);
                this.moveCaretEndOfLine(this.endTLHI);
                bl = true;
                break;
            }
            case 67: {
                if (bl2) {
                    MClip.copy(this.getSelectedText());
                }
                bl3 = false;
                break;
            }
            case 86: {
                if (!bl2) break;
                String string = MClip.paste();
                string.replaceAll("\n", "");
                if (string.length() <= 0) break;
                if (this.hasSelection()) {
                    this.stext.deleteCharacters(this.pos, this.nbr);
                }
                this.stext.insertCharacters(this.pos, string);
                this.adjust = string.length();
                this.textChanged = true;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        this.calculateCaretPos(this.endTLHI);
        if (bl3) {
            if (!bl) {
                this.startTLHI.copyFrom(this.endTLHI);
            }
            this.bufferInvalid = true;
        }
    }

    @Override
    protected void keyTypedProcess(int n, char c, boolean bl, boolean bl2) {
        char c2 = c;
        if (c2 >= ' ' && c2 < '\u007f') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
            }
            this.stext.insertCharacters(this.pos, "" + c);
            this.adjust = 1;
            this.textChanged = true;
        } else if (c == '\b') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
                this.adjust = 0;
                this.textChanged = true;
            } else if (this.stext.deleteCharacters(this.pos - 1, 1)) {
                this.adjust = -1;
                this.textChanged = true;
            }
        } else if (c == '\u007f') {
            if (this.hasSelection()) {
                this.stext.deleteCharacters(this.pos, this.nbr);
                this.adjust = 0;
                this.textChanged = true;
            } else if (this.stext.deleteCharacters(this.pos, 1)) {
                this.adjust = 0;
                this.textChanged = true;
            }
        } else if (c == '\n' || c == '\r') {
            this.fireEvent(new Object[]{this, MEvent.ENTERED});
            if (this.tabManager != null && this.tabManager.nextControl(this)) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        } else if (c == '\t' && this.tabManager != null) {
            boolean bl3;
            boolean bl4 = bl3 = bl ? this.tabManager.prevControl(this) : this.tabManager.nextControl(this);
            if (bl3) {
                this.startTLHI.copyFrom(this.endTLHI);
                return;
            }
        }
        if (this.stext.length() == 0) {
            this.stext.insertCharacters(0, " ");
            ++this.adjust;
            this.textChanged = true;
        }
    }

    @Override
    protected boolean changeText() {
        if (!super.changeText()) {
            return false;
        }
        this.startTLHI.copyFrom(this.endTLHI);
        return true;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.updateBuffer();
        this.winApp.pushStyle();
        this.winApp.pushMatrix();
        this.winApp.translate(this.cx, this.cy);
        this.winApp.rotate(this.rotAngle);
        this.winApp.pushMatrix();
        this.winApp.translate(-this.halfWidth, -this.halfHeight);
        this.winApp.imageMode(0);
        if (this.alphaLevel < 255) {
            this.winApp.tint(255, (float)this.alphaLevel);
        }
        this.winApp.image((PImage)this.buffer, 0.0f, 0.0f);
        if (focusIsWith == this && this.showCaret && this.endTLHI.tli != null) {
            Object object = this.endTLHI.tli.layout.getCaretInfo(this.endTLHI.thi);
            float f = -this.ptx + object[0];
            float f2 = -this.pty + this.endTLHI.tli.yPosInPara;
            float f3 = f2 - object[3] + object[5];
            if (f >= 0.0f && f <= this.tw && f2 >= 0.0f && f3 <= this.th) {
                this.winApp.strokeWeight(1.9f);
                this.winApp.stroke(this.palette[15]);
                this.winApp.line(this.tx + f, this.ty + Math.max(0.0f, f2), this.tx + f, this.ty + Math.min(this.th, f3));
            }
        }
        this.winApp.popMatrix();
        if (this.children != null) {
            for (MAbstractControl mAbstractControl : this.children) {
                mAbstractControl.draw();
            }
        }
        this.winApp.popMatrix();
        this.winApp.popStyle();
    }

    @Override
    protected void updateBuffer() {
        if (this.bufferInvalid) {
            this.buffer.beginDraw();
            Graphics2D graphics2D = this.buffer.g2;
            LinkedList<MStyledString.TextLayoutInfo> linkedList = this.stext.getLines(graphics2D);
            if (linkedList.isEmpty() && this.promptText != null) {
                linkedList = this.promptText.getLines(graphics2D);
            }
            this.bufferInvalid = false;
            MStyledString.TextLayoutHitInfo textLayoutHitInfo = null;
            MStyledString.TextLayoutHitInfo textLayoutHitInfo2 = null;
            if (this.opaque) {
                this.buffer.background(this.palette[6]);
            } else {
                this.buffer.background(this.buffer.color(255, 0));
            }
            this.buffer.translate(this.tx, this.ty);
            this.buffer.noStroke();
            this.buffer.fill(this.palette[7]);
            this.buffer.rect(-1.0f, -1.0f, this.tw + 2.0f, this.th + 2.0f);
            graphics2D.setClip(this.gpTextDisplayArea);
            this.buffer.translate(-this.ptx, -this.pty);
            if (this.hasSelection()) {
                if (this.endTLHI.compareTo(this.startTLHI) == -1) {
                    textLayoutHitInfo = this.endTLHI;
                    textLayoutHitInfo2 = this.startTLHI;
                } else {
                    textLayoutHitInfo = this.startTLHI;
                    textLayoutHitInfo2 = this.endTLHI;
                }
            }
            for (MStyledString.TextLayoutInfo textLayoutInfo : linkedList) {
                TextLayout textLayout = textLayoutInfo.layout;
                this.buffer.translate(0.0f, textLayout.getAscent());
                if (this.hasSelection() && textLayoutInfo.compareTo(textLayoutHitInfo.tli) >= 0 && textLayoutInfo.compareTo(textLayoutHitInfo2.tli) <= 0) {
                    int n = textLayoutHitInfo.thi.getInsertionIndex();
                    int n2 = textLayoutHitInfo2.thi.getInsertionIndex();
                    graphics2D.setColor(this.jpalette[14]);
                    Shape shape = textLayout.getLogicalHighlightShape(n, n2);
                    graphics2D.fill(shape);
                }
                graphics2D.setColor(this.jpalette[2]);
                textLayoutInfo.layout.draw(graphics2D, 0.0f, 0.0f);
                this.buffer.translate(0.0f, textLayout.getDescent() + textLayout.getLeading());
            }
            graphics2D.setClip(null);
            this.buffer.endDraw();
        }
    }
}

