/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus.gui;

import java.util.List;
import org.gamecontrolplus.Configuration;
import org.gamecontrolplus.ControlDevice;
import org.gamecontrolplus.ControlIO;
import org.gamecontrolplus.gui.KConstants;
import org.gamecontrolplus.gui.KSelectEntry;
import org.gamecontrolplus.gui.M4P;
import org.gamecontrolplus.gui.MButton;
import org.gamecontrolplus.gui.MEvent;
import org.gamecontrolplus.gui.MLabel;
import org.gamecontrolplus.gui.MWinData;
import org.gamecontrolplus.gui.MWindow;
import processing.core.PApplet;
import processing.core.PConstants;

public class KSelectDeviceUI
implements PConstants,
KConstants {
    private ControlDevice selectedDevice = null;
    private ControlIO controlIO;
    private MWindow window;
    private int status = 0;

    public KSelectDeviceUI(PApplet pApplet, Configuration configuration) {
        M4P.messagesEnabled(false);
        this.controlIO = ControlIO.getInstance(pApplet);
        this.createGUI(pApplet, this.controlIO.getDevices(), configuration);
    }

    private void createGUI(PApplet pApplet, List<ControlDevice> list, Configuration configuration) {
        String string = "Select device for " + configuration.getUsage();
        this.window = MWindow.getWindow(pApplet, string, 80, 40, 500, 20 * (list.size() + 3), "processing.awt.PGraphicsJava2D");
        MLabel mLabel = new MLabel(this.window, 0.0f, 0.0f, this.window.width, 20.0f);
        mLabel.setText("Control devices");
        mLabel.setOpaque(true);
        mLabel.setTextBold();
        MButton mButton = new MButton(this.window, this.window.width - 105, this.window.height - 28, 100.0f, 24.0f);
        mButton.setText("Exit Game");
        mButton.addEventHandler(this, "exitClick");
        for (int i = 0; i < list.size(); ++i) {
            new KSelectEntry(this, list.get(i), i);
        }
        this.window.addDrawHandler(this, "draw");
    }

    public void exitClick(MButton mButton, MEvent mEvent) {
        this.window.noLoop();
        this.controlIO.setConfiguredDevice(null);
        this.status = 1;
    }

    public synchronized void draw(PApplet pApplet, MWinData mWinData) {
        pApplet.background(255.0f, 255.0f, 220.0f);
        pApplet.stroke(230.0f, 230.0f, 200.0f);
        pApplet.fill(240.0f, 240.0f, 210.0f);
        for (int i = 0; i < pApplet.height; i += 40) {
            pApplet.rect(0.0f, (float)i, (float)pApplet.width, 20.0f);
        }
        pApplet.fill(200.0f, 255.0f, 200.0f);
        pApplet.rect(0.0f, (float)(pApplet.height - 30), (float)pApplet.width, 30.0f);
    }

    void setSelectedDevice(ControlDevice controlDevice) {
        this.window.noLoop();
        this.controlIO.setConfiguredDevice(controlDevice);
        this.status = 2;
    }

    public MWindow getWindow() {
        return this.window;
    }

    public ControlDevice getSelectedDevice() {
        return this.selectedDevice;
    }

    public int status() {
        return this.status;
    }

    public void finishedWith() {
        this.window.noLoop();
        this.window.forceClose();
    }
}

