/*
 * Decompiled with CFR 0.152.
 */
package org.gamecontrolplus;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.gamecontrolplus.Configuration;
import org.gamecontrolplus.ControlDevice;
import org.gamecontrolplus.GCP;
import org.gamecontrolplus.gui.KConstants;
import org.gamecontrolplus.gui.KManageConfiguration;
import processing.core.PApplet;

public class ControlIO
implements Runnable,
KConstants {
    private static ControlIO instance;
    private ControlDevice configuredDevice = null;
    private final ControllerEnvironment environment;
    private final PApplet parent;
    private final List<ControlDevice> devices = new ArrayList<ControlDevice>();
    private int device_filter = -1;
    private final Thread thread;
    private boolean active = true;

    public static ControlIO getInstance(PApplet pApplet) {
        if (instance == null) {
            GCP.announceGCP();
            instance = new ControlIO(pApplet);
        }
        return instance;
    }

    private ControlIO(PApplet pApplet) {
        this.environment = ControllerEnvironment.getEnvironment();
        this.parent = pApplet;
        Controller[] controllerArray = this.environment.getControllers();
        for (int i = 0; i < controllerArray.length; ++i) {
            this.devices.add(new ControlDevice(controllerArray[i], this.parent));
        }
        this.parent.registerMethod("dispose", (Object)this);
        this.parent.registerMethod("pre", (Object)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void dispose() {
        this.active = false;
    }

    public String deviceListToText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "##########################################################################################\n");
        stringBuilder.append(string + "                   Game Control Plus  - available devices\n");
        stringBuilder.append(string + "                   --------------------------------------\n");
        for (int i = 0; i < this.devices.size(); ++i) {
            String string2 = String.valueOf(i + "    ").substring(0, 3);
            stringBuilder.append(string + this.devices.get(i).toListText("  " + string2) + "\n");
        }
        stringBuilder.append(string + "##########################################################################################\n");
        return stringBuilder.toString();
    }

    public String devicesToText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "##########################################################################################\n");
        stringBuilder.append(string + "                   Game Control Plus  - available devices\n");
        stringBuilder.append(string + "                   --------------------------------------\n");
        for (int i = 0; i < this.devices.size(); ++i) {
            stringBuilder.append(this.devices.get(i).toText(string + "  "));
        }
        stringBuilder.append(string + "##########################################################################################\n");
        return stringBuilder.toString();
    }

    public int getNumberOfDevices() {
        return this.devices.size();
    }

    public List<ControlDevice> getDevices() {
        return this.devices;
    }

    public ControlDevice getDevice(int n) {
        if (n >= this.getNumberOfDevices()) {
            throw new RuntimeException("There is no device with the number " + n + ".");
        }
        ControlDevice controlDevice = this.devices.get(n);
        controlDevice.open();
        return controlDevice;
    }

    public ControlDevice getDevice(String string) {
        for (int i = 0; i < this.getNumberOfDevices(); ++i) {
            ControlDevice controlDevice = this.devices.get(i);
            if (!controlDevice.getName().equals(string)) continue;
            controlDevice.open();
            return controlDevice;
        }
        throw new RuntimeException("There is no device with the name " + string + ".");
    }

    public ControlDevice getConfiguredDevice() {
        return this.configuredDevice;
    }

    public void setConfiguredDevice(ControlDevice controlDevice) {
        this.configuredDevice = controlDevice;
    }

    public ControlDevice getMatchedDevice(String string) {
        Configuration configuration = Configuration.makeConfiguration(this.parent, string);
        return this.getMatchedDevice(configuration);
    }

    public ControlIO filter(int n) {
        this.device_filter = n;
        return this;
    }

    public ControlDevice getMatchedDeviceSilent(String string) {
        Configuration configuration = Configuration.makeConfiguration(this.parent, string);
        return this.getMatchedDeviceSilent(configuration);
    }

    public ControlDevice getMatchedDevice(Configuration configuration) {
        int n;
        this.configuredDevice = this.findDevice(configuration);
        if (this.configuredDevice == null && (n = KManageConfiguration.selectDevice(this.parent, configuration)) == 2 && this.configuredDevice != null && (n = KManageConfiguration.configDevice(this.parent, configuration, this.configuredDevice)) == 1) {
            this.configuredDevice = null;
        }
        return this.configuredDevice;
    }

    public ControlDevice getMatchedDeviceSilent(Configuration configuration) {
        this.configuredDevice = this.findDevice(configuration);
        return this.configuredDevice;
    }

    private ControlDevice findDevice(Configuration configuration) {
        ControlDevice controlDevice = null;
        for (ControlDevice controlDevice2 : this.devices) {
            if (!controlDevice2.available || 0 == (controlDevice2.getTypeID() & this.device_filter) || !controlDevice2.matches(configuration)) continue;
            controlDevice = controlDevice2;
            controlDevice.available = false;
            controlDevice = controlDevice2;
            break;
        }
        this.device_filter = -1;
        return controlDevice;
    }

    public void finishedConfig(ControlDevice controlDevice) {
        this.configuredDevice = controlDevice;
    }

    public void pre() {
        for (int i = 0; i < this.devices.size(); ++i) {
            this.devices.get(i).updateRelative();
        }
    }

    @Override
    public void run() {
        while (this.active) {
            for (int i = 0; i < this.devices.size(); ++i) {
                this.devices.get(i).update();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void plug(Object object, String string, int n, int n2, int n3) {
        ControlDevice controlDevice = this.getDevice(n2);
        controlDevice.plug(object, string, n, n3);
    }

    public void plug(String string, int n, int n2, int n3) {
        this.plug((Object)this.parent, string, n, n2, n3);
    }

    public void plug(Object object, String string, int n, String string2, String string3) {
        ControlDevice controlDevice = this.getDevice(string2);
        controlDevice.plug(object, string, n, string3);
    }

    public void plug(String string, int n, String string2, String string3) {
        this.plug((Object)this.parent, string, n, string2, string3);
    }
}

