
//Fonty McFontface - a 7 bit ASCII pixel font class (proportional/variable width)
//dace.de 2022

class Letter
{
  int iId = -1;  //i.e. ASCII value
  boolean[][] letterDots;
  int iLetterWidth = 0;

  Letter(int l, int iDotRows)
  {
    iId = l;
    PImage sheet = loadImage("font.png");
    int iPositionStartLetter = 0;  //find first pixel of letter we look for; we want the l'th letter
    for (int i = 0; i < l; i++)
    {
      while (true)
      {
        iPositionStartLetter++;
        if (sheet.get(iPositionStartLetter, 0) == color(0))
        {
          iPositionStartLetter++;
          break;
        }
      }
    }
    int iLetterWidthCounter = iPositionStartLetter;
    while (sheet.get(iLetterWidthCounter, 0) != color(0)) { iLetterWidth++; iLetterWidthCounter++; }  //how wide is our letter
    letterDots = new boolean[iLetterWidth][iDotRows];
    PImage oneLetter = sheet.get(iPositionStartLetter, 1, iLetterWidth, iDotRows);
    for (int j = 0; j < oneLetter.height; j++)
    {
      for (int i = 0; i < oneLetter.width; i++)
      {
        if (oneLetter.get(i, j) == color(0)) { letterDots[i][j] = false; }
        else                                 { letterDots[i][j] = true; }
      }
    }
  }

  int iDisplay(int x, int y, int h, int iDotRows, float fScale)
  {
    //trying to optimize slightly
    if (h == iDotRows)  //i.e. font is shown in native size
    {
      for (int j = 0; j < iDotRows; j++)
      {
        for (int i = 0; i < iLetterWidth; i++)
        {
          if (letterDots[i][j]) { rect(x + i, (y + j) - h, 1, 1); }
        }
      }
      return iLetterWidth + 1;
    }
    else  //i.e. need to do some scaling
    {
      int w = int(iLetterWidth * fScale);
      for (int j = 0; j < iDotRows; j++)
      {
        for (int i = 0; i < iLetterWidth; i++)
        {
          if (letterDots[i][j]) { rect(x + (i * fScale), (y + (j * fScale)) - h, fScale, fScale); }
        }
      }
      return w + int(fScale);
    }
  }

  int iGetWidth()
  {
    return iLetterWidth +1;
  }
}
