
//Fonty McFontface - a 7 bit ASCII pixel font class (monospaced/fixed width)
//dace.de 2022

class Letter
{
  int iId = -1;  //i.e. ASCII value
  boolean[][] letterDots;

  Letter(int l, int iDotColumns, int iDotRows)
  {
    iId = l;
    letterDots = new boolean[iDotColumns][iDotRows];
    //read png: each letter is 5 pixels wide plus 1 pixel padding
    PImage sheet = loadImage("font.png");
    PImage oneLetter = sheet.get((iId * iDotColumns), 0, iDotColumns, iDotRows);
    for (int j = 0; j < oneLetter.height; j++)
    {
      for (int i = 0; i < oneLetter.width; i++)
      {
        if (oneLetter.get(i, j) == color(0)) { letterDots[i][j] = false; }
        else                                 { letterDots[i][j] = true; }
      }
    }
  }

  void vDisplay(int x, int y, int h, int iDotColumns, int iDotRows, float fScale)
  {
    //trying to optimize slightly
    if (h == iDotRows)  //i.e. font is shown in native size
    {
      for (int j = 0; j < iDotRows; j++)
      {
        for (int i = 0; i < iDotColumns; i++)
        {
          if (letterDots[i][j]) { rect(x + i, (y + j) - h, 1, 1); }
        }
      }
    }
    else  //i.e. need to do some scaling
    {
      for (int j = 0; j < iDotRows; j++)
      {
        for (int i = 0; i < iDotColumns; i++)
        {
          if (letterDots[i][j]) { rect(x + (i * fScale), (y + (j * fScale)) - h, fScale, fScale); }
        }
      }
    }
  }
}
