
//Fonty McFontface - a 7 bit ASCII pixel font class (monospaced/fixed width)
//dace.de 2022

//Usage
//  Fonty fonty = new Fonty();  //declare and construct the fonty object
//  fonty.vInit();  //to init everything
//  fonty.output("Hello", 10, 20);  //for output
//  fonty.height(18);  //for setting the height (the width is set automatically proportionally); it probably looks best when multiples of 9 are used for the height (the native resolution of the font is 9 pixels high)
//  fonty.height(0);  //reset height to native value
//  fonty.alignLeft();  //horizontal alignment, default
//  fonty.alignRight();
//  fonty.alignCenter();
//The text positioned as the default text, baseline left. Fonty uses the current fill colour.
//Bugs: Theoretically, Fonty should save the stroke weight, draw the font without outline, and restore the stroke weight to what was active before; that seems not to work.

class Fonty
{
  int iDotColumns = 6;
  int iDotRows = 9;
  int iBaseline = -2;
  int iBaselineCurrent = iBaseline;
  int iWidth = iDotColumns;
  int iHeight = iDotRows;
  int iLettersNumber = 128;
  Letter[] letters = new Letter[iLettersNumber];
  byte bAlign = 0;  //0 - left, 1 - right, 2 - centre

  //unused so far
  int iDotsNumber = iDotColumns*iDotRows;  //one letter has 5 x 7 dots
  int iGap = 0;  //padding between dots
  float fGap = 0.05;  //gap in %, if any (based on the dot width, which is 1/6 of the letter width, i.e. 0.17 means no dot is visible)

  Fonty()
  { }

  void vInit()
  {
    for (int i = 0; i < letters.length; i++) { letters[i] = new Letter(i, iDotColumns, iDotRows); }
  }

  void vSetAlign(byte a)
  {
    bAlign = a;
  }

  void vSetHeight(int h)
  {
    if (h < 1) { h = iDotRows; }  //if less than 1 use original font height
    iHeight = h;
    float fScale = float(h) / iDotRows;
    iWidth = int(iDotColumns * fScale);
    iBaselineCurrent = int(iBaseline * fScale);
  }

  void vOutput(String s, int x, int y)
  {
    float fStrokeWeightCurrent = getGraphics().strokeWeight;  //save stroke weight
    float fStrokeColourCurrent = getGraphics().strokeColor;  //save stroke colour
    if (iHeight%iDotRows == 0)  //set font height is multiple of native font height
    {
      noStroke();
    }
    else  //a bit of a workaround... otherwise the letters have gaps
    {
      stroke(getGraphics().fillColor);
      strokeWeight(1);
    }

    float fScale = 1;
    if (iHeight != iDotRows) { fScale = float(iHeight) / iDotRows; }
    if (bAlign == 0)
    { }
    else if (bAlign == 1)
    {
      int iStringLengthPixels = s.length() * iDotColumns;
      x -= iStringLengthPixels * fScale;
    }
    else /* if (bAlign == 2) */
    {
      int iStringLengthPixels = s.length() * iDotColumns;
      x -= (iStringLengthPixels * 0.5 * fScale);
    }

    for (int i = 0; i < s.length(); i++)
    {
      char cDisplay = s.charAt(i);
      if ((cDisplay >= 32)  && (cDisplay < iLettersNumber))  //exclude control sequences (0-31) and anything larger than what we can do
      {
        letters[cDisplay].vDisplay(x, y - iBaselineCurrent, iHeight, iDotColumns, iDotRows, fScale);  //display first letter at x y, move iDotColumns, repeat
      }
      x += iWidth;  //if the font was not mono-spaced, Letter.vDisplay() could return the width of the (previous) letter
    }
    
    strokeWeight(fStrokeWeightCurrent);  //restore stroke weight, seems not to work
    stroke(fStrokeColourCurrent);
  }

  //convenience stuff
  void alignLeft()
  {
    vSetAlign(byte(0));
  }
  void alignRight()
  {
    vSetAlign(byte(1));
  }
  void alignCenter()
  {
    vSetAlign(byte(2));
  }
  void height(int h)
  {
    vSetHeight(h);
  }
  void output(String s, float x, float y)
  {
    vOutput(s, int(x), int(y));
  }
  void output(String s, int x, int y)
  {
    vOutput(s, x, y);
  }
}
