/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;
import processing.event.MouseEvent;

public class clicky
extends PApplet {
    int iScreenWidth = 320;
    int iScreenHeight = 536;
    int iLevelHeight = 256;
    int iTileSize = 32;
    int iTileSizeHalf = PApplet.parseInt((float)((float)this.iTileSize * 0.5f));
    int iTileNumber = 640;
    Tile[] tiles = new Tile[this.iTileNumber];
    int iTilesInSheet = 0;
    int iOffsetX = 0;
    int iTileNumberHorizontal = 0;
    int iFileLinesNumber = 0;
    PImage pTileSheet = null;
    PImage pTileDisk = null;
    Button buttonSave = null;
    int iTileClicked = -1;
    int iTicksLast = this.millis();
    int cBg = 0;
    boolean bKeyModifierPressed = false;
    boolean bDragSwitchOn = false;
    boolean bPaintMode = false;
    int iTileClickedInTileSheet = -1;
    boolean bUnsavedChanges = false;
    Fonty fonty = new Fonty();

    public void setup() {
        this.surface.setTitle("Clicky Tiled Level Editor 2.0");
        this.fonty.vInit();
        int i = 0;
        while (i < this.tiles.length) {
            this.tiles[i] = new Tile(i);
            ++i;
        }
        this.pTileSheet = this.loadImage("tilesheet.png");
        this.iTilesInSheet = this.pTileSheet.width / this.iTileSize * (this.pTileSheet.height / this.iTileSize);
        this.cBg = this.color(this.pTileSheet.get(0, 0));
        String[] lines = this.loadStrings("level.txt");
        this.iFileLinesNumber = lines.length;
        this.iTileNumberHorizontal = lines[0].length();
        int currentTile = 0;
        int j = 0;
        while (j < lines.length) {
            int i2 = 0;
            while (i2 < lines[j].length()) {
                int iTileNumber = lines[j].charAt(i2);
                this.tiles[currentTile].vAdd(iTileNumber -= 46, i2, j);
                ++currentTile;
                ++i2;
            }
            ++j;
        }
        this.pTileDisk = this.loadImage("disk2_32x16_trans.png");
        this.buttonSave = new Button(6, this.iScreenHeight - 22, 60, 20, this.pTileDisk.get(0, 0, this.iTileSizeHalf, this.iTileSizeHalf), this.pTileDisk.get(this.iTileSizeHalf, 0, this.iTileSizeHalf, this.iTileSizeHalf));
        this.redrawLevel();
        this.redrawMinimap();
        this.redrawStatusbar();
        this.vMessage("Loaded file level.txt");
        this.fill(255, 40.0f);
        this.fonty.alignRight();
        this.fonty.output("dace.de 2022", this.iScreenWidth - 6, this.iScreenHeight - 9);
    }

    public void vMessage(String s) {
        this.redrawStatusbar();
        this.fill(255);
        this.fonty.alignCenter();
        this.fonty.output(s, (float)this.iScreenWidth * 0.5f, (float)(this.iScreenHeight - 9));
    }

    public void vRectTrans(int x, int y, int w, int h, int s, int c) {
        this.noStroke();
        int j = 0;
        while (j < h / s) {
            int i = 0;
            while (i < w / s) {
                this.fill(c + this.color(20 * ((i + j) % 2)));
                this.rect(x + i * s, y + j * s, s, s);
                ++i;
            }
            ++j;
        }
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 16) {
                this.bKeyModifierPressed = true;
            }
        } else {
            this.buttonSave.vKeyPressed(this.key);
        }
    }

    public void keyReleased() {
        if (this.key == '\uffff' && this.keyCode == 16) {
            this.bKeyModifierPressed = false;
        }
    }

    public void mouseClicked() {
        if (this.mouseY < this.iLevelHeight) {
            if (this.bPaintMode) {
                int i = 0;
                while (i < this.tiles.length) {
                    if (this.tiles[i].bClickCheck(this.mouseX, this.mouseY, this.iOffsetX)) {
                        this.tiles[i].vSetCode(this.iTileClickedInTileSheet);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.tiles.length) {
                    if (this.bKeyModifierPressed) {
                        if (this.tiles[i].bClickCheck(this.mouseX, this.mouseY, this.iOffsetX)) {
                            if (!this.tiles[i].bGetIsClickedOn()) {
                                this.tiles[i].vHilightClickedOn();
                                this.iTileClicked = -2;
                            } else {
                                this.tiles[i].vHilightClickedOff();
                            }
                        }
                    } else if (this.tiles[i].bClickCheck(this.mouseX, this.mouseY, this.iOffsetX)) {
                        if (i != this.iTileClicked) {
                            this.tiles[i].vHilightClickedOn();
                            this.iTileClicked = i;
                        } else {
                            this.tiles[i].vHilightClickedOff();
                            this.iTileClicked = -1;
                        }
                    } else {
                        this.tiles[i].vHilightClickedOff();
                    }
                    ++i;
                }
            }
        } else {
            if (this.buttonSave.bClickCheck(this.mouseX, this.mouseY)) {
                return;
            }
            int iMovedOnMinimapX = this.mouseX;
            int iMovedOnMinimapY = this.mouseY - this.iLevelHeight;
            int iTileInTileSheetColumn = iMovedOnMinimapX / this.iTileSize;
            int iTileInTileSheetRow = iMovedOnMinimapY / this.iTileSize;
            byte bTilesInTileSheetHorizontal = PApplet.parseByte((int)(this.pTileSheet.width / this.iTileSize));
            if (this.iTileClicked >= 0) {
                int iNumberOfClickedTileInTileSheet = iTileInTileSheetColumn + iTileInTileSheetRow * bTilesInTileSheetHorizontal;
                this.tiles[this.iTileClicked].vSetCode(iNumberOfClickedTileInTileSheet);
            } else if (this.iTileClicked == -2) {
                int i = 0;
                while (i < this.tiles.length) {
                    if (this.tiles[i].bGetIsClickedOn()) {
                        int iNumberOfClickedTileInTileSheet = iTileInTileSheetColumn + iTileInTileSheetRow * bTilesInTileSheetHorizontal;
                        this.tiles[i].vSetCode(iNumberOfClickedTileInTileSheet);
                    }
                    ++i;
                }
            } else {
                int iTileClickedInSheetJustNow = iTileInTileSheetColumn + iTileInTileSheetRow * bTilesInTileSheetHorizontal;
                if (iTileClickedInSheetJustNow != this.iTileClickedInTileSheet) {
                    this.bPaintMode = true;
                    this.iTileClickedInTileSheet = iTileClickedInSheetJustNow;
                } else {
                    this.bPaintMode = false;
                    this.iTileClickedInTileSheet = -1;
                }
                this.redrawMinimap();
                return;
            }
        }
        this.redrawLevel();
        this.redrawMinimap();
    }

    public void mouseDragged() {
        if (this.mouseY < this.iLevelHeight) {
            int i;
            if (this.bPaintMode) {
                i = 0;
                while (i < this.tiles.length) {
                    if (this.tiles[i].bClickCheck(this.mouseX, this.mouseY, this.iOffsetX)) {
                        this.tiles[i].vSetCode(this.iTileClickedInTileSheet);
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.tiles.length) {
                    if (this.tiles[i].bClickCheck(this.mouseX, this.mouseY, this.iOffsetX)) {
                        if (this.bDragSwitchOn) {
                            this.tiles[i].vHilightClickedOn();
                            this.iTileClicked = -2;
                        } else {
                            this.tiles[i].vHilightClickedOff();
                            this.iTileClicked = -2;
                        }
                    }
                    ++i;
                }
            }
        }
        if (!this.bPaintMode) {
            int iNumberMarkedTiles = 0;
            int iMarkedTile = -1;
            int i = 0;
            while (i < this.tiles.length) {
                if (this.tiles[i].bGetIsClickedOn()) {
                    ++iNumberMarkedTiles;
                    iMarkedTile = i;
                }
                ++i;
            }
            this.iTileClicked = iNumberMarkedTiles == 0 ? -1 : (iNumberMarkedTiles == 1 ? iMarkedTile : -2);
        }
    }

    public void mouseMoved() {
        if (this.mouseY < this.iLevelHeight) {
            this.redrawMinimap();
        } else if (this.mouseY >= this.iLevelHeight && this.mouseY < this.iLevelHeight + this.pTileSheet.height) {
            int i = 0;
            while (i < this.tiles.length) {
                this.tiles[i].vHilightHoverOff();
                ++i;
            }
            int iMovedOnMinimapX = this.mouseX;
            int iMovedOnMinimapY = this.mouseY - this.iLevelHeight;
            int iTileInTileSheetColumn = iMovedOnMinimapX / this.iTileSize;
            int iTileInTileSheetRow = iMovedOnMinimapY / this.iTileSize;
            this.redrawLevel();
            this.fill(200.0f, 0.0f, 200.0f);
            this.rect(239.0f, 15.0f, 66.0f, 66.0f);
            this.image(this.pTileSheet.get(iTileInTileSheetColumn * this.iTileSize, iTileInTileSheetRow * this.iTileSize, this.iTileSize, this.iTileSize), 240.0f, 16.0f, 64.0f, 64.0f);
            this.redrawMinimap();
            this.noFill();
            this.stroke(255.0f, 255.0f, 0.0f);
            this.rect(iTileInTileSheetColumn * this.iTileSize, iTileInTileSheetRow * this.iTileSize + this.iLevelHeight, this.iTileSize - 1, this.iTileSize - 1);
            this.rect(iTileInTileSheetColumn * this.iTileSize + 1, iTileInTileSheetRow * this.iTileSize + this.iLevelHeight + 1, this.iTileSize - 3, this.iTileSize - 3);
            byte bTilesInTileSheetHorizontal = PApplet.parseByte((int)(this.pTileSheet.width / this.iTileSize));
            int iNumberOfClickedTileInTileSheet = iTileInTileSheetColumn + iTileInTileSheetRow * bTilesInTileSheetHorizontal;
            this.vMessage("Code " + PApplet.parseChar((int)(iNumberOfClickedTileInTileSheet + 46)));
        }
    }

    public void mousePressed() {
        if (this.mouseY < this.iLevelHeight) {
            int i = 0;
            while (i < this.tiles.length) {
                if (this.tiles[i].bClickCheck(this.mouseX, this.mouseY, this.iOffsetX)) {
                    this.bDragSwitchOn = !this.tiles[i].bGetIsClickedOn();
                }
                ++i;
            }
            if (this.bDragSwitchOn && !this.bKeyModifierPressed) {
                i = 0;
                while (i < this.tiles.length) {
                    if (this.tiles[i].bGetIsClickedOn()) {
                        this.tiles[i].vHilightClickedOff();
                        this.iTileClicked = -1;
                    }
                    ++i;
                }
            }
        }
    }

    public void mouseWheel(MouseEvent event) {
        if (this.mouseY < this.iLevelHeight) {
            this.iOffsetX += 20 * event.getCount();
            if (this.iOffsetX < 0) {
                this.iOffsetX = 0;
            } else if (this.iOffsetX > this.iTileNumberHorizontal * this.iTileSize - this.iScreenWidth) {
                this.iOffsetX = this.iTileNumberHorizontal * this.iTileSize - this.iScreenWidth;
            }
        }
    }

    public void redrawLevel() {
        this.vRectTrans(0, 0, this.iScreenWidth, this.iLevelHeight, PApplet.parseInt((float)((float)this.iTileSize * 0.5f)), this.cBg);
        int i = 0;
        while (i < this.tiles.length) {
            this.tiles[i].vDisplay(this.iOffsetX);
            ++i;
        }
        this.noStroke();
        this.fill(0, 50.0f);
        if (this.iOffsetX > 0) {
            this.rect(0.0f, 0.0f, (float)this.width * 0.05f, this.pTileSheet.height);
        }
        if (this.iOffsetX < this.iTileNumberHorizontal * this.iTileSize - this.iScreenWidth) {
            this.rect((float)this.width - (float)this.width * 0.05f, 0.0f, (float)this.width * 0.05f, this.iLevelHeight);
        }
    }

    public void redrawMinimap() {
        this.vRectTrans(0, this.iLevelHeight, this.iScreenWidth, this.pTileSheet.height, PApplet.parseInt((float)((float)this.iTileSize * 0.5f)), this.color(200, 0, 200));
        this.image(this.pTileSheet, 0.0f, this.iLevelHeight);
        if (this.bPaintMode) {
            if (this.iTileClickedInTileSheet >= 0) {
                byte bTilesInTileSheetHorizontal = PApplet.parseByte((int)(this.pTileSheet.width / this.iTileSize));
                int iTileInTileSheetColumn = this.iTileClickedInTileSheet % bTilesInTileSheetHorizontal;
                int iTileInTileSheetRow = this.iTileClickedInTileSheet / bTilesInTileSheetHorizontal;
                this.noFill();
                this.stroke(220.0f, 0.0f, 0.0f);
                this.rect(iTileInTileSheetColumn * this.iTileSize, iTileInTileSheetRow * this.iTileSize + this.iLevelHeight, this.iTileSize - 1, this.iTileSize - 1);
                this.rect(iTileInTileSheetColumn * this.iTileSize + 1, iTileInTileSheetRow * this.iTileSize + this.iLevelHeight + 1, this.iTileSize - 3, this.iTileSize - 3);
            }
        } else if (this.iTileClicked >= 0) {
            int i = 0;
            while (i < this.tiles.length) {
                if (this.tiles[i].bGetIsClickedOn()) {
                    int x = this.tiles[i].iGetTileCurrentTileHorizontal() * this.iTileSize;
                    int y = this.tiles[i].iGetTileCurrentTileVertical() * this.iTileSize;
                    this.noFill();
                    this.stroke(220.0f, 0.0f, 0.0f);
                    this.rect(x, y += this.iLevelHeight, this.iTileSize - 1, this.iTileSize - 1);
                    this.rect(x + 1, y + 1, this.iTileSize - 3, this.iTileSize - 3);
                    break;
                }
                ++i;
            }
        }
    }

    public void redrawStatusbar() {
        this.noStroke();
        this.fill(0.0f, 0.0f, 120.0f);
        this.rect(0.0f, this.iLevelHeight + this.pTileSheet.height, this.iScreenWidth, 24.0f);
        this.buttonSave.vDisplay();
    }

    public void draw() {
        int iDelta = this.millis() - this.iTicksLast;
        this.iTicksLast += iDelta;
        if (this.mouseY < this.iLevelHeight) {
            if ((float)this.mouseX < (float)this.width * 0.05f) {
                this.iOffsetX = (int)((float)this.iOffsetX - ((float)this.width * 0.1f - (float)this.mouseX) * (float)iDelta * 0.01f);
            } else if ((float)this.mouseX >= (float)this.width - (float)this.width * 0.05f) {
                this.iOffsetX = (int)((float)this.iOffsetX + ((float)this.mouseX - ((float)this.width - (float)this.width * 0.1f)) * (float)iDelta * 0.01f);
            }
            if (this.iOffsetX < 0) {
                this.iOffsetX = 0;
            } else if (this.iOffsetX > this.iTileNumberHorizontal * this.iTileSize - this.iScreenWidth) {
                this.iOffsetX = this.iTileNumberHorizontal * this.iTileSize - this.iScreenWidth;
            }
            if (this.mouseX != 0 && this.mouseY != 0) {
                int i = 0;
                while (i < this.tiles.length) {
                    if (this.tiles[i].bClickCheck(this.mouseX, this.mouseY, this.iOffsetX)) {
                        this.tiles[i].vHilightHoverOn();
                        this.vMessage("Code " + this.tiles[i].cGetTypeCode());
                    } else {
                        this.tiles[i].vHilightHoverOff();
                    }
                    ++i;
                }
            }
            this.redrawLevel();
        }
    }

    public void settings() {
        this.size(320, 536);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"clicky"};
        if (passedArgs != null) {
            PApplet.main((String[])clicky.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Button {
        byte bId = (byte)-1;
        int iPosX = 0;
        int iPosY = 0;
        int iWidth = 0;
        int iHeight = 0;
        PImage graphicsBlue = null;
        PImage graphicsRed = null;

        Button(int x, int y, int w, int h, PImage p, PImage q) {
            this.iPosX = x;
            this.iPosY = y;
            this.iWidth = w;
            this.iHeight = h;
            this.graphicsBlue = p;
            this.graphicsRed = q;
        }

        public boolean bClickCheck(int x, int y) {
            if (x >= this.iPosX && x < this.iPosX + this.iWidth && y >= this.iPosY && y < this.iPosY + this.iHeight) {
                this.vSave();
                return true;
            }
            return false;
        }

        public void vDisplay() {
            clicky.this.noStroke();
            clicky.this.fill(0.0f, 0.0f, 120.0f);
            clicky.this.rect(this.iPosX, this.iPosY, this.iWidth, this.iHeight, 3.0f);
            clicky.this.stroke(200);
            clicky.this.fill(255, 40.0f);
            clicky.this.rect(this.iPosX, this.iPosY, this.iWidth, this.iHeight, 3.0f);
            if (clicky.this.bUnsavedChanges) {
                clicky.this.image(this.graphicsRed, this.iPosX + 4, this.iPosY + 2);
            } else {
                clicky.this.image(this.graphicsBlue, this.iPosX + 4, this.iPosY + 2);
            }
            clicky.this.fill(255);
            clicky.this.fonty.alignCenter();
            clicky.this.fonty.output("SAVE", (float)this.iPosX + (float)this.iWidth * 0.5f + (float)this.graphicsBlue.width * 0.5f + 2.0f, (float)(this.iPosY + this.iHeight - 6));
        }

        public void vKeyPressed(char k) {
            if (k == 's') {
                this.vSave();
            }
        }

        public void vSave() {
            String[] lines = new String[clicky.this.iFileLinesNumber];
            int i = 0;
            while (i < lines.length) {
                lines[i] = "";
                ++i;
            }
            i = 0;
            while (i < clicky.this.tiles.length) {
                int iStringNumber = i / clicky.this.iTileNumberHorizontal;
                if (iStringNumber < clicky.this.iFileLinesNumber) {
                    int n = iStringNumber;
                    lines[n] = String.valueOf(lines[n]) + clicky.this.tiles[i].cGetTypeCode();
                }
                ++i;
            }
            clicky.this.saveStrings("data/level.txt", lines);
            clicky.println((String)"Saved");
            clicky.this.vMessage("Saved file level.txt");
            clicky.this.bUnsavedChanges = false;
            this.vDisplay();
        }
    }

    class Fonty {
        int iDotColumns = 6;
        int iDotRows = 9;
        int iBaseline;
        int iBaselineCurrent = this.iBaseline = -2;
        int iWidth = this.iDotColumns;
        int iHeight = this.iDotRows;
        int iLettersNumber = 128;
        Letter[] letters = new Letter[this.iLettersNumber];
        byte bAlign = 0;
        int iDotsNumber = this.iDotColumns * this.iDotRows;
        int iGap = 0;
        float fGap = 0.05f;

        Fonty() {
        }

        public void vInit() {
            int i = 0;
            while (i < this.letters.length) {
                this.letters[i] = new Letter(i, this.iDotColumns, this.iDotRows);
                ++i;
            }
        }

        public void vSetAlign(byte a) {
            this.bAlign = a;
        }

        public void vSetHeight(int h) {
            if (h < 1) {
                h = this.iDotRows;
            }
            this.iHeight = h;
            float fScale = PApplet.parseFloat((int)h) / (float)this.iDotRows;
            this.iWidth = PApplet.parseInt((float)((float)this.iDotColumns * fScale));
            this.iBaselineCurrent = PApplet.parseInt((float)((float)this.iBaseline * fScale));
        }

        public void vOutput(String s, int x, int y) {
            float fStrokeWeightCurrent = clicky.this.getGraphics().strokeWeight;
            float fStrokeColourCurrent = clicky.this.getGraphics().strokeColor;
            if (this.iHeight % this.iDotRows == 0) {
                clicky.this.noStroke();
            } else {
                clicky.this.stroke(clicky.this.getGraphics().fillColor);
                clicky.this.strokeWeight(1.0f);
            }
            float fScale = 1.0f;
            if (this.iHeight != this.iDotRows) {
                fScale = PApplet.parseFloat((int)this.iHeight) / (float)this.iDotRows;
            }
            if (this.bAlign != 0) {
                int iStringLengthPixels;
                if (this.bAlign == 1) {
                    iStringLengthPixels = s.length() * this.iDotColumns;
                    x = (int)((float)x - (float)iStringLengthPixels * fScale);
                } else {
                    iStringLengthPixels = s.length() * this.iDotColumns;
                    x = (int)((float)x - (float)iStringLengthPixels * 0.5f * fScale);
                }
            }
            int i = 0;
            while (i < s.length()) {
                char cDisplay = s.charAt(i);
                if (cDisplay >= ' ' && cDisplay < this.iLettersNumber) {
                    this.letters[cDisplay].vDisplay(x, y - this.iBaselineCurrent, this.iHeight, this.iDotColumns, this.iDotRows, fScale);
                }
                x += this.iWidth;
                ++i;
            }
            clicky.this.strokeWeight(fStrokeWeightCurrent);
            clicky.this.stroke(fStrokeColourCurrent);
        }

        public void alignLeft() {
            this.vSetAlign(PApplet.parseByte((int)0));
        }

        public void alignRight() {
            this.vSetAlign(PApplet.parseByte((int)1));
        }

        public void alignCenter() {
            this.vSetAlign(PApplet.parseByte((int)2));
        }

        public void height(int h) {
            this.vSetHeight(h);
        }

        public void output(String s, float x, float y) {
            this.vOutput(s, PApplet.parseInt((float)x), PApplet.parseInt((float)y));
        }

        public void output(String s, int x, int y) {
            this.vOutput(s, x, y);
        }
    }

    class Letter {
        int iId = -1;
        boolean[][] letterDots;

        Letter(int l, int iDotColumns, int iDotRows) {
            this.iId = l;
            this.letterDots = new boolean[iDotColumns][iDotRows];
            PImage sheet = clicky.this.loadImage("font.png");
            PImage oneLetter = sheet.get(this.iId * iDotColumns, 0, iDotColumns, iDotRows);
            int j = 0;
            while (j < oneLetter.height) {
                int i = 0;
                while (i < oneLetter.width) {
                    this.letterDots[i][j] = oneLetter.get(i, j) != clicky.this.color(0);
                    ++i;
                }
                ++j;
            }
        }

        public void vDisplay(int x, int y, int h, int iDotColumns, int iDotRows, float fScale) {
            if (h == iDotRows) {
                int j = 0;
                while (j < iDotRows) {
                    int i = 0;
                    while (i < iDotColumns) {
                        if (this.letterDots[i][j]) {
                            clicky.this.rect(x + i, y + j - h, 1.0f, 1.0f);
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < iDotRows) {
                    int i = 0;
                    while (i < iDotColumns) {
                        if (this.letterDots[i][j]) {
                            clicky.this.rect((float)x + (float)i * fScale, (float)y + (float)j * fScale - (float)h, fScale, fScale);
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
    }

    class Tile {
        int iId = -1;
        int iPosX = 0;
        int iPosY = 0;
        int iTileCurrent = 0;
        boolean bHilightHover = false;
        boolean bHilightClicked = false;

        Tile(int n) {
            this.iId = n;
        }

        public boolean bClickCheck(int x, int y, int hor) {
            return x + hor >= this.iPosX && x + hor < this.iPosX + clicky.this.iTileSize && y >= this.iPosY && y < this.iPosY + clicky.this.iTileSize;
        }

        public boolean bGetIsClickedOn() {
            return this.bHilightClicked;
        }

        public char cGetTypeCode() {
            return PApplet.parseChar((int)(this.iTileCurrent + 46));
        }

        public int iGetTileCurrentTileHorizontal() {
            byte bTilesInTileSheetHorizontal = PApplet.parseByte((int)(clicky.this.pTileSheet.width / clicky.this.iTileSize));
            return this.iTileCurrent % bTilesInTileSheetHorizontal;
        }

        public int iGetTileCurrentTileVertical() {
            byte bTilesInTileSheetHorizontal = PApplet.parseByte((int)(clicky.this.pTileSheet.width / clicky.this.iTileSize));
            return this.iTileCurrent / bTilesInTileSheetHorizontal;
        }

        public void vAdd(int n, int x, int y) {
            this.iTileCurrent = n;
            this.iPosX = x * clicky.this.iTileSize;
            this.iPosY = y * clicky.this.iTileSize;
        }

        public void vDisplay(int hor) {
            if (this.iPosX - hor < -clicky.this.iTileSize || this.iPosX - hor >= clicky.this.iScreenWidth) {
                return;
            }
            byte bTilesInTileSheetHorizontal = PApplet.parseByte((int)(clicky.this.pTileSheet.width / clicky.this.iTileSize));
            byte bColumn = PApplet.parseByte((int)(this.iTileCurrent % bTilesInTileSheetHorizontal));
            byte bRow = PApplet.parseByte((int)(this.iTileCurrent / bTilesInTileSheetHorizontal));
            clicky.this.image(clicky.this.pTileSheet.get(bColumn * clicky.this.iTileSize, bRow * clicky.this.iTileSize, clicky.this.iTileSize, clicky.this.iTileSize), this.iPosX - hor, this.iPosY, clicky.this.iTileSize, clicky.this.iTileSize);
            if (this.bHilightClicked) {
                clicky.this.noFill();
                clicky.this.stroke(255.0f, 0.0f, 0.0f);
                clicky.this.rect(this.iPosX - hor, this.iPosY, clicky.this.iTileSize - 1, clicky.this.iTileSize - 1);
                clicky.this.rect(this.iPosX - hor + 1, this.iPosY + 1, clicky.this.iTileSize - 3, clicky.this.iTileSize - 3);
            } else if (this.bHilightHover) {
                clicky.this.noFill();
                clicky.this.stroke(255.0f, 255.0f, 0.0f);
                clicky.this.rect(this.iPosX - hor, this.iPosY, clicky.this.iTileSize - 1, clicky.this.iTileSize - 1);
                clicky.this.rect(this.iPosX - hor + 1, this.iPosY + 1, clicky.this.iTileSize - 3, clicky.this.iTileSize - 3);
            }
        }

        public void vHilightClickedOff() {
            this.bHilightClicked = false;
        }

        public void vHilightClickedOn() {
            this.bHilightClicked = true;
        }

        public void vHilightHoverOff() {
            this.bHilightHover = false;
        }

        public void vHilightHoverOn() {
            this.bHilightHover = true;
        }

        public void vSetCode(int n) {
            if (this.iTileCurrent != n) {
                this.iTileCurrent = n;
                clicky.this.bUnsavedChanges = true;
                clicky.this.buttonSave.vDisplay();
            }
        }
    }
}

